/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.acutvista;

import de.seetec.v5.re.cm.device.shared.cameracontrol.CameraControl;
import de.seetec.v5.re.cm.device.shared.cameracontrol.PresetCnf;
import de.seetec.v5.re.cm.shared.communication.VideoServiceClientRequestHandler;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Vector;

public class AcutvistaCameraControl
extends CameraControl {
    private int sendCameraCommand(String url) {
        try {
            String completeURL = "/ptz.cgi?" + url;
            completeURL = completeURL.replace("?&", "?");
            this.videoSrv.notifyForCameraControl();
            NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)completeURL);
            return 0;
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            return -21600;
        }
    }

    @Override
    public int setAbsolutePTZ(VideoServiceClientRequestHandler sender, Integer pan, Integer tilt, Integer zoom) {
        throw new RuntimeException("NOT YET IMPLEMENTED");
    }

    @Override
    public int setContinuousPTZ(Integer panSpeed, Integer tiltSpeed, Integer zoomSpeed) {
        int zoom;
        int tilt;
        int pan;
        StringBuilder sb = new StringBuilder(256);
        if (panSpeed != null) {
            this.previousPanSpeed = pan = panSpeed / 1000;
        } else {
            pan = this.previousPanSpeed;
        }
        if (tiltSpeed != null) {
            this.previousTiltSpeed = tilt = tiltSpeed / 1000;
        } else {
            tilt = this.previousTiltSpeed;
        }
        if (zoomSpeed != null) {
            this.previousZoomSpeed = zoom = zoomSpeed / 1000;
        } else {
            zoom = this.previousZoomSpeed;
        }
        try {
            int errorCode;
            if (panSpeed != null || tiltSpeed != null) {
                sb.append("&continuouspantiltmove=");
                sb.append(pan);
                sb.append(",");
                sb.append(tilt);
                errorCode = this.sendCameraCommand(sb.toString());
                if (errorCode != 0) {
                    this.logger.error("Error while sending PT command for " + this);
                    return errorCode;
                }
            }
            if (zoomSpeed != null) {
                sb = new StringBuilder(256);
                sb.append("&continuouszoommove=");
                sb.append(zoom);
                errorCode = this.sendCameraCommand(sb.toString());
                if (errorCode != 0) {
                    this.logger.error("Error while sending Zoom command for " + this);
                    return errorCode;
                }
            }
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            return -21600;
        }
        return 0;
    }

    @Override
    public int setCenterPT(Integer xPosition, Integer yPosition, int[] resolution) {
        throw new RuntimeException("NOT YET IMPLEMENTED");
    }

    @Override
    public int setZoomArea(Integer xPosition, Integer yPosition, Integer width, Integer heigth, int[] resolution) {
        throw new RuntimeException("NOT YET IMPLEMENTED");
    }

    @Override
    public int setAbsoluteIris(Integer value) {
        throw new RuntimeException("NOT YET IMPLEMENTED");
    }

    @Override
    public int setContinuousIris(Integer value) {
        return this.sendCameraCommand("&riris=" + value);
    }

    @Override
    public int setAutoIris(Boolean active) {
        if (active.booleanValue()) {
            return this.sendCameraCommand("&autoiris=on");
        }
        return this.sendCameraCommand("&autoiris=off");
    }

    @Override
    public int setAbsoluteFocus(Integer value) {
        throw new RuntimeException("NOT YET IMPLEMENTED");
    }

    @Override
    public int setContinuousFocus(Integer value) {
        return this.sendCameraCommand("&rfocus=" + value);
    }

    @Override
    public int setAutoFocus(Boolean active) {
        if (active.booleanValue()) {
            return this.sendCameraCommand("&autofocus=on");
        }
        return this.sendCameraCommand("&autofocus=off");
    }

    @Override
    public int setZeroLux(Boolean active) {
        try {
            if (active.booleanValue()) {
                NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)"/cgi-bin/param.cgi?action=update&ImageSource.I0.DayNight.ICR=night");
            } else {
                NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)"/cgi-bin/param.cgi?action=update&ImageSource.I0.DayNight.ICR=day");
            }
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception occured while setting Day/Night mode on " + this + ": " + ex.getMessage());
        }
        return 0;
    }

    @Override
    public int setAutoZeroLux(Boolean active) {
        try {
            if (active.booleanValue()) {
                NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)"/cgi-bin/param.cgi?action=update&ImageSource.I0.DayNight.ICR=auto");
            }
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception occured while setting auto day/night mode on " + this + ": " + ex.getMessage());
        }
        return 0;
    }

    @Override
    public int setHomePosition() {
        return 0;
    }

    @Override
    public int addPresetPosition(Vector<byte[]> result, Long presetID, String presetName) {
        try {
            String encodedPresetName = URLEncoder.encode(presetName.trim(), "UTF-8");
            this.sendCameraCommand("&setserverpresetname=" + encodedPresetName);
            PresetCnf presetCnf = PresetCnf.createPresetCnf((long)presetID, encodedPresetName);
            this.presetList.addElement(presetCnf);
            result.addElement(presetCnf.getPresetCnf());
            return 0;
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }

    @Override
    public int setPresetPosition(String presetName) {
        try {
            String encodedPresetName = URLEncoder.encode(presetName.trim(), "UTF-8");
            for (int i = 0; i < this.presetList.size(); ++i) {
                PresetCnf presetCnf = this.presetList.elementAt(i);
                if (!encodedPresetName.equals(presetCnf.getPresetName())) continue;
                int errorCode = this.sendCameraCommand("&speed=100&gotoserverpresetname=" + presetCnf.getPresetName());
                return errorCode;
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)ex, (Throwable)ex);
            this.logger.error("Setting preset [" + presetName + "] failed");
            return -21600;
        }
        this.logger.error("Preset [" + presetName + "] not available");
        this.logger.error("PresetList=" + this.presetList);
        return -21683;
    }

    @Override
    public int removePresetPosition(String presetName) {
        try {
            String encodedPresetName = URLEncoder.encode(presetName.trim(), "UTF-8");
            for (int i = 0; i < this.presetList.size(); ++i) {
                PresetCnf presetCnf = (PresetCnf)this.presetList.elementAt(i);
                if (!encodedPresetName.equals(presetCnf.getPresetName())) continue;
                this.logger.info("Removing preset: " + new String(presetCnf.getPresetCnf()));
                this.presetList.removeElementAt(i);
                int errorCode = this.sendCameraCommand("&removeserverpresetname=" + presetCnf.getPresetName());
                if (errorCode != 0) {
                    this.logger.warn("Removing preset [" + presetCnf.getPresetName() + "] from " + this + " failed with error [" + errorCode + "]");
                }
                return 0;
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)ex, (Throwable)ex);
            this.logger.error("Removing preset [" + presetName + "] failed");
            return -21600;
        }
        this.logger.error("Preset [" + presetName + "] not available\n\tPresetList = " + this.presetList);
        return -21683;
    }
}

