/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.acti.mpeg;

import de.seetec.v5.re.cm.device.shared.net.TCPNetworkCallback;
import de.seetec.v5.shared.Basic;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ActiTCPReader
extends Basic
implements Runnable {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.acti.mpeg.ActiTCPReader";
    private static final int DELAY = 5500;
    private final byte[] B2HEADER = new byte[]{0, 0, 1, -78};
    private Logger logger = null;
    private Thread myThread = null;
    private TCPNetworkCallback callback;
    private boolean authResponseReached = false;
    private ControlSocketReader controlSocketReader = null;
    private Socket socket = null;
    private InputStream is = null;
    private OutputStream os = null;
    private long streamID = 0L;

    public int init(String host, int controlPort, int videoPort, String user, String pass, TCPNetworkCallback callback, long streamID) {
        if (host == null || user == null || pass == null) {
            return -21601;
        }
        if (controlPort <= 0 || controlPort > 65535 || videoPort <= 0 || videoPort > 65535) {
            return -21601;
        }
        this.callback = callback;
        this.streamID = streamID > 0L ? (streamID = streamID - 1L) : 0L;
        this.logger = LogManager.getLogger((String)CLASS_NAME);
        this.controlSocketReader = new ControlSocketReader();
        int errorCode = this.controlSocketReader.init(host, controlPort, user, pass, this);
        if (errorCode != 0) {
            this.logger.error("Control connection to " + host + ":" + controlPort + " failed. errorCode: " + errorCode);
            return errorCode;
        }
        try {
            this.socket = new Socket(host, videoPort);
            this.socket.setSoTimeout(50);
            this.os = this.socket.getOutputStream();
            this.is = this.socket.getInputStream();
        }
        catch (Exception e) {
            this.logger.error("Problem while initiating socket to: " + host + ":" + videoPort, (Throwable)e);
            return -20000;
        }
        this.myThread = new Thread((Runnable)this, this.toString());
        this.myThread.start();
        try {
            byte[] authorization = new byte[128];
            System.arraycopy(user.getBytes(), 0, authorization, 0, user.getBytes().length);
            System.arraycopy(pass.getBytes(), 0, authorization, 64, pass.getBytes().length);
            authorization[60] = (byte)streamID;
            this.os.write(authorization);
            this.os.flush();
        }
        catch (Exception e) {
            this.logger.error("Problem while sending authorization to: " + host + ":" + videoPort, (Throwable)e);
            return -20000;
        }
        return 0;
    }

    public int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        if (this.controlSocketReader != null) {
            this.controlSocketReader.shutdown();
            this.controlSocketReader = null;
        }
        try {
            if (this.socket != null) {
                this.socket.close();
                this.socket = null;
                this.is = null;
                this.os = null;
            }
        }
        catch (Exception e) {
            this.logger.error("Exception closing stream", (Throwable)e);
        }
        this.callback = null;
        return 0;
    }

    @Override
    public final void run() {
        long lastDeliveredFrame = System.currentTimeMillis();
        boolean turnOnDelayStat = false;
        byte[] pattern = null;
        long patternFilled = 0L;
        long delayCummulated = 0L;
        long processedImages = 0L;
        long maxDelay = 0L;
        super.setRunFinished(CLASS_NAME, false);
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            this.logger.info("Use v2 implementation for " + this.callback + ".");
            block6: while (!this.isShutdown(CLASS_NAME)) {
                if (System.currentTimeMillis() > lastDeliveredFrame + 5500L) {
                    this.logger.error("Last images received on: " + new Date(lastDeliveredFrame).toString());
                    this.callback.onNetworkError(-21603);
                }
                try {
                    int len;
                    byte[] buffer = new byte[4096];
                    try {
                        len = this.is.read(buffer);
                    }
                    catch (SocketTimeoutException ste) {
                        continue;
                    }
                    if (len <= 0) {
                        this.callback.onNetworkError(-21603);
                        break;
                    }
                    if (!this.authResponseReached) {
                        if (buffer[0] != 0) {
                            this.logger.error("Login FAILED on socket: " + this.socket.toString());
                            this.callback.onNetworkError(-21657);
                        } else {
                            bos.write(buffer, 128, len - 128);
                        }
                        this.authResponseReached = true;
                    } else {
                        if (turnOnDelayStat) {
                            int index;
                            if (pattern == null && len > 50) {
                                pattern = new byte[50];
                                System.arraycopy(buffer, len / 2 - 25, pattern, 0, 50);
                                patternFilled = System.currentTimeMillis();
                            }
                            if ((index = Basic.indexOfByteArray((byte[])buffer, (byte[])this.B2HEADER, (int)0, (int)buffer.length, (boolean)true)) != -1 && buffer.length >= index + 16) {
                                byte[] time = new byte[]{buffer[index + 15], buffer[index + 14], buffer[index + 13], buffer[index + 12]};
                                long timestamp = Basic.byteArrayToInt8((byte[])time) * 1000L;
                                long nowLocal = System.currentTimeMillis();
                                delayCummulated += nowLocal - timestamp;
                                if (++processedImages % 200L == 0L) {
                                    this.logger.info("v2 avg. difference: " + delayCummulated / processedImages);
                                    ++processedImages;
                                    ++delayCummulated;
                                }
                                if (nowLocal - timestamp > 1500L) {
                                    this.logger.warn("v2 Image timestamp is " + (nowLocal - timestamp) + "ms older than local time (Max so far " + maxDelay + ").");
                                    this.logger.info("v2 -Time read from image vs local: " + new Date(timestamp).toString() + "/" + new Date(nowLocal).toString());
                                    if (nowLocal - timestamp > maxDelay) {
                                        maxDelay = nowLocal - timestamp;
                                    }
                                }
                            }
                        }
                        bos.write(buffer, 0, len);
                    }
                    byte[] queue = bos.toByteArray();
                    bos.reset();
                    if (queue.length <= 0) continue;
                    int secondIndex = 0;
                    while (secondIndex != -1) {
                        int firstIndex = Basic.indexOfByteArray((byte[])queue, (byte[])this.B2HEADER, (int)secondIndex, (int)(queue.length - secondIndex), (boolean)true);
                        if (firstIndex == -1) {
                            this.logger.warn("NO B2 header in complete buffer '" + queue.length + "'. Delete it!");
                            continue block6;
                        }
                        secondIndex = Basic.indexOfByteArray((byte[])queue, (byte[])this.B2HEADER, (int)(firstIndex + 4), (int)(queue.length - (firstIndex + 4)), (boolean)true);
                        if (secondIndex != -1) {
                            if (secondIndex - firstIndex < 44) {
                                this.logger.fatal("Frame does not contain a complete 44-Byte B2-Header! Discard!");
                                continue;
                            }
                            byte[] frame = new byte[secondIndex - firstIndex];
                            System.arraycopy(queue, firstIndex, frame, 0, secondIndex - firstIndex);
                            long deliverTime = System.currentTimeMillis();
                            this.callback.onTcpData(frame);
                            if (turnOnDelayStat && pattern != null && Basic.indexOfByteArray((byte[])frame, (byte[])pattern, (int)0, (int)frame.length, (boolean)true) != -1 && System.currentTimeMillis() - patternFilled > 500L) {
                                this.logger.info("Pattern delivered after " + (System.currentTimeMillis() - patternFilled) + "ms.");
                                pattern = null;
                            }
                            if (System.currentTimeMillis() - deliverTime > 300L) {
                                this.logger.warn("v2 delivery took long: " + (System.currentTimeMillis() - deliverTime));
                            }
                            lastDeliveredFrame = System.currentTimeMillis();
                            continue;
                        }
                        bos.write(queue, firstIndex, queue.length - firstIndex);
                        continue block6;
                    }
                }
                catch (Throwable t) {
                    if (this.isShutdown(CLASS_NAME)) continue;
                    this.logger.error((Object)t, t);
                    this.callback.onNetworkError(-20001);
                    break;
                }
            }
            super.setRunFinished(CLASS_NAME, true);
            this.shutdown();
        }
        catch (Throwable ex) {
            this.logger.fatal((Object)ex, ex);
            this.shutdown();
        }
    }

    private class ControlSocketReader
    extends Basic
    implements Runnable {
        private static final String CLASSNAME = "de.seetec.v5.re.cm.device.video.acti.mpeg.ActiTCPReader.ControlSocketReader";
        private Thread thread = null;
        private Socket controlSocket = null;
        private boolean authResponseReached = false;
        private InputStream is = null;
        private OutputStream os = null;
        private ActiTCPReader listener = null;

        private ControlSocketReader() {
        }

        public int init(String host, int port, String user, String pass, ActiTCPReader listener) {
            this.listener = listener;
            try {
                this.controlSocket = new Socket(host, port);
                this.os = this.controlSocket.getOutputStream();
                this.is = this.controlSocket.getInputStream();
                this.controlSocket.setKeepAlive(true);
                this.controlSocket.setSoTimeout(50);
            }
            catch (Exception e) {
                ActiTCPReader.this.logger.error("Error while creating control connection to:" + host + ":" + port, (Throwable)e);
                return -20000;
            }
            this.thread = new Thread((Runnable)this, this.toString());
            this.thread.start();
            try {
                byte[] authorization = new byte[128];
                System.arraycopy(user.getBytes(), 0, authorization, 0, user.getBytes().length);
                System.arraycopy(pass.getBytes(), 0, authorization, 64, pass.getBytes().length);
                authorization[32] = 1;
                authorization[60] = (byte)ActiTCPReader.this.streamID;
                this.os.write(authorization);
                this.os.flush();
            }
            catch (Exception e) {
                ActiTCPReader.this.logger.error("Error while writing to control connection on:" + this.controlSocket.toString(), (Throwable)e);
                return -20000;
            }
            long time = System.currentTimeMillis();
            while (!this.authResponseReached) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (System.currentTimeMillis() <= time + 10000L) continue;
                ActiTCPReader.this.logger.error("No response to authorization after 10 seconds. Aborting...");
                super.setRunFinished(CLASSNAME, true);
                this.shutdown();
                return -20000;
            }
            return 0;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public final void run() {
            long time = Long.MIN_VALUE;
            byte[] keepAlive = new byte[12];
            keepAlive[0] = 65;
            keepAlive[1] = 67;
            keepAlive[2] = 84;
            keepAlive[3] = 105;
            keepAlive[4] = 48;
            super.setRunFinished(CLASSNAME, false);
            try {
                while (!this.isShutdown(CLASSNAME)) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (Exception ex) {
                        ActiTCPReader.this.logger.error("Problem while sleeping: " + ex, (Throwable)ex);
                    }
                    try {
                        int len;
                        if (System.currentTimeMillis() > time + 10000L) {
                            this.os.write(keepAlive);
                            this.os.flush();
                            time = System.currentTimeMillis();
                        }
                        byte[] buffer = new byte[4096];
                        try {
                            len = this.is.read(buffer);
                        }
                        catch (SocketTimeoutException ste) {
                            continue;
                        }
                        if (len <= 0 || this.authResponseReached) continue;
                        if (buffer[0] != 0) {
                            ActiTCPReader.this.logger.error("Control Login FAILED on " + this.controlSocket.toString());
                            if (this.listener == null || ActiTCPReader.this.callback == null) break;
                            this.listener.callback.onNetworkError(-21657);
                            this.authResponseReached = true;
                            break;
                        }
                        this.authResponseReached = true;
                    }
                    catch (SocketException sex) {
                        if (this.isShutdown(CLASSNAME)) continue;
                        ActiTCPReader.this.logger.warn((Object)sex, (Throwable)sex);
                        break;
                    }
                    catch (IOException ioex) {
                        if (this.isShutdown(CLASSNAME)) continue;
                        ActiTCPReader.this.logger.warn((Object)ioex, (Throwable)ioex);
                        break;
                    }
                    catch (Throwable t) {
                        ActiTCPReader.this.logger.fatal("Unexpected exception", t);
                    }
                }
                super.setRunFinished(CLASSNAME, true);
                this.shutdown();
                return;
            }
            catch (Throwable ex) {
                ActiTCPReader.this.logger.fatal((Object)ex, ex);
                this.shutdown();
            }
        }

        public int shutdown() {
            if (this.startShutdown(CLASSNAME)) {
                return 0;
            }
            if (this.controlSocket != null) {
                try {
                    this.is.close();
                    this.is = null;
                    this.os.close();
                    this.os = null;
                    this.controlSocket.close();
                    this.controlSocket = null;
                }
                catch (Exception e) {
                    ActiTCPReader.this.logger.info("Error shutting down ControlSocket. Exception: " + e.getMessage());
                }
            }
            this.listener = null;
            return 0;
        }
    }
}

