/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.acti;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.device.shared.LiveCameraSrv;
import de.seetec.v5.re.cm.device.shared.cameracontrol.CameraControl;
import de.seetec.v5.re.cm.device.shared.videoprofile.BasicVideoProfileHandler;
import de.seetec.v5.re.cm.device.shared.videoprofile.VideoProfileHandler;
import de.seetec.v5.re.cm.device.shared.videosource.VideoSourceClient;
import de.seetec.v5.re.cm.device.video.acti.ActiCameraControl;
import de.seetec.v5.re.cm.device.video.acti.ActiCameraControlPelcoD;
import de.seetec.v5.re.cm.device.video.acti.ActiDevice;
import de.seetec.v5.re.cm.device.video.acti.mpeg.ActiMPEGVideoSourceClient;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.re.shared.ContentFrame;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.Hashtable;

public class ActiCameraSrv
extends LiveCameraSrv {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.acti.ActiCameraSrv";
    private int streamID = 1;
    private boolean isMultiStreamingUsed = false;
    private final Hashtable<String, Integer> dynToStream = new Hashtable();
    private int streamIDforBasicProfile = -1;
    private int streamIDforAdditionalProfile = -1;

    @Override
    public CameraControl createCameraControl(Long entityType) {
        if (entityType != null) {
            if (entityType == 211145L || entityType == 211146L || entityType == 211147L || entityType == 211150L || entityType == 211151L || entityType == 211148L || entityType == 211153L || entityType == 211159L || entityType == 211160L || entityType == 211161L || entityType == 211162L || entityType == 211163L || entityType == 211155L) {
                return new ActiCameraControl();
            }
            return new ActiCameraControlPelcoD();
        }
        return new ActiCameraControlPelcoD();
    }

    @Override
    public VideoSourceClient createVideoSourceClient(Core core, VideoProfileHandler listener) throws SeeTecException {
        ActiMPEGVideoSourceClient videoSourceClient = null;
        try {
            int errorCode;
            videoSourceClient = new ActiMPEGVideoSourceClient();
            this.isMultiStreamingUsed = this.getAdditionalVideoProfileHandler().length >= 1;
            long[][] values = this.createQuery(this.isMultiStreamingUsed);
            if (this.isMultiStreamingUsed) {
                if (((ActiDevice)this.getDevice()).isEorDSeries()) {
                    VideoProfileHandler basicVideoProfileHandler = this.getBasicVideoProfileHandler();
                    VideoProfileHandler additionalVideoProfileHandler = this.getAdditionalVideoProfileHandler()[0];
                    int widthBaseProfile = basicVideoProfileHandler.getVideoSourceParameter().getImageSize()[0];
                    int widthAddProfile = additionalVideoProfileHandler.getVideoSourceParameter().getImageSize()[0];
                    if (this.dynToStream.isEmpty()) {
                        if (widthAddProfile > widthBaseProfile) {
                            this.dynToStream.put("" + additionalVideoProfileHandler.getDynamicVideoProfileID(), 1);
                            this.dynToStream.put("" + basicVideoProfileHandler.getDynamicVideoProfileID(), 2);
                        } else {
                            this.dynToStream.put("" + basicVideoProfileHandler.getDynamicVideoProfileID(), 1);
                            this.dynToStream.put("" + additionalVideoProfileHandler.getDynamicVideoProfileID(), 2);
                        }
                    }
                    if ((errorCode = this.checkAndSetResolutions()) != 0) {
                        this.logger.warn("Error while setting resolutions for " + this + ", error code: " + errorCode);
                    }
                } else {
                    errorCode = this.setResolutions(listener);
                    if (errorCode != 0) {
                        this.logger.warn("Error while setting resolutions for " + this + ", error code: " + errorCode);
                    }
                    if (this.dynToStream.get("" + listener.getDynamicVideoProfileID()) == null) {
                        this.dynToStream.put("" + listener.getDynamicVideoProfileID(), this.streamID);
                        ++this.streamID;
                    }
                }
                videoSourceClient.setStreamID(this.dynToStream.get("" + listener.getDynamicVideoProfileID()).intValue());
                videoSourceClient.setAllowedValues(values[this.dynToStream.get("" + listener.getDynamicVideoProfileID()) - 1]);
            } else if (((ActiDevice)this.getDevice()).isEorDSeries()) {
                videoSourceClient.setStreamID(1L);
                videoSourceClient.setAllowedValues(values[0]);
            } else {
                videoSourceClient.setStreamID(0L);
                videoSourceClient.setAllowedValues(values[0]);
            }
            errorCode = videoSourceClient.init(core, this, listener);
            if (errorCode != 0) {
                videoSourceClient.shutdown();
                videoSourceClient = null;
                throw new SeeTecException(errorCode, "Initializing [VideoSourceClient] for " + this + " failed with error [" + errorCode + "]");
            }
        }
        catch (SeeTecException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            if (videoSourceClient != null) {
                videoSourceClient.shutdown();
                videoSourceClient = null;
            }
            throw new SeeTecException(-20001, "Creating [VideoSourceClient] for " + this + " failed");
        }
        return videoSourceClient;
    }

    private long[][] createQuery(boolean isMultiStreamingUsed) {
        StringBuilder queryString = new StringBuilder("/cgi-bin/encoder?");
        long[][] allowedValues = new long[2][];
        try {
            NetworkParameter networkParameter = this.getDevice().getDeviceCnf().getNetworkParameter();
            int videoSourceNr = this.getBasicVideoProfileHandler().getVideoSourceParameter().getServerEntryNo();
            queryString.append("USER=");
            queryString.append(networkParameter.getUserPWD()[0]);
            queryString.append("&PWD=");
            queryString.append(networkParameter.getUserPWD()[1]);
            queryString.append("&CHANNEL=");
            queryString.append(videoSourceNr);
            int[] resolutionBasic = this.getBasicVideoProfileHandler().getVideoSourceParameter().getImageSize();
            String resolutionTagBasic = this.getBasicVideoProfileHandler().getVideoSourceParameter().getResolution();
            Codec videoCodecBasic = this.getBasicVideoProfileHandler().getVideoSourceParameter().getMediaCodec();
            if (resolutionBasic.length == 2) {
                resolutionTagBasic = resolutionTagBasic + resolutionBasic[0] + "x" + resolutionBasic[1];
            }
            String encoderTypeBasic = this.deliverEncoderType(videoCodecBasic);
            if (isMultiStreamingUsed) {
                int[] resolutionAdd = this.getAdditionalVideoProfileHandler()[0].getVideoSourceParameter().getImageSize();
                String resolutionTagAdd = this.getAdditionalVideoProfileHandler()[0].getVideoSourceParameter().getResolution();
                Codec videoCodecAdd = this.getAdditionalVideoProfileHandler()[0].getVideoSourceParameter().getMediaCodec();
                if (resolutionAdd.length == 2) {
                    resolutionTagAdd = resolutionTagAdd + resolutionAdd[0] + "x" + resolutionAdd[1];
                }
                String encoderTypeAdd = this.deliverEncoderType(videoCodecAdd);
                queryString.append("&FPS_CAP_QUERY_ALL=DUAL,");
                queryString.append(encoderTypeBasic);
                queryString.append(",");
                queryString.append(resolutionTagBasic);
                queryString.append(",");
                queryString.append(encoderTypeAdd);
                queryString.append(",");
                queryString.append(resolutionTagAdd);
            } else {
                queryString.append("&FPS_CAP_QUERY_ALL=SINGLE,");
                queryString.append(encoderTypeBasic);
                queryString.append(",");
                queryString.append(resolutionTagBasic);
            }
            byte[] result = NetworkHelper.readGetRequest((NetworkParameter)networkParameter, (String)queryString.toString(), (int)Integer.MAX_VALUE);
            if (result == null) {
                this.logger.warn("No fps cap list available on " + this);
                return new long[2][];
            }
            String content = new String(result);
            String CAP_QUERY = "FPS_CAP_QUERY_ALL='";
            int position = content.indexOf("FPS_CAP_QUERY_ALL='");
            if (position != -1) {
                content = content.substring(position + "FPS_CAP_QUERY_ALL='".length());
                position = (content = content.substring(0, content.indexOf("'"))).indexOf(";");
                if (position != -1) {
                    String[] streamContent = content.split(";");
                    if (streamContent.length == 2) {
                        for (int i = 0; i <= 1; ++i) {
                            this.logger.info("Set for stream " + (i + 1) + ": " + streamContent[i] + " for " + this);
                            String[] part = streamContent[i].split(",");
                            if (part.length <= 0) continue;
                            allowedValues[i] = new long[part.length];
                            for (int j = 0; j < part.length; ++j) {
                                allowedValues[i][j] = Long.parseLong(part[j]);
                            }
                        }
                    }
                } else {
                    this.logger.info("Set for single stream: " + content);
                    String[] part = content.split(",");
                    if (part.length > 0) {
                        allowedValues[0] = new long[part.length];
                        for (int j = 0; j < part.length; ++j) {
                            allowedValues[0][j] = Long.parseLong(part[j]);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            this.logger.warn("No fps cap list available or problem parsing it on " + this);
            return new long[2][];
        }
        return allowedValues;
    }

    private String deliverEncoderType(Codec videoCodec) {
        String encoderTye = "MJPEG";
        if (videoCodec != null) {
            switch (videoCodec) {
                case MPEG4: {
                    encoderTye = "MPEG4";
                    break;
                }
                case H264: {
                    encoderTye = "H264";
                    break;
                }
                default: {
                    encoderTye = "MJPEG";
                }
            }
        }
        return encoderTye;
    }

    @Override
    public ContentFrame getJpegSnapshot(Integer[] nResolution) throws SeeTecException {
        throw new SeeTecException(-20009, "NOT YET IMPLEMENTED");
    }

    public boolean isMultiStreamingUsed() {
        return this.isMultiStreamingUsed;
    }

    public boolean useEncoderPrefix() {
        if (this.isMultiStreamingUsed()) {
            return true;
        }
        return ((ActiDevice)this.getDevice()).isEorDSeries();
    }

    private int setResolutions(VideoProfileHandler videoProfileHandler) {
        StringBuilder setResolution = new StringBuilder("/cgi-bin/encoder?");
        try {
            NetworkParameter networkParameter = this.getDevice().getDeviceCnf().getNetworkParameter();
            int videoSourceNr = videoProfileHandler.getVideoSourceParameter().getServerEntryNo();
            setResolution.append("USER=");
            setResolution.append(networkParameter.getUserPWD()[0]);
            setResolution.append("&PWD=");
            setResolution.append(networkParameter.getUserPWD()[1]);
            setResolution.append("&CHANNEL=");
            setResolution.append(videoSourceNr);
            int[] resolutionBasic = this.getBasicVideoProfileHandler().getVideoSourceParameter().getImageSize();
            String resolutionTagBasic = this.getBasicVideoProfileHandler().getVideoSourceParameter().getResolution();
            if (resolutionBasic.length == 2) {
                resolutionTagBasic = resolutionTagBasic + resolutionBasic[0] + "x" + resolutionBasic[1];
            }
            int[] resolutionAdd = this.getAdditionalVideoProfileHandler()[0].getVideoSourceParameter().getImageSize();
            String resolutionTagAdd = this.getAdditionalVideoProfileHandler()[0].getVideoSourceParameter().getResolution();
            if (resolutionAdd.length == 2) {
                resolutionTagAdd = resolutionTagAdd + resolutionAdd[0] + "x" + resolutionAdd[1];
            }
            boolean isBasicProfile = videoProfileHandler instanceof BasicVideoProfileHandler;
            setResolution.append("&VIDEO_STREAM=DUAL");
            if (this.streamIDforBasicProfile == -1 && this.streamIDforAdditionalProfile == -1) {
                if (isBasicProfile) {
                    this.streamIDforBasicProfile = this.streamID;
                    this.streamIDforAdditionalProfile = this.streamIDforBasicProfile == 1 ? 2 : 1;
                } else {
                    this.streamIDforAdditionalProfile = this.streamID;
                    this.streamIDforBasicProfile = this.streamIDforAdditionalProfile == 1 ? 2 : 1;
                }
            }
            setResolution.append("&MEDIA=");
            if (isBasicProfile) {
                setResolution.append(this.streamIDforBasicProfile);
            } else {
                setResolution.append(this.streamIDforAdditionalProfile);
            }
            setResolution.append("&VIDEO_RESOLUTION=");
            setResolution.append(videoProfileHandler.getVideoSourceParameter().getResolution());
            setResolution.append(videoProfileHandler.getVideoSourceParameter().getImageSize()[0]);
            setResolution.append("x");
            setResolution.append(videoProfileHandler.getVideoSourceParameter().getImageSize()[1]);
            setResolution.append("&MEDIA=");
            if (isBasicProfile) {
                setResolution.append(this.streamIDforAdditionalProfile);
            } else {
                setResolution.append(this.streamIDforBasicProfile);
            }
            setResolution.append("&VIDEO_RESOLUTION=");
            if (isBasicProfile) {
                setResolution.append(resolutionTagAdd);
            } else {
                setResolution.append(resolutionTagBasic);
            }
            NetworkHelper.readGetRequest((NetworkParameter)networkParameter, (String)setResolution.toString(), (int)Integer.MAX_VALUE);
        }
        catch (ConfigurationException ex) {
            this.logger.error("Configuration exception while reading resolution from video source parameters: " + ex.getMessage());
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while setting resolutions on camera for " + this + ": " + ex.getMessage());
            return ex.getErrorCode();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int checkAndSetResolutions() {
        if (this.dynToStream.isEmpty()) {
            this.logger.warn("Mapping of Seetec Profiles to camera streams not ready ");
            return -21600;
        }
        Hashtable<String, Integer> hashtable = this.dynToStream;
        synchronized (hashtable) {
            StringBuilder url = new StringBuilder("/cgi-bin/encoder?");
            try {
                String urlCommand;
                NetworkParameter networkParameter = this.getDevice().getDeviceCnf().getNetworkParameter();
                url.append("USER=");
                url.append(networkParameter.getUserPWD()[0]);
                url.append("&PWD=");
                url.append(networkParameter.getUserPWD()[1]);
                String checkResolutionsURL = url.toString() + "&MEDIA=1&VIDEO_RESOLUTION&MEDIA=2&VIDEO_RESOLUTION";
                String resolutions = new String(NetworkHelper.readGetRequest((NetworkParameter)networkParameter, (String)checkResolutionsURL, (int)Integer.MAX_VALUE, (boolean)true));
                String resolutionFirstStream = "";
                String resolutionSecondStream = "";
                String[] resolutionLines = resolutions.split("VIDEO_RESOLUTION");
                if (resolutionLines.length == 3) {
                    resolutionFirstStream = resolutionLines[1];
                    resolutionSecondStream = resolutionLines[2];
                }
                VideoProfileHandler firstStreamProfileHandler = null;
                VideoProfileHandler secondStreamProfileHandler = null;
                if (this.dynToStream.get("" + this.getBasicVideoProfileHandler().getDynamicVideoProfileID()) == 1) {
                    firstStreamProfileHandler = this.getBasicVideoProfileHandler();
                    secondStreamProfileHandler = this.getAdditionalVideoProfileHandler()[0];
                } else {
                    firstStreamProfileHandler = this.getAdditionalVideoProfileHandler()[0];
                    secondStreamProfileHandler = this.getBasicVideoProfileHandler();
                }
                String videoSystem = "N";
                String resolutionsTagFirstStream = videoSystem + firstStreamProfileHandler.getVideoSourceParameter().getImageSize()[0] + "x" + firstStreamProfileHandler.getVideoSourceParameter().getImageSize()[1];
                String resolutionsTagSecondStream = videoSystem + secondStreamProfileHandler.getVideoSourceParameter().getImageSize()[0] + "x" + secondStreamProfileHandler.getVideoSourceParameter().getImageSize()[1];
                if (!resolutionSecondStream.contains(resolutionsTagSecondStream)) {
                    urlCommand = url.toString() + "&CHANNEL=2&VIDEO_RESOLUTION=" + resolutionsTagSecondStream;
                    NetworkHelper.readGetRequest((NetworkParameter)networkParameter, (String)urlCommand, (int)Integer.MAX_VALUE, (boolean)true);
                }
                if (!resolutionFirstStream.contains(resolutionsTagFirstStream)) {
                    urlCommand = url.toString() + "&CHANNEL=1&VIDEO_RESOLUTION=" + resolutionsTagFirstStream;
                    NetworkHelper.readGetRequest((NetworkParameter)networkParameter, (String)urlCommand, (int)Integer.MAX_VALUE, (boolean)true);
                }
            }
            catch (ConfigurationException ex) {
                this.logger.error("Configuration exception while reading resolution from video source parameters: " + ex.getMessage());
            }
            catch (SeeTecException ex) {
                this.logger.error("Exception while setting resolutions on camera for " + this + ": " + ex.getMessage());
                return ex.getErrorCode();
            }
        }
        return 0;
    }
}

