/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.acti;

import de.seetec.v5.re.cm.device.shared.cameracontrol.CameraControl;
import de.seetec.v5.re.cm.device.shared.cameracontrol.PresetCnf;
import de.seetec.v5.re.cm.shared.communication.VideoServiceClientRequestHandler;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.ConfigurationException;
import java.util.Vector;

public class ActiCameraControlPelcoD
extends CameraControl {
    private byte[] calculateChecksum(byte[] field) {
        int checksum = 0;
        if (field.length != 7) {
            this.logger.warn("Given field has length != 7");
            return null;
        }
        for (int i = 1; i <= 5; ++i) {
            checksum = (byte)(checksum + field[i]);
        }
        field[6] = checksum = (int)((byte)(checksum % 256));
        return field;
    }

    private int sendCameraCommand(byte[] command, byte[] data) {
        byte videoSourceID;
        byte[] hexCommand = new byte[7];
        if (this.videoSrv != null && this.videoSrv.getVideoSourceCnf() != null) {
            try {
                videoSourceID = (byte)this.videoSrv.getVideoSourceCnf().getPtzAddress();
            }
            catch (ConfigurationException ce) {
                this.logger.warn("Error when reading 'VideoSourceID'. Set to 01.");
                videoSourceID = 1;
            }
        } else {
            this.logger.warn("'VideoSourceID' not specified. Set to 01.");
            videoSourceID = 1;
        }
        hexCommand[0] = -1;
        hexCommand[1] = videoSourceID;
        hexCommand[2] = command[0];
        hexCommand[3] = command[1];
        hexCommand[4] = data[0];
        hexCommand[5] = data[1];
        hexCommand = this.calculateChecksum(hexCommand);
        try {
            String url = "/cgi-bin/mpeg4?USER=" + this.usr + "&PWD=" + this.pwd + "&CHANNEL=1&SERIAL_HEX=" + Basic.byteArrayToHexString((byte[])hexCommand);
            this.videoSrv.notifyForCameraControl();
            byte[] result = this.videoSrv.getDevice().getDeviceType() == 211122L ? NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url, (int)1, (boolean)false, null, (boolean)true) : NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url, (int)Integer.MAX_VALUE);
            if (new String(result).contains("ERROR")) {
                this.logger.warn("Sending hexCommand failed.");
                this.logger.warn("Returned result is: \r\n" + new String(result));
                return -20000;
            }
            return 0;
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            return -21600;
        }
    }

    @Override
    public int setAbsolutePTZ(VideoServiceClientRequestHandler sender, Integer pan, Integer tilt, Integer zoom) {
        throw new RuntimeException("NOT YET IMPLEMENTED");
    }

    @Override
    public int setContinuousPTZ(Integer panSpeed, Integer tiltSpeed, Integer zoomSpeed) {
        int zoom;
        int tilt;
        int pan;
        byte[] command = new byte[]{0, 0};
        byte[] data = new byte[]{0, 0};
        if (panSpeed != null) {
            this.previousPanSpeed = pan = panSpeed.intValue();
        } else {
            pan = this.previousPanSpeed;
        }
        if (tiltSpeed != null) {
            this.previousTiltSpeed = tilt = tiltSpeed.intValue();
        } else {
            tilt = this.previousTiltSpeed;
        }
        if (zoomSpeed != null) {
            this.previousZoomSpeed = zoom = zoomSpeed.intValue();
        } else {
            zoom = this.previousZoomSpeed;
        }
        int step = 1587;
        if (pan != 0) {
            command[1] = pan > 0 ? (byte)(command[1] | 2) : (byte)(command[1] | 4);
            pan = Math.abs(pan);
            data[0] = (byte)(pan / step);
        }
        if (tilt != 0) {
            command[1] = tilt > 0 ? (byte)(command[1] | 8) : (byte)(command[1] | 0x10);
            tilt = Math.abs(tilt);
            data[1] = (byte)(tilt / step);
        }
        if (zoomSpeed != null && zoom != 0) {
            command[1] = zoom > 0 ? (byte)(command[1] | 0x20) : (byte)(command[1] | 0x40);
        }
        return this.sendCameraCommand(command, data);
    }

    @Override
    public int setCenterPT(Integer xPosition, Integer yPosition, int[] resolution) {
        throw new RuntimeException("NOT YET IMPLEMENTED");
    }

    @Override
    public int setZoomArea(Integer xPosition, Integer yPosition, Integer width, Integer height, int[] resolution) {
        throw new RuntimeException("NOT YET IMPLEMENTED");
    }

    @Override
    public int setAbsoluteIris(Integer value) {
        throw new RuntimeException("NOT YET IMPLEMENTED");
    }

    @Override
    public int setContinuousIris(Integer value) {
        byte[] command = new byte[]{0, 0};
        byte[] data = new byte[]{0, 0};
        if (value != null && value != 0) {
            command[0] = value > 0 ? 2 : 4;
        }
        return this.sendCameraCommand(command, data);
    }

    @Override
    public int setAutoIris(Boolean active) {
        byte[] command = new byte[]{0, 45};
        byte[] data = new byte[]{0, 0};
        if (active == null) {
            this.logger.warn("Argument active is null!");
            return -20002;
        }
        data[1] = active != false ? 1 : 2;
        return this.sendCameraCommand(command, data);
    }

    @Override
    public int setAbsoluteFocus(Integer value) {
        throw new RuntimeException("NOT YET IMPLEMENTED");
    }

    @Override
    public int setContinuousFocus(Integer value) {
        byte[] command = new byte[]{0, 0};
        byte[] data = new byte[]{0, 0};
        if (value != null && value != 0) {
            if (value > 0) {
                command[0] = 1;
            } else {
                command[1] = -128;
            }
        }
        return this.sendCameraCommand(command, data);
    }

    @Override
    public int setAutoFocus(Boolean active) {
        byte[] command = new byte[]{0, 43};
        byte[] data = new byte[]{0, 0};
        if (active == null) {
            this.logger.warn("Argument active is null!");
            return -20002;
        }
        data[1] = active != false ? 1 : 2;
        return this.sendCameraCommand(command, data);
    }

    @Override
    public int setZeroLux(Boolean active) {
        throw new RuntimeException("NOT YET IMPLEMENTED");
    }

    @Override
    public int setAutoZeroLux(Boolean active) {
        throw new RuntimeException("NOT YET IMPLEMENTED");
    }

    @Override
    public int setHomePosition() {
        throw new RuntimeException("NOT YET IMPLEMENTED");
    }

    @Override
    public int addPresetPosition(Vector<byte[]> vResult, Long presetID, String presetName) {
        byte[] command = new byte[]{0, 3};
        byte[] data = new byte[]{0, 0};
        int presetPosition = -1;
        if (presetName == null) {
            this.logger.warn("Argument presetName is null!");
            return -20002;
        }
        try {
            int i;
            int bitVector = 0;
            for (i = 0; i < this.presetList.size(); ++i) {
                PresetCnf presetCnf = this.presetList.elementAt(i);
                bitVector |= 1 << Integer.parseInt(presetCnf.getPresetPosition());
            }
            for (i = 1; i <= 32; ++i) {
                if ((bitVector & 1 << i) != 0) continue;
                presetPosition = i;
                break;
            }
            if (presetPosition < 0) {
                this.logger.error("Cannot add preset [" + presetName + "], 'cause no more free preset positions are available for " + this);
                return -21600;
            }
            if (presetPosition >= 1 && presetPosition <= 32) {
                this.logger.info("Add preset '" + presetName + "'. ID = " + presetID + ". Position = " + presetPosition);
                data[1] = (byte)presetPosition;
                int errorCode = this.sendCameraCommand(command, data);
                if (errorCode != 0) {
                    this.logger.warn("Error setting preset on camera. errorCode: " + errorCode);
                    return -21600;
                }
            } else {
                this.logger.warn("presetID has invalid value. Must be 0x01 <= n <= 0x20. Given: " + presetPosition);
                return -21600;
            }
            PresetCnf presetCnf = PresetCnf.createPresetCnf(presetID, "" + presetPosition, presetName);
            this.presetList.addElement(presetCnf);
            vResult.addElement(presetCnf.getPresetCnf());
            return 0;
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            this.logger.error("Adding preset [" + presetName + "] failed");
            return -21600;
        }
    }

    @Override
    public int setPresetPosition(String presetName) {
        byte[] command = new byte[]{0, 7};
        byte[] data = new byte[]{0, 0};
        int errorCode = 0;
        if (presetName == null) {
            this.logger.warn("Argument presetName is null!");
            return -20002;
        }
        try {
            for (int i = 0; i < this.presetList.size(); ++i) {
                PresetCnf presetCnf = this.presetList.elementAt(i);
                if (!presetName.equals(presetCnf.getPresetName())) continue;
                data[1] = (byte)Integer.parseInt(presetCnf.getPresetPosition());
                return this.sendCameraCommand(command, data);
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)ex, (Throwable)ex);
            this.logger.error("Setting preset [" + presetName + "] failed");
            return -21600;
        }
        return errorCode;
    }

    @Override
    public int removePresetPosition(String presetName) {
        byte[] command = new byte[]{0, 5};
        byte[] data = new byte[]{0, 0};
        int errorCode = 0;
        if (presetName == null) {
            this.logger.warn("Argument presetName is null!");
            return -20002;
        }
        try {
            for (int i = 0; i < this.presetList.size(); ++i) {
                PresetCnf presetCnf = (PresetCnf)this.presetList.elementAt(i);
                if (!presetName.equals(presetCnf.getPresetName())) continue;
                this.logger.info("Removing preset: " + new String(presetCnf.getPresetCnf()));
                this.presetList.removeElementAt(i);
                data[1] = (byte)(i + 1);
                return this.sendCameraCommand(command, data);
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)ex, (Throwable)ex);
            this.logger.error("Removing preset [" + presetName + "] failed");
            return -21600;
        }
        return errorCode;
    }
}

