/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.abus;

import de.seetec.v5.re.cm.device.shared.motiondetection.HardwareMotionDetection;
import de.seetec.v5.re.cm.device.shared.motiondetection.HardwareMotionDetectionCnf;
import de.seetec.v5.re.cm.device.shared.motiondetection.MotionDetectionHandler;
import de.seetec.v5.re.cm.device.video.abus.AbusDevice;
import de.seetec.v5.re.cm.device.video.abus.AbusHelper;
import de.seetec.v5.shared.net.HTTPResponse;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.Map;

public class AbusMotionDetectionHandler
extends MotionDetectionHandler
implements Runnable {
    private static final String CLASS_NAME = AbusMotionDetectionHandler.class.getName();
    private static final int INTERVAL = 50;
    private final int COUNT_OF_HMD_WINDOWS = 3;
    private Thread myThread = null;
    private NetworkParameter networkParameter = null;
    private AbusDevice device = null;
    private final long[] timeOfMotion = new long[3];

    @Override
    public int init(HardwareMotionDetection<? extends MotionDetectionHandler> hardwareMotionDetection) {
        this.listener = hardwareMotionDetection;
        if (this.listener == null) {
            return -20003;
        }
        try {
            this.device = (AbusDevice)this.listener.getVideoSrv().getDevice();
            this.networkParameter = this.device.getDeviceCnf().getNetworkParameter();
            this.networkParameter.setSoTimeout(10000);
        }
        catch (ConfigurationException e) {
            this.logger.error("Error while getting configuration for " + this.listener.getVideoSrv(), (Throwable)e);
            return -20053;
        }
        try {
            this.device.ensureLogin(this.networkParameter);
            this.myThread = new Thread((Runnable)this, this.toString());
            this.myThread.start();
        }
        catch (Exception e) {
            this.logger.error("Problem while initiating MothinDetectionHandler for " + this.listener.getVideoSrv(), (Throwable)e);
            return -21656;
        }
        return 0;
    }

    @Override
    public int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        super.shutdown();
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        super.setRunFinished(CLASS_NAME, false);
        long time = System.currentTimeMillis();
        String url = "/cgi-bin/param.cgi?Mode=List&Group=Event";
        try {
            while (!this.isShutdown(CLASS_NAME)) {
                if (System.currentTimeMillis() - time < 50L) {
                    long t = System.currentTimeMillis();
                    Thread.sleep(50L + time - t);
                }
                if (this.isShutdown(CLASS_NAME)) continue;
                time = System.currentTimeMillis();
                String cookies = this.device.getCookie();
                try {
                    HTTPResponse response = AbusHelper.readGetRequest(this.networkParameter, url, cookies);
                    int errorCode = AbusHelper.getResultCodeFromResponse(response);
                    Map<String, String> parameterMap = AbusHelper.getContentFromResponse(response);
                    if (errorCode != 1) {
                        this.logger.warn("Return code was " + errorCode + " for request " + url);
                        continue;
                    }
                    for (Map.Entry<String, String> entry : parameterMap.entrySet()) {
                        try {
                            boolean isMotion = entry.getValue().equals("1");
                            int roi = Integer.parseInt(entry.getKey().substring(entry.getKey().length() - 1));
                            int id = 3 - roi;
                            if (!isMotion) continue;
                            for (HardwareMotionDetectionCnf cnf : this.listener.getHardwareMotionDetectionCnf()) {
                                int wnd = cnf.getWindow();
                                if (wnd != id || this.timeOfMotion[wnd - 1] + cnf.getDeadTime() >= System.currentTimeMillis()) continue;
                                this.listener.evaluateWindow(wnd - 1);
                                this.timeOfMotion[wnd - 1] = System.currentTimeMillis();
                            }
                        }
                        catch (NumberFormatException ex) {
                            this.logger.warn("Can't parse ROI value for " + this + " Exception=" + ex.getMessage());
                        }
                    }
                }
                catch (ConfigurationException | SeeTecException ex) {
                    this.logger.error("Exception while reading motion detection data for " + this + ": " + ex.getMessage());
                }
            }
        }
        catch (InterruptedException ex) {
            this.logger.error("Exception while reading motion detection data for " + this + ": " + ex.getMessage(), (Throwable)ex);
        }
        super.setRunFinished(CLASS_NAME, true);
        this.shutdown();
    }
}

