/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.abus;

import de.seetec.v5.re.cm.device.shared.io.DigitalInputSrv;
import de.seetec.v5.re.cm.device.shared.io.IOHandler;
import de.seetec.v5.re.cm.device.video.abus.AbusDevice;
import de.seetec.v5.re.cm.device.video.abus.AbusHelper;
import de.seetec.v5.shared.net.HTTPResponse;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.UnknownHostException;
import java.util.Map;

public class AbusIOHandler
extends IOHandler {
    private static final String CLASS_NAME = AbusIOHandler.class.getName();

    @Override
    public int writeDigitalOutput(int number, int value, long holdTime) {
        IOHandler.HoldTimer holdTimer;
        try {
            AbusDevice abusDevice = (AbusDevice)this.device;
            String cookie = abusDevice.getCookie();
            StringBuilder url = new StringBuilder("/cgi-bin/param.cgi?Mode=Update&Group=GPIO&DO-Now=" + (value == 1 ? 0 : 1));
            HTTPResponse response = AbusHelper.readGetRequest(this.networkParameter, url.toString(), cookie);
            int errorCode = AbusHelper.getResultCodeFromResponse(response);
            if (errorCode != 1) {
                this.logger.warn("Return code was " + errorCode + " for request " + url);
            }
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while setting Output for " + this + ": Exception=" + ex.getMessage());
        }
        int errorCode = 0;
        if (holdTime > 0L && (errorCode = (holdTimer = new IOHandler.HoldTimer()).init(number, value > 0 ? 0 : 1, holdTime)) != 0) {
            holdTimer.shutdown();
            this.logger.warn("Creating " + holdTimer + " failed with error [" + errorCode + "]");
        }
        return errorCode;
    }

    @Override
    public void run() {
        super.setRunFinished(CLASS_NAME, false);
        try {
            boolean previousLoopWithError = false;
            DigitalInputSrv[] iServices = super.getDigitalInputSrv();
            while (!(this.isShutdown(CLASS_NAME) || super.isShutdown() || this.device.isShutdown())) {
                try {
                    long duration;
                    long ts = System.currentTimeMillis();
                    this.readDigitalInputs();
                    if (previousLoopWithError) {
                        previousLoopWithError = false;
                        DigitalInputSrv[] digitalInputSrvArray = iServices;
                        int n = digitalInputSrvArray.length;
                        for (int i = 0; i < n; ++i) {
                            DigitalInputSrv iService = digitalInputSrvArray[i];
                            if (!iService.getEntity().isEnabled().booleanValue()) continue;
                            iService.publishServiceStatus(iService.getInputStatus());
                        }
                    }
                    if ((duration = System.currentTimeMillis() - ts) < 0L || duration >= 190L) continue;
                    try {
                        Thread.sleep(200L - duration);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                catch (Throwable ex) {
                    previousLoopWithError = true;
                    if (ex instanceof IOException || ex instanceof UnknownHostException || ex instanceof NoRouteToHostException || ex instanceof ConnectException) {
                        this.logger.warn("Network trouble for " + this, ex);
                    } else if (ex.getMessage().contains("Address already in use")) {
                        this.logger.warn("TCP stack seems to be overloaded, so there are problems for " + this, ex);
                    } else {
                        this.logger.warn("Unknown trouble for " + this, ex);
                    }
                    try {
                        for (DigitalInputSrv iService : iServices) {
                            if (!iService.getEntity().isEnabled().booleanValue()) continue;
                            iService.publishServiceStatus(-21603);
                        }
                    }
                    catch (Throwable t) {
                        this.logger.warn((Object)t, t);
                    }
                    long tsTimeout = System.currentTimeMillis() + 10000L;
                    while (tsTimeout > System.currentTimeMillis() && !this.isShutdown(CLASS_NAME) && !this.device.isShutdown()) {
                        try {
                            Thread.sleep(250L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
        }
        super.setRunFinished(CLASS_NAME, true);
        this.shutdown();
    }

    private int readDigitalInputs() throws Exception {
        DigitalInputSrv[] iServices = super.getDigitalInputSrv();
        AbusDevice abusDevice = (AbusDevice)this.device;
        String cookie = abusDevice.getCookie();
        abusDevice.ensureLogin(this.networkParameter);
        String url = "/cgi-bin/param.cgi?Mode=List&Group=GPIO";
        HTTPResponse response = AbusHelper.readGetRequest(this.networkParameter, url, cookie);
        Map<String, String> parameterMap = AbusHelper.getContentFromResponse(response);
        for (int i = 0; i < iServices.length / 2; ++i) {
            int inputNumber = iServices[i].getInputNumber();
            if (inputNumber != 1 || !parameterMap.containsKey("DI-Now")) continue;
            String sValue = parameterMap.get("DI-Now");
            try {
                int iValue = Integer.parseInt(sValue);
                iServices[2 * i].checkInput(iValue);
                iServices[2 * i + 1].checkInput(iValue);
                continue;
            }
            catch (NumberFormatException ex) {
                this.logger.error("Exception while parsing input value for " + this + ": Exception=" + ex.getMessage());
            }
        }
        return 0;
    }
}

