/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.abus;

import de.seetec.v5.shared.net.HTTPResponse;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AbusHelper {
    private static final Logger LOGGER = LogManager.getLogger(AbusHelper.class);

    public static HTTPResponse readGetRequest(NetworkParameter networkParameter, String url, String cookie) throws SeeTecException {
        NetworkParameter param = networkParameter;
        param.setAdditionalData(cookie);
        byte[] response = NetworkHelper.readGetRequest((NetworkParameter)param, (String)url, (int)Integer.MAX_VALUE, (boolean)true);
        String responseString = new String(response);
        if (responseString.toLowerCase().startsWith("result=")) {
            try {
                int resultCode = Integer.parseInt(responseString.substring("result=".length()));
                if (resultCode != 1) {
                    throw new SeeTecException(resultCode, "ResultCode=" + resultCode + " for request " + url);
                }
            }
            catch (NumberFormatException ex) {
                throw new SeeTecException(-21600, "Faild to convert rusultCode from respose string");
            }
        }
        HTTPResponse httpResponse = new HTTPResponse(response);
        return httpResponse;
    }

    public static int getResultCodeFromResponse(HTTPResponse httpResponse) {
        if (httpResponse != null && httpResponse.getHttpBody() != null) {
            String[] parameterList;
            String bodyString = httpResponse.getHttpBody().getData();
            for (String parameter : parameterList = bodyString.split("<br>")) {
                if (!parameter.toLowerCase().startsWith("result=")) continue;
                String s = parameter.substring("result=".length());
                try {
                    return Integer.parseInt(s);
                }
                catch (NumberFormatException ex) {
                    LOGGER.warn("Can't parse errorCode to integer (" + s + ")");
                    return -20001;
                }
            }
            return 1;
        }
        return -20001;
    }

    public static String getCookieFromResponse(HTTPResponse httpResponse) {
        if (httpResponse != null && httpResponse.getHttpHeader() != null) {
            return httpResponse.getHttpHeader().getCookie();
        }
        return null;
    }

    public static Map<String, String> getContentFromResponse(HTTPResponse httpResponse) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        if (httpResponse != null && httpResponse.getHttpBody() != null) {
            String[] parameterList;
            String bodyString = httpResponse.getHttpBody().getData();
            for (String parameter : parameterList = bodyString.split("<br>")) {
                String[] parameterLine = parameter.split("=");
                if (parameterLine.length != 2) continue;
                resultMap.put(parameterLine[0], parameterLine[1]);
            }
        }
        return resultMap;
    }
}

