/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.sps.wago;

import de.seetec.v5.shared.Basic;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class WagoReadRequest {
    private final byte[] transactionIdentifier = new byte[]{0, 0};
    private final byte[] protocolIdentifier = new byte[]{0, 0};
    private final byte[] length = new byte[]{0, 6};
    private final byte[] modbusUnit = new byte[]{1};
    private final byte[] modbusFctRead = new byte[]{1};
    private final int offSet;
    private final int numberOfInputs;

    public WagoReadRequest(int offSet, int numberOfInputs) {
        this.offSet = offSet;
        this.numberOfInputs = numberOfInputs;
    }

    public int getOffSet() {
        return this.offSet;
    }

    public int getNumberOfInputs() {
        return this.numberOfInputs;
    }

    public byte[] getRequest() throws IOException {
        ByteArrayOutputStream request = new ByteArrayOutputStream();
        request.write(this.transactionIdentifier);
        request.write(this.protocolIdentifier);
        request.write(this.length);
        request.write(this.modbusUnit);
        request.write(this.modbusFctRead);
        request.write(Basic.int4ToByteArray((int)this.offSet, (int)2));
        request.write(Basic.int4ToByteArray((int)this.numberOfInputs, (int)2));
        return request.toByteArray();
    }

    public String toString() {
        return "Modbus request:\r\n\tFunction: read coils (FC1)\r\n\tFirst Input to read: " + this.offSet + "\r\n\tNumber of Inputs to read: " + this.numberOfInputs;
    }
}

