/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.sps.wago;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.device.shared.Device;
import de.seetec.v5.re.cm.device.shared.io.DigitalInputSrv;
import de.seetec.v5.re.cm.device.shared.io.DigitalOutputSrv;
import de.seetec.v5.re.cm.device.shared.io.IOHandler;
import de.seetec.v5.re.cm.device.sps.wago.WagoReadRequest;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.proxy.ent.Entity;
import de.seetec.v5.shared.util.ConfigurationException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class WagoIOHandler
extends IOHandler {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.sps.wago.WagoIOHandler";
    private static final int SO_TIMEOUT = 5000;
    private Socket readSocket = null;
    private long deviceID = Long.MIN_VALUE;
    private Map<Integer, String> virtualInputs = null;
    private static final String SEPARATOR = "%%";

    @Override
    public final int init(Core core, Device device, Entity[] srvEntities) {
        int errorCode = super.init(core, device, srvEntities);
        if (errorCode != 0) {
            return errorCode;
        }
        this.virtualInputs = new HashMap<Integer, String>();
        for (DigitalInputSrv digitalInputSrv : this.getDigitalInputSrv()) {
            Entity entity = digitalInputSrv.getEntity();
            if (entity.getEntityType() != 9804L || !entity.getEntityName().contains(SEPARATOR)) continue;
            this.virtualInputs.put(digitalInputSrv.getInputNumber() - 1, entity.getEntityName().substring(entity.getEntityName().indexOf(SEPARATOR) + 2));
        }
        this.deviceID = device.getDeviceID();
        return 0;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @SuppressFBWarnings(value={"UNENCRYPTED_SOCKET"}, justification="User has the choice to configure the use of TLS if supported by hardware.")
    public final void run() {
        super.setRunFinished("de.seetec.v5.re.cm.device.sps.wago.WagoIOHandler", false);
        try {
            while (true) {
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException var1_2) {
                    // empty catch block
                }
                if (this.isShutdown("de.seetec.v5.re.cm.device.sps.wago.WagoIOHandler") || super.isShutdown() || this.device == null || this.device.isShutdown()) break;
                while (this.readSocket == null) {
                    try {
                        this.readSocket = new Socket(this.host, this.port);
                        this.readSocket.setSoTimeout(5000);
                        this.device.sendResolvedConnectionEvent(this.deviceID);
                        try {
                            this.getCore().setEntityStatus(this.deviceID, 0);
                        }
                        catch (Throwable t) {
                            this.logger.warn((Object)t, t);
                        }
                    }
                    catch (Throwable ex) {
                        if (this.onNetworkError(ex)) continue;
                    }
                    break;
                }
                try {
                    if (!(this.isShutdown("de.seetec.v5.re.cm.device.sps.wago.WagoIOHandler") || super.isShutdown() || this.device == null || this.device.isShutdown())) {
                        this.checkDigitalInputs();
                        continue;
                    }
                }
                catch (Throwable t) {
                    if (this.isShutdown("de.seetec.v5.re.cm.device.sps.wago.WagoIOHandler") || super.isShutdown() || !this.onNetworkError(t)) ** break;
                    continue;
                    this.logger.info("Shutdown detected, so leaving thread of " + this);
                }
                break;
            }
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
        }
        this.logger.info("Thread of this " + this + " finished");
        super.setRunFinished("de.seetec.v5.re.cm.device.sps.wago.WagoIOHandler", true);
        this.shutdown();
    }

    private void logException(Throwable exception) {
        if (!(exception instanceof IOException || exception instanceof UnknownHostException || exception instanceof NoRouteToHostException || exception instanceof ConnectException)) {
            this.logger.error((Object)exception, exception);
        }
    }

    @Override
    public final boolean isShutdown() {
        return super.isShutdown();
    }

    private boolean onNetworkError(Throwable exception) {
        this.logException(exception);
        try {
            this.getCore().setEntityStatus(this.deviceID, -21656);
            this.device.sendCannotEstablishConnectionLoggingEvent(-21656);
        }
        catch (ConfigurationException t) {
            this.logger.warn((Object)t, (Throwable)t);
        }
        this.logger.warn("Trouble connecting Wago at [" + this.host + ":" + this.port + "]: " + exception.getMessage());
        if (this.isShutdown(CLASS_NAME) || super.isShutdown() || this.device == null || this.device.isShutdown()) {
            return false;
        }
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return true;
    }

    private void checkDigitalInputs() {
        int errorCode;
        int[] inputValues = new int[super.getHighestInputNumber()];
        int enabledInputs = 0;
        for (int i = 0; i < this.getDigitalInputSrv().length; i += 2) {
            try {
                if (!this.getDigitalInputSrv()[i].getDigitalInputSrvCnf().isEnabled()) continue;
                ++enabledInputs;
                continue;
            }
            catch (ConfigurationException ex) {
                this.logger.warn("");
            }
        }
        if (this.virtualInputs.size() < enabledInputs && (errorCode = this.readDigitalInputs(inputValues)) != 0) {
            this.logger.warn("Reading inputs failed with error [" + errorCode + "]");
            return;
        }
        if (this.virtualInputs.size() > 0) {
            for (Map.Entry<Integer, String> entry : this.virtualInputs.entrySet()) {
                inputValues[entry.getKey().intValue()] = this.readVirtualInput(entry.getValue());
            }
        }
        for (DigitalInputSrv service : super.getDigitalInputSrv()) {
            service.checkInput(inputValues);
        }
    }

    @SuppressFBWarnings(value={"UNENCRYPTED_SOCKET"}, justification="User has the choice to configure the use of TLS if supported by hardware.")
    protected byte[] readInputs(WagoReadRequest wagoReadRequest) {
        int bufferLength = 9 + wagoReadRequest.getNumberOfInputs() / 8 + (wagoReadRequest.getNumberOfInputs() % 8 == 0 ? 0 : 1);
        byte[] buffer = new byte[bufferLength];
        try {
            int len;
            if (this.readSocket == null) {
                this.readSocket = new Socket(this.host, this.port);
                this.readSocket.setSoTimeout(5000);
                this.logger.info(this.readSocket + " created for " + this);
            }
            OutputStream os = this.readSocket.getOutputStream();
            os.write(wagoReadRequest.getRequest());
            os.flush();
            int offset = 0;
            InputStream is = this.readSocket.getInputStream();
            while ((len = is.read(buffer, offset, buffer.length - offset)) > 0 && (offset += len) != buffer.length) {
            }
        }
        catch (Throwable ex) {
            try {
                this.readSocket.close();
                this.readSocket = null;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.logger.error((Object)ex, ex);
            throw new RuntimeException("Cannot read inputs from [" + this.host + ":" + this.port + "]");
        }
        return buffer;
    }

    protected int readDigitalInputs(int[] inputs) {
        WagoReadRequest wagoReadRequest;
        ArrayList<WagoReadRequest> readRequests = new ArrayList<WagoReadRequest>();
        if (this.getDevice().getDeviceType() == 2205L) {
            wagoReadRequest = new WagoReadRequest(0, inputs.length);
            readRequests.add(wagoReadRequest);
        } else {
            wagoReadRequest = new WagoReadRequest(0, 512);
            readRequests.add(wagoReadRequest);
        }
        ByteArrayOutputStream readResults = new ByteArrayOutputStream();
        for (WagoReadRequest readRequest : readRequests) {
            byte[] result = this.readInputs(readRequest);
            readResults.write(result, 9, result.length - 9);
        }
        byte[] data = readResults.toByteArray();
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < 8; ++j) {
                if (i * 8 + j >= inputs.length) continue;
                inputs[i * 8 + j] = data[i] >> j & 1;
            }
        }
        return 0;
    }

    @SuppressFBWarnings(value={"UNENCRYPTED_SOCKET"}, justification="User has the choice to configure the use of TLS if supported by hardware.")
    private int readVirtualInput(String adressAndBit) {
        String[] values = adressAndBit.split(",");
        try {
            int len;
            if (this.readSocket == null) {
                this.readSocket = new Socket(this.host, this.port);
                this.readSocket.setSoTimeout(5000);
                this.logger.info(this.readSocket + " created for " + this + " :-)");
            }
            WagoReadRequest wagoReadRequest = new WagoReadRequest(Integer.parseInt(values[0]), Integer.parseInt(values[1]));
            OutputStream os = this.readSocket.getOutputStream();
            os.write(wagoReadRequest.getRequest());
            os.flush();
            int offset = 0;
            byte[] buffer = new byte[10];
            InputStream is = this.readSocket.getInputStream();
            while ((len = is.read(buffer, offset, buffer.length - offset)) > 0 && (offset += len) != buffer.length) {
            }
            byte data = buffer[9];
            int value = data & 1;
            return value;
        }
        catch (Throwable ex) {
            try {
                this.readSocket.close();
                this.readSocket = null;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.logger.error((Object)ex, ex);
            throw new RuntimeException("Cannot read virtual inputs from [" + this.host + ":" + this.port + "]");
        }
    }

    @Override
    @SuppressFBWarnings(value={"UNENCRYPTED_SOCKET"}, justification="User has the choice to configure the use of TLS if supported by hardware.")
    public final int writeDigitalOutput(int outputNumber, int value, long holdTime) {
        DigitalOutputSrv service = super.getDigitalOutputSrv(outputNumber);
        if (service == null) {
            this.logger.error(this + " has no digital output service configured for [" + outputNumber + "]");
            return -21601;
        }
        if (value < 0) {
            this.logger.error("Value [" + value + "] is not valid for " + this);
            return -21601;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.info("Writing value [" + value + "] to output [" + outputNumber + "] with HoldTime [" + holdTime + "] for " + this + " ...");
        }
        try {
            IOHandler.HoldTimer holdTimer;
            int errorCode;
            byte byteValue = value != 0 ? (byte)-1 : 0;
            byte padding = 0;
            byte[] modbusOffsetWrite = Basic.int4ToByteArray((int)(outputNumber - 1), (int)2);
            byte[] modbusRegQuantityWrite = new byte[]{byteValue, padding};
            if (service.getEntity().getEntityName().contains(SEPARATOR)) {
                byte[] register;
                String[] values = service.getEntity().getEntityName().substring(service.getEntity().getEntityName().indexOf(SEPARATOR) + 2).split(",");
                modbusOffsetWrite = register = Basic.int4ToByteArray((int)Integer.parseInt(values[0]), (int)2);
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] modbusHeader = new byte[]{0, 0, 0, 0, 0, 6};
            baos.write(modbusHeader);
            baos.write(1);
            baos.write(5);
            baos.write(modbusOffsetWrite);
            baos.write(modbusRegQuantityWrite);
            Socket oSocket = null;
            try {
                InputStream is;
                byte[] buffer;
                int i = 0;
                while (true) {
                    try {
                        oSocket = new Socket(this.host, this.port);
                        oSocket.setSoTimeout(5000);
                    }
                    catch (ConnectException cex) {
                        if (i >= 5) {
                            this.logger.error((Object)cex, (Throwable)cex);
                            this.logger.error("Too much problems to create a tcp connection to [" + this.host + ":" + this.port + "] for " + this);
                            return -21656;
                        }
                        this.logger.warn((Object)cex, (Throwable)cex);
                        this.logger.warn("Trouble creating tcp connection to [" + this.host + ":" + this.port + "] for " + this + ", so trying again ...");
                        ++i;
                        continue;
                    }
                    break;
                }
                try (OutputStream os = oSocket.getOutputStream();){
                    int len;
                    os.write(baos.toByteArray());
                    os.flush();
                    int offset = 0;
                    buffer = new byte[12];
                    is = oSocket.getInputStream();
                    do {
                        if ((len = is.read(buffer, offset, buffer.length - offset)) > 0) continue;
                        break;
                    } while ((offset += len) != buffer.length);
                }
                is.close();
                oSocket.close();
                if (buffer[7] == -123) {
                    this.logger.fatal("Error while setting ouput " + this);
                    return -21600;
                }
                if (buffer[10] != byteValue) {
                    this.logger.fatal("Value '" + byteValue + "' has not been set for " + this);
                    return -21601;
                }
            }
            catch (IOException ioex) {
                try {
                    oSocket.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.logger.error("Could not write to socket [" + this.host + ":" + this.port + "]", (Throwable)ioex);
                return -21656;
            }
            if (holdTime > 0L && (errorCode = (holdTimer = new IOHandler.HoldTimer()).init(outputNumber, value > 0 ? 0 : 1, holdTime)) != 0) {
                holdTimer.shutdown();
                this.logger.warn("Creating " + holdTimer + " failed with error [" + errorCode + "]");
            }
        }
        catch (Throwable ex) {
            this.logger.warn((Object)ex, ex);
        }
        return 0;
    }

    @Override
    protected final int discard() {
        try {
            this.readSocket.close();
            this.readSocket = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return 0;
    }

    private Device getDevice() {
        return this.device;
    }
}

