/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.sps.wago;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.configuration.definition.camera.VideoCameraDefinition;
import de.seetec.v5.re.cm.configuration.definition.device.DeviceDefinition;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedGenericEventsType;
import de.seetec.v5.re.cm.device.shared.Device;
import de.seetec.v5.re.cm.device.shared.io.IOHandler;
import de.seetec.v5.re.cm.device.sps.wago.WagoIOHandler;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;

public final class WagoDevice
extends Device {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.sps.wago.WagoDevice";
    private WagoIOHandler ioHandler = null;

    @Override
    public final int init(Core core, long entityID) {
        int errorCode = super.init(core, entityID);
        if (errorCode != 0) {
            this.logger.error("Initializing " + this + " failed with error [" + errorCode + "]");
            return errorCode;
        }
        this.logger.info(this + " initialized");
        try {
            this.getDeviceCnf().getNetworkParameter().setSoTimeout(5000);
        }
        catch (ConfigurationException ex) {
            this.logger.warn("Timeout could not be set for " + this);
        }
        return 0;
    }

    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    @Override
    public final int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        return super.shutdown();
    }

    @Override
    public final int stopDevice() {
        this.logger.info("Stopping " + this + " ...");
        return this.shutdown();
    }

    @Override
    public final int handleAction(Long actionID, Long alarmScriptID, Long alarmInstanceID, Long alarmDuration, byte[] genericData) {
        this.logger.info("Action [" + actionID + "] of scenario [" + alarmScriptID + "] with duration [" + alarmDuration / 1000L + "," + alarmDuration % 1000L + " s] is triggered on " + this + " ...");
        if (this.ioHandler != null) {
            return super.getIOHandler().triggerAction(actionID, alarmScriptID, alarmInstanceID, alarmDuration, genericData);
        }
        this.logger.error("Cannot get [IOHandler] for " + this);
        return -21600;
    }

    @Override
    public final int initializeDevice(long srvType) {
        return 0;
    }

    @Override
    protected final IOHandler createIOHandler() {
        this.ioHandler = new WagoIOHandler();
        return this.ioHandler;
    }

    @Override
    protected final boolean isSupportingIO() {
        return true;
    }

    @Override
    protected DeviceDefinition getDeviceDefinitionFromDevice(String signature, String manufacturer, String name, String comments) throws SeeTecException {
        return null;
    }

    @Override
    protected VideoCameraDefinition getVideoCameraDefinitionFromDevice() throws SeeTecException {
        return null;
    }

    @Override
    protected SupportedGenericEventsType getGenericEventTrigger() throws SeeTecException, ConfigurationException {
        throw new UnsupportedOperationException("Not yet implemented for " + this);
    }
}

