/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.sps.advantech;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.device.shared.Device;
import de.seetec.v5.re.cm.device.shared.io.DigitalInputSrv;
import de.seetec.v5.re.cm.device.shared.io.DigitalOutputSrv;
import de.seetec.v5.re.cm.device.shared.io.IOHandler;
import de.seetec.v5.shared.proxy.ent.Entity;
import de.seetec.v5.shared.util.ConfigurationException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.net.UnknownHostException;

public class AdvantechIOHandler
extends IOHandler {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.sps.advantech.AdvantechIOHandler";
    private static final int SO_TIMEOUT = 10000;
    private final byte[] modbusHeader = new byte[]{0, 0, 0, 0, 0, 6};
    private final byte[] modbusUnit = new byte[]{1};
    private final byte[] modbusFctRead = new byte[]{1};
    private final byte[] modbusFctWrite = new byte[]{5};
    private final byte[] modbusOffset = new byte[]{0, 0};
    private final byte[] modbusRegQuantity = new byte[]{0, 16};
    private final byte[] modbusReadRequest = new byte[this.modbusHeader.length + this.modbusUnit.length + this.modbusFctRead.length + this.modbusOffset.length + this.modbusRegQuantity.length];
    private Socket readSocket = null;
    private long deviceID = Long.MIN_VALUE;

    @Override
    public int init(Core core, Device device, Entity[] srvEnities) {
        int errorCode = super.init(core, device, srvEnities);
        if (errorCode != 0) {
            return errorCode;
        }
        this.deviceID = device.getDeviceID();
        System.arraycopy(this.modbusHeader, 0, this.modbusReadRequest, 0, this.modbusHeader.length);
        System.arraycopy(this.modbusUnit, 0, this.modbusReadRequest, this.modbusHeader.length, this.modbusUnit.length);
        System.arraycopy(this.modbusFctRead, 0, this.modbusReadRequest, this.modbusHeader.length + this.modbusUnit.length, this.modbusFctRead.length);
        System.arraycopy(this.modbusOffset, 0, this.modbusReadRequest, this.modbusHeader.length + this.modbusUnit.length + this.modbusFctRead.length, this.modbusOffset.length);
        System.arraycopy(this.modbusRegQuantity, 0, this.modbusReadRequest, this.modbusHeader.length + this.modbusUnit.length + this.modbusFctRead.length + this.modbusOffset.length, this.modbusRegQuantity.length);
        return 0;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @SuppressFBWarnings(value={"UNENCRYPTED_SOCKET"}, justification="User has the choice to configure the use of TLS if supported by hardware.")
    public void run() {
        super.setRunFinished("de.seetec.v5.re.cm.device.sps.advantech.AdvantechIOHandler", false);
        try {
            while (true) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException var1_2) {
                    // empty catch block
                }
                if (this.isShutdown("de.seetec.v5.re.cm.device.sps.advantech.AdvantechIOHandler") || super.isShutdown() || this.device == null || this.device.isShutdown()) break;
                while (this.readSocket == null) {
                    try {
                        this.readSocket = new Socket(this.host, this.port);
                        this.readSocket.setSoTimeout(10000);
                        this.device.sendResolvedConnectionEvent(this.deviceID);
                        try {
                            this.getCore().setEntityStatus(this.deviceID, 0);
                        }
                        catch (Throwable t) {
                            this.logger.warn((Object)t, t);
                        }
                    }
                    catch (Throwable ex) {
                        if (this.onNetworkError(ex)) continue;
                    }
                    break;
                }
                try {
                    if (!(this.isShutdown("de.seetec.v5.re.cm.device.sps.advantech.AdvantechIOHandler") || super.isShutdown() || this.device == null || this.device.isShutdown())) {
                        this.checkDigitalInputs();
                        continue;
                    }
                }
                catch (Throwable t) {
                    if (this.isShutdown("de.seetec.v5.re.cm.device.sps.advantech.AdvantechIOHandler") || super.isShutdown() || !this.onNetworkError(t)) ** break;
                    continue;
                    this.logger.info("Shutdown detected, so leaving thread of " + this);
                }
                break;
            }
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
        }
        this.logger.info("Thread of this " + this + " finished");
        super.setRunFinished("de.seetec.v5.re.cm.device.sps.advantech.AdvantechIOHandler", true);
        this.shutdown();
    }

    private void logException(Throwable exception) {
        if (!(exception instanceof IOException || exception instanceof UnknownHostException || exception instanceof NoRouteToHostException || exception instanceof ConnectException)) {
            this.logger.error((Object)exception, exception);
        }
    }

    private boolean onNetworkError(Throwable exception) {
        this.logException(exception);
        try {
            this.getCore().setEntityStatus(this.deviceID, -21656);
            this.device.sendCannotEstablishConnectionLoggingEvent(-21656);
        }
        catch (ConfigurationException t) {
            this.logger.warn((Object)t, (Throwable)t);
        }
        this.logger.warn("Trouble connecting Wago at [" + this.host + ":" + this.port + "]: " + exception.getMessage());
        if (this.isShutdown(CLASS_NAME) || super.isShutdown() || this.device == null || this.device.isShutdown()) {
            return false;
        }
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return true;
    }

    private void checkDigitalInputs() {
        int[] inputValues = new int[super.getHighestInputNumber()];
        int errorCode = this.readDigitalInputs(inputValues);
        if (errorCode != 0) {
            this.logger.warn("Reading inputs failed with error [" + errorCode + "]");
            return;
        }
        for (DigitalInputSrv service : super.getDigitalInputSrv()) {
            service.checkInput(inputValues);
        }
    }

    @SuppressFBWarnings(value={"UNENCRYPTED_SOCKET"}, justification="User has the choice to configure the use of TLS if supported by hardware.")
    private int readDigitalInputs(int[] inputs) {
        try {
            int i;
            int len;
            if (this.readSocket == null) {
                this.readSocket = new Socket(this.host, this.port);
                this.readSocket.setSoTimeout(10000);
                this.logger.info(this.readSocket + " created for " + this);
            }
            OutputStream os = this.readSocket.getOutputStream();
            os.write(this.modbusReadRequest);
            os.flush();
            int offset = 0;
            byte[] buffer = new byte[11];
            InputStream is = this.readSocket.getInputStream();
            while ((len = is.read(buffer, offset, buffer.length - offset)) > 0 && (offset += len) != buffer.length) {
            }
            int result = 0;
            for (i = 10; i >= 9; --i) {
                result = (result << 8) + (buffer[i] & 0xFF);
            }
            for (i = 0; i < inputs.length; ++i) {
                inputs[i] = result >> i & 1;
            }
            return 0;
        }
        catch (Throwable ex) {
            try {
                this.readSocket.close();
                this.readSocket = null;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.logger.error((Object)ex, ex);
            throw new RuntimeException("Cannot read inputs from [" + this.host + ":" + this.port + "]");
        }
    }

    @Override
    @SuppressFBWarnings(value={"UNENCRYPTED_SOCKET"}, justification="User has the choice to configure the use of TLS if supported by hardware.")
    public int writeDigitalOutput(int uutputNumber, int value, long holdTime) {
        DigitalOutputSrv service = super.getDigitalOutputSrv(uutputNumber);
        if (service == null) {
            this.logger.error(this + " has no digital output service configured for [" + uutputNumber + "]");
            return -21601;
        }
        if (value < 0) {
            this.logger.error("Value [" + value + "] is not valid for " + this);
            return -21601;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.info("Writing value [" + value + "] to output [" + uutputNumber + "] with HoldTime [" + holdTime + "] for " + this + " ...");
        }
        try {
            IOHandler.HoldTimer holdTimer;
            int errorCode;
            byte byteValue = value != 0 ? (byte)-1 : 0;
            byte lowOffset = (byte)(16 + (uutputNumber - 1));
            byte padding = 0;
            byte[] modbusOffsetWrite = new byte[]{0, lowOffset};
            byte[] modbusRegQuantityWrite = new byte[]{byteValue, padding};
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(this.modbusHeader);
            baos.write(this.modbusUnit);
            baos.write(this.modbusFctWrite);
            baos.write(modbusOffsetWrite);
            baos.write(modbusRegQuantityWrite);
            Socket oSocket = null;
            try {
                InputStream is;
                byte[] buffer;
                int i = 0;
                while (true) {
                    try {
                        oSocket = new Socket(this.host, this.port);
                        oSocket.setSoTimeout(10000);
                    }
                    catch (ConnectException cex) {
                        if (i >= 5) {
                            this.logger.error("Too much problems to create a tcp connection to [" + this.host + ":" + this.port + "] for " + this, (Throwable)cex);
                            return -21656;
                        }
                        this.logger.warn("Trouble creating tcp connection to [" + this.host + ":" + this.port + "] for " + this + ", so trying again ...", (Throwable)cex);
                        ++i;
                        continue;
                    }
                    break;
                }
                try (OutputStream os = oSocket.getOutputStream();){
                    int len;
                    os.write(baos.toByteArray());
                    os.flush();
                    int offset = 0;
                    buffer = new byte[12];
                    is = oSocket.getInputStream();
                    do {
                        if ((len = is.read(buffer, offset, buffer.length - offset)) > 0) continue;
                        break;
                    } while ((offset += len) != buffer.length);
                }
                is.close();
                oSocket.close();
                if (buffer[7] == -123) {
                    this.logger.fatal("Error while setting ouput " + this);
                    return -21600;
                }
                if (buffer[10] != byteValue) {
                    this.logger.fatal("Value '" + byteValue + "' has not been set for " + this);
                    return -21601;
                }
            }
            catch (IOException ioex) {
                try {
                    oSocket.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.logger.error("Could not write to socket [" + this.host + ":" + this.port + "]", (Throwable)ioex);
                return -21656;
            }
            if (holdTime > 0L && (errorCode = (holdTimer = new IOHandler.HoldTimer()).init(uutputNumber, value > 0 ? 0 : 1, holdTime)) != 0) {
                holdTimer.shutdown();
                this.logger.warn("Creating " + holdTimer + " failed with error [" + errorCode + "]");
            }
        }
        catch (Throwable ex) {
            this.logger.warn((Object)ex, ex);
        }
        return 0;
    }

    @Override
    protected int discard() {
        try {
            this.readSocket.close();
            this.readSocket = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return 0;
    }
}

