/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.sps.advantech;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.configuration.definition.camera.VideoCameraDefinition;
import de.seetec.v5.re.cm.configuration.definition.device.DeviceDefinition;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedGenericEventsType;
import de.seetec.v5.re.cm.device.shared.Device;
import de.seetec.v5.re.cm.device.shared.io.IOHandler;
import de.seetec.v5.re.cm.device.sps.advantech.AdvantechIOHandler;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;

public class AdvantechDevice
extends Device {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.sps.advantech.AdvantechDevice";
    private AdvantechIOHandler ioHandler = null;

    @Override
    public int init(Core core, long entityID) {
        int errorCode = super.init(core, entityID);
        if (errorCode != 0) {
            this.logger.error("Initializing " + this + " failed with error [" + errorCode);
            return errorCode;
        }
        this.logger.info(this + " initialized");
        return 0;
    }

    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    @Override
    public int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        return super.shutdown();
    }

    @Override
    public int stopDevice() {
        this.logger.info("Stopping " + this + " ...");
        return this.shutdown();
    }

    @Override
    public int handleAction(Long actionID, Long alarmScriptID, Long alarmInstanceID, Long alarmDuration, byte[] genericData) {
        this.logger.info("Action [" + actionID + "] of scenario [" + alarmScriptID + "] with duration [" + alarmDuration / 1000L + "," + alarmDuration % 1000L + " s] is triggered on " + this + " ...");
        if (this.ioHandler != null) {
            return super.getIOHandler().triggerAction(actionID, alarmScriptID, alarmInstanceID, alarmDuration, genericData);
        }
        this.logger.error("Cannot get [IOHandler] for " + this);
        return -21600;
    }

    @Override
    public int initializeDevice(long nSrvType) {
        return 0;
    }

    @Override
    protected IOHandler createIOHandler() {
        this.ioHandler = new AdvantechIOHandler();
        return this.ioHandler;
    }

    @Override
    protected boolean isSupportingIO() {
        return true;
    }

    @Override
    protected DeviceDefinition getDeviceDefinitionFromDevice(String signature, String manufacturer, String name, String comments) throws SeeTecException {
        return null;
    }

    @Override
    protected VideoCameraDefinition getVideoCameraDefinitionFromDevice() throws SeeTecException {
        return null;
    }

    @Override
    protected SupportedGenericEventsType getGenericEventTrigger() throws SeeTecException, ConfigurationException {
        throw new UnsupportedOperationException("Not yet implemented for " + this);
    }
}

