/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared.videosource;

import de.seetec.v5.re.cm.device.shared.videosource.RTPHeader;
import de.seetec.v5.re.cm.device.shared.videosource.TimestampCalculator;
import de.seetec.v5.re.cm.device.shared.videosource.TimestampCalculatorCallback;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UseRelativeRTPTimestamp
implements TimestampCalculator {
    public static final int FIXED_CLOCK_RATIO_FOR_VIDEO = 90;
    public static final long THRESHOLD_FOR_JUMP_DETECTION = TimeUnit.SECONDS.toMillis(3L);
    private final Logger logger = LogManager.getLogger((String)this.getClass().getName());
    private Long timeStartRtp = 0L;
    private Long rtpRandomStart = 0L;
    private Long previousAbsoluteTimestampFromCamera = 0L;
    private long previousRtpTimestampFromHeader = 0L;
    private Long previousAbsoluteTimestampFromSystem = 0L;
    private long currentDriftCompensation = 0L;
    private final TimestampCalculatorCallback timestampCalculatorCallback;

    public UseRelativeRTPTimestamp(TimestampCalculatorCallback timestampCalculatorCallback) {
        this.timestampCalculatorCallback = timestampCalculatorCallback;
    }

    @Override
    public long calculateAbsoluteTimestamp(long absoluteTimestampFromSystem, RTPHeader rtpHeader, int mediaType) {
        long absoluteTimestampFromCamera = 0L;
        long rtpTimestampFromHeader = rtpHeader.getTimestamp();
        if (this.timeStartRtp == 0L) {
            this.initializeTimeValues(rtpHeader, absoluteTimestampFromSystem);
            absoluteTimestampFromCamera = absoluteTimestampFromSystem;
        } else if (this.isWrapAround(rtpTimestampFromHeader)) {
            long restBeforeWarpAround = (long)Math.pow(2.0, 32.0) - this.previousRtpTimestampFromHeader;
            this.rtpRandomStart = rtpHeader.getTimestamp() / 90L;
            this.timeStartRtp = absoluteTimestampFromSystem - this.rtpRandomStart;
            absoluteTimestampFromCamera = this.previousAbsoluteTimestampFromCamera + (restBeforeWarpAround + rtpTimestampFromHeader) / 90L;
        } else {
            absoluteTimestampFromCamera = this.timeStartRtp + rtpTimestampFromHeader / 90L;
            if ((absoluteTimestampFromCamera = this.jumpCorrection(rtpTimestampFromHeader, rtpHeader, absoluteTimestampFromSystem, absoluteTimestampFromCamera)) != absoluteTimestampFromSystem) {
                absoluteTimestampFromCamera = this.driftCorrection(absoluteTimestampFromSystem, absoluteTimestampFromCamera);
            }
        }
        this.previousRtpTimestampFromHeader = rtpTimestampFromHeader;
        this.previousAbsoluteTimestampFromSystem = absoluteTimestampFromSystem;
        this.previousAbsoluteTimestampFromCamera = absoluteTimestampFromCamera;
        return absoluteTimestampFromCamera;
    }

    private long driftCorrection(long absoluteTimestampFromSystem, long absoluteTimestampFromCamera) {
        long correction = absoluteTimestampFromSystem < absoluteTimestampFromCamera ? -1L : 0L;
        long l = correction = absoluteTimestampFromSystem > absoluteTimestampFromCamera ? 1L : correction;
        if (correction != 0L) {
            UseRelativeRTPTimestamp useRelativeRTPTimestamp = this;
            useRelativeRTPTimestamp.timeStartRtp = useRelativeRTPTimestamp.timeStartRtp + correction;
            absoluteTimestampFromCamera += correction;
            this.currentDriftCompensation += correction;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Current drift compensation [ms]: " + this.currentDriftCompensation);
            }
        }
        return absoluteTimestampFromCamera;
    }

    private long jumpCorrection(long rtpTimestampFromHeader, RTPHeader rtpHeader, long absoluteTimestampFromSystem, long absoluteTimestampFromCamera) {
        if (this.previousRtpTimestampFromHeader > rtpTimestampFromHeader) {
            this.initializeTimeValues(rtpHeader, absoluteTimestampFromSystem);
            absoluteTimestampFromCamera = absoluteTimestampFromSystem;
            if (this.timestampCalculatorCallback != null) {
                this.timestampCalculatorCallback.cameraTimeJumped((rtpTimestampFromHeader - this.previousRtpTimestampFromHeader) / 90L);
            }
        } else if (this.previousRtpTimestampFromHeader + THRESHOLD_FOR_JUMP_DETECTION * 90L < rtpTimestampFromHeader && Math.abs(absoluteTimestampFromSystem - absoluteTimestampFromCamera) > THRESHOLD_FOR_JUMP_DETECTION) {
            this.initializeTimeValues(rtpHeader, absoluteTimestampFromSystem);
            absoluteTimestampFromCamera = absoluteTimestampFromSystem;
            if (this.timestampCalculatorCallback != null) {
                this.timestampCalculatorCallback.cameraTimeJumped((rtpTimestampFromHeader - this.previousRtpTimestampFromHeader) / 90L);
            }
        } else if (this.previousAbsoluteTimestampFromSystem > absoluteTimestampFromSystem) {
            this.initializeTimeValues(rtpHeader, absoluteTimestampFromSystem);
            absoluteTimestampFromCamera = absoluteTimestampFromSystem;
            if (this.timestampCalculatorCallback != null) {
                this.timestampCalculatorCallback.serverTimeJumped(absoluteTimestampFromSystem - this.previousAbsoluteTimestampFromSystem);
            }
        } else if (Math.abs(Math.abs(absoluteTimestampFromSystem - this.previousAbsoluteTimestampFromSystem) - Math.abs(absoluteTimestampFromCamera - this.previousAbsoluteTimestampFromCamera)) > THRESHOLD_FOR_JUMP_DETECTION) {
            this.initializeTimeValues(rtpHeader, absoluteTimestampFromSystem);
            absoluteTimestampFromCamera = absoluteTimestampFromSystem;
            if (this.timestampCalculatorCallback != null) {
                this.timestampCalculatorCallback.serverTimeJumped(absoluteTimestampFromSystem - this.previousAbsoluteTimestampFromSystem);
            }
        } else if (Math.abs(absoluteTimestampFromSystem - absoluteTimestampFromCamera) > THRESHOLD_FOR_JUMP_DETECTION) {
            if (this.timestampCalculatorCallback != null) {
                this.timestampCalculatorCallback.hugeCumulatedDriftCorrectedByJump(absoluteTimestampFromSystem - absoluteTimestampFromCamera);
            }
            this.initializeTimeValues(rtpHeader, absoluteTimestampFromSystem);
            absoluteTimestampFromCamera = absoluteTimestampFromSystem;
        }
        return absoluteTimestampFromCamera;
    }

    private void initializeTimeValues(RTPHeader rtpHeader, long absoluteTimestampFromSystem) {
        this.rtpRandomStart = rtpHeader.getTimestamp() / 90L;
        this.timeStartRtp = absoluteTimestampFromSystem - this.rtpRandomStart;
        this.currentDriftCompensation = 0L;
    }

    private boolean isWrapAround(long rtpTimestampFromHeader) {
        if (this.previousRtpTimestampFromHeader != 0L && rtpTimestampFromHeader / 90L < TimeUnit.HOURS.toMillis(2L) && this.previousRtpTimestampFromHeader / 90L > (long)Math.pow(2.0, 32.0) / 90L - TimeUnit.HOURS.toMillis(2L)) {
            this.logger.info("Guess we have an overflow/wrap-around: Old one: " + this.previousRtpTimestampFromHeader + ". In this packet: " + rtpTimestampFromHeader);
            return true;
        }
        return false;
    }

    @Override
    public void reset() {
    }
}

