/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared.videosource;

import de.seetec.v5.re.cm.device.shared.net.NetworkCallback;
import de.seetec.v5.re.cm.device.shared.net.udp.UdpWriterUnicast;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingHelper;
import de.seetec.v5.re.cm.device.shared.videosource.VideoSourceClient;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.re.shared.MediaFrame;
import de.seetec.v5.re.shared.TransmissionType;
import de.seetec.v5.shared.Basic;
import java.io.ByteArrayOutputStream;
import java.util.Arrays;

public abstract class StreamingVideoSourceClient
extends VideoSourceClient {
    protected int errorCode = 0;
    protected ByteArrayOutputStream completeFrame = null;
    protected int bandwidth = Integer.MIN_VALUE;
    protected long fps = Integer.MIN_VALUE;
    protected long iFrameDist = Integer.MIN_VALUE;
    protected int iFrameDistMS = Integer.MIN_VALUE;
    protected boolean isConstantBitrateUsed = true;
    protected TransmissionType transmissionID = TransmissionType.UNKNOWN;
    protected int camID = Integer.MIN_VALUE;
    private LegacyAudioSourceClient legacyAudioSourceClient = null;
    protected boolean isAudioEnabled = false;
    protected Codec audioCodec = Codec.UNKNOWN;
    protected int audioBitrate = Integer.MIN_VALUE;
    protected byte[] receiverReport = new byte[32];

    protected LegacyAudioSourceClient getLegacyAudioSourceClient() {
        return this.legacyAudioSourceClient;
    }

    protected void setLegacyAudioSourceClient(LegacyAudioSourceClient legacyAudioSourceClient) {
        this.legacyAudioSourceClient = legacyAudioSourceClient;
    }

    @Override
    protected int init() {
        this.errorCode = super.init();
        if (this.errorCode != 0) {
            this.logger.error("Error while initializing. Code: " + this.errorCode + " for " + (Object)((Object)this));
            return this.errorCode;
        }
        try {
            this.iFrameDistMS = this.listener.getVideoSourceParameter().getIFrameDistance();
            this.bandwidth = this.listener.getVideoSourceParameter().getBandWidth();
            this.fps = this.listener.getFramerate();
            this.camID = this.listener.getVideoSourceParameter().getPtzAddress();
            this.isConstantBitrateUsed = this.listener.getVideoSourceParameter().getBandwidthControl() == 1;
            this.transmissionID = this.listener.getVideoSourceParameter().getTransmissionID();
            if (this.transmissionID == TransmissionType.RTP_OVER_RTSP_OVER_HTTP_UNICAST) {
                this.logger.info("RTP/RTSP tunneling enabled for " + super.getVideoSrv());
            }
            if (this.listener.getVideoSourceParameter().isAudioEnabled()) {
                this.isAudioEnabled = true;
                this.audioCodec = this.listener.getVideoSourceParameter().getAudioCodec();
                this.audioBitrate = this.listener.getVideoSourceParameter().getAudioDefaultBitrate();
            }
        }
        catch (Exception ex) {
            this.logger.error("Reading configuration failed from " + super.getVideoSrv(), (Throwable)ex);
            this.errorCode = -21601;
        }
        return this.errorCode;
    }

    public int shutdown() {
        if (this.legacyAudioSourceClient != null) {
            this.legacyAudioSourceClient.shutdown();
        }
        this.legacyAudioSourceClient = null;
        return 0;
    }

    protected class LegacyAudioSourceClient
    implements NetworkCallback {
        private NetworkCallback listener = null;
        private byte[] receiverReportAudio = new byte[32];
        private UdpWriterUnicast udpRTCPWriterAudio = null;
        private int paddingCounter = 0;

        public LegacyAudioSourceClient(NetworkCallback listener) {
            this.listener = listener;
            this.receiverReportAudio[0] = -127;
            this.receiverReportAudio[1] = -55;
            this.receiverReportAudio[2] = 0;
            this.receiverReportAudio[3] = 7;
        }

        public int init(UdpWriterUnicast udpRTCPWriterAudio) {
            this.udpRTCPWriterAudio = udpRTCPWriterAudio;
            return 0;
        }

        @Override
        public void onNetworkError(int error) {
            if (this.listener != null) {
                this.listener.onNetworkError(error);
            }
        }

        @Override
        public void onUdpData(byte[] data) {
            this.processData(data);
        }

        private void processData(byte[] data) {
            try {
                int extensionHeaderLength = 0;
                if ((data[0] & 0x10) == 16) {
                    extensionHeaderLength = Basic.byteArrayToInt4((byte[])new byte[]{data[14], data[15]});
                    extensionHeaderLength *= 4;
                    extensionHeaderLength += 4;
                }
                if (data.length >= 2 && data[0] == -128 && data[1] == -56) {
                    System.arraycopy(data, 4, this.receiverReportAudio, 8, 4);
                    System.arraycopy(data, 10, this.receiverReportAudio, 24, 4);
                    if (this.udpRTCPWriterAudio != null) {
                        this.udpRTCPWriterAudio.send(this.receiverReportAudio);
                    }
                } else {
                    this.paddingCounter = 0;
                    if ((data[0] & 0x20) == 32) {
                        this.paddingCounter = data[data.length - 1];
                    }
                    System.arraycopy(data, 2, this.receiverReportAudio, 18, 2);
                    MediaFrame mediaFrame = StreamingHelper.createSeeTecAudioFrameHeader(StreamingVideoSourceClient.this.audioCodec, StreamingVideoSourceClient.this.audioBitrate % 8000 == 0 ? (byte)(StreamingVideoSourceClient.this.audioBitrate / 8000) : (byte)0, Arrays.copyOfRange(data, 12 + extensionHeaderLength, data.length - this.paddingCounter));
                    StreamingVideoSourceClient.this.deliverFrameCreateServerTimestamp(16, mediaFrame);
                }
            }
            catch (Throwable t) {
                StreamingVideoSourceClient.this.logger.error("Ignoring packet due to unexpected error: " + t.getMessage(), t);
            }
        }

        public void shutdown() {
            this.listener = null;
            this.udpRTCPWriterAudio = null;
            this.receiverReportAudio = null;
        }

        public final byte[] getReceiverReportAudio() {
            return this.receiverReportAudio;
        }
    }
}

