/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared.videosource;

import de.seetec.v5.re.cm.device.shared.BitInputStream;
import de.seetec.v5.re.cm.device.shared.BitOutputStream;
import de.seetec.v5.re.cm.device.shared.videosource.Mpeg4Data;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingHelper;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.re.shared.MediaFrame;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StreamingHelperMpeg4
extends StreamingHelper {
    private static final Logger LOGGER = LogManager.getLogger(StreamingHelperMpeg4.class);

    public static int checkForMPEG4Part2MediaType(byte[] data) {
        return StreamingHelperMpeg4.checkForMPEG4Part2MediaType(data, 0);
    }

    public static int checkForMPEG4Part2MediaType(byte[] data, int offset) {
        if (data != null && data.length >= 5 + offset) {
            if (data[0 + offset] == 0 && data[1 + offset] == 0 && data[2 + offset] == 1) {
                if ((data[4 + offset] >>> 6 & 3) == 0) {
                    return 33;
                }
                if ((data[4 + offset] >>> 6 & 3) == 1) {
                    return 35;
                }
                if ((data[4 + offset] >>> 6 & 3) == 2) {
                    return 35;
                }
                if ((data[4 + offset] >>> 6 & 3) == 3) {
                    return 33;
                }
                LOGGER.warn("Unknown frametype '" + (data[4 + offset] >>> 6) + "'. (length:" + data.length + ")!");
                return Integer.MIN_VALUE;
            }
            LOGGER.warn("No starting sequence found.");
            return Integer.MIN_VALUE;
        }
        return Integer.MIN_VALUE;
    }

    public static int[] extractMPEG4Part2Resolution(byte[] data) {
        if (data != null) {
            int startIndex = Basic.indexOfByteArray((byte[])data, (byte[])START_SEQUENCE_VIDEO_OBJECT_LAYER_00, (int)0);
            if (startIndex != -1 || (startIndex = Basic.indexOfByteArray((byte[])data, (byte[])START_SEQUENCE_VIDEO_OBJECT_LAYER_01, (int)0)) != -1) {
                byte[] bytesToEvaluate = new byte[data.length - startIndex];
                System.arraycopy(data, startIndex, bytesToEvaluate, 0, data.length - startIndex);
                BitInputStream bin = new BitInputStream(bytesToEvaluate);
                ByteArrayOutputStream fout = new ByteArrayOutputStream();
                BitOutputStream bout = new BitOutputStream(fout);
                int[] resolutionLocal = new int[2];
                try {
                    int videoObjectLayerShape;
                    int aspectRatioInfo;
                    int videoObjectLayerVERID = 0;
                    bin.skipBits(9);
                    if (bin.readBit() == 1) {
                        videoObjectLayerVERID = (int)(Math.pow(2 * bin.readBit(), 3.0) + Math.pow(2 * bin.readBit(), 2.0) + (double)(2 * bin.readBit()) + (double)bin.readBit());
                        bin.skipBits(3);
                    }
                    if ((aspectRatioInfo = (int)(Math.pow(2 * bin.readBit(), 3.0) + Math.pow(2 * bin.readBit(), 2.0) + (double)(2 * bin.readBit()) + (double)bin.readBit())) == 15) {
                        bin.skipBits(16);
                    }
                    if (bin.readBit() == 1) {
                        bin.skipBits(3);
                        if (bin.readBit() == 1) {
                            bin.skipBits(79);
                        }
                    }
                    if ((videoObjectLayerShape = 2 * bin.readBit() + bin.readBit()) == 3 && videoObjectLayerVERID == 1) {
                        bin.skipBits(4);
                    }
                    bin.skipBits(1);
                    for (int i = 0; i <= 15; ++i) {
                        bout.writeBit(bin.readBit());
                    }
                    bout.close();
                    byte[] tmp = new byte[]{fout.toByteArray()[0], fout.toByteArray()[1]};
                    int vopTimeIncrementResolution = Basic.byteArrayToInt4((byte[])tmp);
                    fout.reset();
                    bout = new BitOutputStream(fout);
                    bin.skipBits(1);
                    if (bin.readBit() == 1) {
                        int skip = (int)Math.round(Math.ceil(Math.log(vopTimeIncrementResolution) / Math.log(2.0)));
                        bin.skipBits(skip);
                    }
                    if (videoObjectLayerShape != 2 && videoObjectLayerShape == 0) {
                        bin.readBit();
                        bout.skipBits(3);
                        for (int i = 0; i < 13; ++i) {
                            bout.writeBit(bin.readBit());
                        }
                        bout.close();
                        byte[] w = new byte[]{fout.toByteArray()[0], fout.toByteArray()[1]};
                        resolutionLocal[0] = Basic.byteArrayToInt4((byte[])w);
                        bin.readBit();
                        fout.reset();
                        bout = new BitOutputStream(fout);
                        bout.skipBits(3);
                        for (int i = 0; i < 13; ++i) {
                            bout.writeBit(bin.readBit());
                        }
                        bout.close();
                        byte[] h = new byte[]{fout.toByteArray()[0], fout.toByteArray()[1]};
                        resolutionLocal[1] = Basic.byteArrayToInt4((byte[])h);
                    }
                }
                catch (IOException ee) {
                    LOGGER.error("Error extracting resolution from MPEG-4 data.", (Throwable)ee);
                }
                try {
                    bin.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    bout.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    fout.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return resolutionLocal;
            }
            LOGGER.warn("No typical MPEG sequence found.");
            LOGGER.info(Basic.byteArrayToHexString((byte[])data, (int)0, (int)100));
            return null;
        }
        return null;
    }

    public static MediaFrame processMpeg4Data(Mpeg4Data mpeg4Data) throws SeeTecException {
        if (mpeg4Data.getMediaType() >= 0) {
            if (mpeg4Data.getMediaType() == 33 && mpeg4Data.getCurrentResolution() == null) {
                mpeg4Data.setCurrentResolution(StreamingHelperMpeg4.extractMPEG4Part2Resolution(mpeg4Data.getFrameData()));
                if (mpeg4Data.getCurrentResolution() != null) {
                    mpeg4Data.setWidth(mpeg4Data.getCurrentResolution()[0]);
                    mpeg4Data.setHeight(mpeg4Data.getCurrentResolution()[1]);
                } else {
                    mpeg4Data.setConfigHeader(mpeg4Data.getDescribeResponse().getSequenceParameterSet());
                    if (mpeg4Data.getConfigHeader() != null && mpeg4Data.getConfigHeader().length > 0) {
                        mpeg4Data.setCurrentResolution(StreamingHelperMpeg4.extractMPEG4Part2Resolution(mpeg4Data.getConfigHeader()));
                        if (mpeg4Data.getCurrentResolution() != null) {
                            mpeg4Data.setWidth(mpeg4Data.getCurrentResolution()[0]);
                            mpeg4Data.setHeight(mpeg4Data.getCurrentResolution()[1]);
                        } else {
                            LOGGER.warn("Resolution could not be extracted");
                        }
                    }
                }
            }
            if (mpeg4Data.getMediaType() == 7) {
                mpeg4Data.setMediaType(33);
            }
            return StreamingHelper.createSeeTecVideoFrameHeader(Codec.MPEG4, mpeg4Data.getWidth(), mpeg4Data.getHeight(), mpeg4Data.getFrameData());
        }
        return null;
    }
}

