/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared.videosource;

import de.seetec.v5.re.cm.device.shared.BitInputStream;
import de.seetec.v5.re.cm.device.shared.Device;
import de.seetec.v5.re.cm.device.shared.videosource.H265Data;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingHelper;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.re.shared.MediaFrame;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StreamingHelperH265
extends StreamingHelper {
    private static final Logger LOGGER = LogManager.getLogger(StreamingHelperH265.class);

    public static int checkForH265MediaType(Device device, byte[] data) {
        return StreamingHelperH265.checkForH265MediaType(device, data, 0);
    }

    public static int checkForH265MediaType(Device device, byte[] data, int skipBytes) {
        if (data == null) {
            LOGGER.error("Given data is null");
            return Integer.MIN_VALUE;
        }
        int startIndex = Basic.indexOfByteArray((byte[])data, (byte[])START_SEQUENCE_0001, (int)(skipBytes = skipBytes < 0 ? 0 : skipBytes), (boolean)true);
        if (startIndex < 0) {
            LOGGER.error("Bytes to skip specified but after that no START_SEQUENCE_0001 found. skip: " + skipBytes);
            return Integer.MIN_VALUE;
        }
        int OFFSET = startIndex + 4;
        if (data.length - 1 >= OFFSET) {
            int nalUnitType = (data[OFFSET] & 0x7E) >> 1;
            switch (nalUnitType) {
                case 19: 
                case 20: {
                    return 33;
                }
                case 0: 
                case 1: {
                    return 35;
                }
                case 32: {
                    return 288;
                }
                case 33: {
                    return 289;
                }
                case 34: {
                    return 290;
                }
                case 35: {
                    return 291;
                }
                case 39: 
                case 40: {
                    return 6;
                }
            }
            return Integer.MIN_VALUE;
        }
        LOGGER.error("Unexpected (Length: " + data.length + ", try to access: " + OFFSET + ") data for" + device);
        return Integer.MIN_VALUE;
    }

    public static final int[] extractH265Resolution(byte[] data) {
        return StreamingHelperH265.extractH265Resolution(data, 0);
    }

    protected static int[] extractH265Resolution(byte[] data, int skip) {
        try {
            return StreamingHelperH265.read_sps_resolution(data, skip);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static MediaFrame processH265Data(H265Data h265Data, Basic basic) throws SeeTecException {
        if (h265Data.getMediaType() < 0) {
            LOGGER.info("No media type");
        } else if (h265Data.getMediaType() == 291) {
            StreamingHelperH265.removeAccessUnitDelimiter(h265Data);
        } else if (h265Data.getMediaType() == 288) {
            if (h265Data.getVideoParameterSet() == null || h265Data.isRespectEveryParameterSet()) {
                h265Data.setVideoParameterSet(new byte[h265Data.getCompleteFrameAsByteArray().length]);
                System.arraycopy(h265Data.getCompleteFrameAsByteArray(), 0, h265Data.getVideoParameterSet(), 0, h265Data.getCompleteFrameAsByteArray().length);
            }
        } else if (h265Data.getMediaType() == 289) {
            if (h265Data.getParameterSetPart() == null || h265Data.isRespectEveryParameterSet()) {
                h265Data.setParameterSetPart(new byte[h265Data.getCompleteFrameAsByteArray().length]);
                System.arraycopy(h265Data.getCompleteFrameAsByteArray(), 0, h265Data.getParameterSetPart(), 0, h265Data.getCompleteFrameAsByteArray().length);
            }
        } else if (h265Data.getMediaType() == 290) {
            if (h265Data.getPictureSet() == null || h265Data.isRespectEveryParameterSet()) {
                h265Data.setPictureSet(new byte[h265Data.getCompleteFrameAsByteArray().length]);
                System.arraycopy(h265Data.getCompleteFrameAsByteArray(), 0, h265Data.getPictureSet(), 0, h265Data.getCompleteFrameAsByteArray().length);
            }
        } else {
            if (h265Data.getMediaType() == 33) {
                if (h265Data.getParameterSetPart() == null && h265Data.getDescribeResponse().getVideoParameterSet() != null) {
                    h265Data.setVideoParameterSet(new byte[StreamingHelper.START_SEQUENCE_0001.length + h265Data.getDescribeResponse().getVideoParameterSet().length]);
                    System.arraycopy(StreamingHelper.START_SEQUENCE_0001, 0, h265Data.getVideoParameterSet(), 0, StreamingHelper.START_SEQUENCE_0001.length);
                    System.arraycopy(h265Data.getDescribeResponse().getVideoParameterSet(), 0, h265Data.getVideoParameterSet(), StreamingHelper.START_SEQUENCE_0001.length, h265Data.getDescribeResponse().getVideoParameterSet().length);
                }
                if (h265Data.getParameterSetPart() == null && h265Data.getDescribeResponse().getSequenceParameterSet().length > 0) {
                    h265Data.setParameterSetPart(new byte[StreamingHelper.START_SEQUENCE_0001.length + h265Data.getDescribeResponse().getSequenceParameterSet().length]);
                    System.arraycopy(StreamingHelper.START_SEQUENCE_0001, 0, h265Data.getParameterSetPart(), 0, StreamingHelper.START_SEQUENCE_0001.length);
                    System.arraycopy(h265Data.getDescribeResponse().getSequenceParameterSet(), 0, h265Data.getParameterSetPart(), StreamingHelper.START_SEQUENCE_0001.length, h265Data.getDescribeResponse().getSequenceParameterSet().length);
                }
                if (h265Data.getPictureSet() == null && h265Data.getDescribeResponse().getPictureParameterSet().length > 0) {
                    h265Data.setPictureSet(new byte[StreamingHelper.START_SEQUENCE_0001.length + h265Data.getDescribeResponse().getPictureParameterSet().length]);
                    System.arraycopy(StreamingHelper.START_SEQUENCE_0001, 0, h265Data.getPictureSet(), 0, StreamingHelper.START_SEQUENCE_0001.length);
                    System.arraycopy(h265Data.getDescribeResponse().getPictureParameterSet(), 0, h265Data.getPictureSet(), StreamingHelper.START_SEQUENCE_0001.length, h265Data.getDescribeResponse().getPictureParameterSet().length);
                }
                if ((h265Data.getConfigHeader() == null || h265Data.isRespectEveryParameterSet()) && h265Data.getVideoParameterSet() != null && h265Data.getParameterSetPart() != null && h265Data.getPictureSet() != null) {
                    h265Data.setConfigHeader(new byte[h265Data.getVideoParameterSet().length + h265Data.getParameterSetPart().length + h265Data.getPictureSet().length]);
                    System.arraycopy(h265Data.getVideoParameterSet(), 0, h265Data.getConfigHeader(), 0, h265Data.getVideoParameterSet().length);
                    System.arraycopy(h265Data.getParameterSetPart(), 0, h265Data.getConfigHeader(), h265Data.getVideoParameterSet().length, h265Data.getParameterSetPart().length);
                    System.arraycopy(h265Data.getPictureSet(), 0, h265Data.getConfigHeader(), h265Data.getVideoParameterSet().length + h265Data.getParameterSetPart().length, h265Data.getPictureSet().length);
                    int[] resolutionFromStream = StreamingHelperH265.extractH265Resolution(h265Data.getParameterSetPart());
                    if (LOGGER.isDebugEnabled() && resolutionFromStream != null && resolutionFromStream.length >= 2) {
                        LOGGER.info("Resolution: " + resolutionFromStream[0] + " - " + resolutionFromStream[1]);
                    }
                    if (!h265Data.isUseResolutionFromConfiguration() && resolutionFromStream != null) {
                        if (h265Data.isCheckResolution() && (h265Data.getWidth() != resolutionFromStream[0] || h265Data.getHeight() != resolutionFromStream[1])) {
                            LOGGER.warn("Resolution was not changed. Required resolution: " + h265Data.getWidth() + "x" + h265Data.getHeight() + ", Resolution on stream is " + resolutionFromStream[0] + "x" + resolutionFromStream[1] + " .Shutting down " + basic);
                            basic.shutdown();
                            return null;
                        }
                        h265Data.setWidth(resolutionFromStream[0]);
                        h265Data.setHeight(resolutionFromStream[1]);
                    }
                }
                if (h265Data.getConfigHeader() == null && h265Data.getWidth() > 0 && h265Data.getHeight() > 0) {
                    LOGGER.fatal("Config frame not arrived as first frame. Abort!");
                    basic.shutdown();
                }
                if (h265Data.isUseFrameCropping()) {
                    if (h265Data.isFirstIFramePart()) {
                        h265Data.setFirstIFramePart(false);
                        h265Data.setFirstPartIFrame(h265Data.getCompleteFrameAsByteArray());
                        return null;
                    }
                    h265Data.setFirstIFramePart(true);
                    ByteArrayOutputStream b = new ByteArrayOutputStream();
                    try {
                        b.write(h265Data.getFirstPartIFrame());
                        b.write(h265Data.getCompleteFrameAsByteArray());
                        h265Data.setCompleteFrameAsByteArray(b.toByteArray());
                    }
                    catch (IOException ex) {
                        LOGGER.info("Exception: " + ex.getMessage());
                    }
                }
                return StreamingHelper.createSeeTecVideoFrameHeader(Codec.H265, h265Data.getWidth(), h265Data.getHeight(), h265Data.getCompleteFrameAsByteArray(), h265Data.getConfigHeader());
            }
            if (h265Data.getMediaType() == 35) {
                if (h265Data.isUseFrameCropping()) {
                    if (h265Data.isFirstPFramePart()) {
                        h265Data.setFirstPFramePart(false);
                        h265Data.setFirstPartPFrame(h265Data.getCompleteFrameAsByteArray());
                        return null;
                    }
                    h265Data.setFirstPFramePart(true);
                    ByteArrayOutputStream b = new ByteArrayOutputStream();
                    try {
                        if (h265Data.getFirstPartPFrame().length < h265Data.getCompleteFrameAsByteArray().length) {
                            h265Data.setFirstPFramePart(false);
                            return null;
                        }
                        b.write(h265Data.getFirstPartPFrame());
                        b.write(h265Data.getCompleteFrameAsByteArray());
                        h265Data.setCompleteFrameAsByteArray(b.toByteArray());
                    }
                    catch (IOException ex) {
                        LOGGER.error("Exception: " + ex.getMessage());
                    }
                }
                if (h265Data.isDeliverPPSBeforePFrameIfAvailable()) {
                    int[] resolutionFromStream = StreamingHelperH265.extractH265Resolution(h265Data.getConfigHeader());
                    if (!h265Data.isUseResolutionFromConfiguration() && resolutionFromStream != null) {
                        if (h265Data.isCheckResolution() && (h265Data.getWidth() != resolutionFromStream[0] || h265Data.getHeight() != resolutionFromStream[1])) {
                            LOGGER.warn("Resolution was not changed. Required resolution: " + h265Data.getWidth() + "x" + h265Data.getHeight() + ", Resolution on stream is " + resolutionFromStream[0] + "x" + resolutionFromStream[1] + " .Shutting down " + basic);
                            basic.shutdown();
                            return null;
                        }
                        h265Data.setWidth(resolutionFromStream[0]);
                        h265Data.setHeight(resolutionFromStream[1]);
                    }
                    return StreamingHelper.createSeeTecVideoFrameHeader(Codec.H265, h265Data.getWidth(), h265Data.getHeight(), h265Data.getCompleteFrameAsByteArray(), h265Data.getPictureSet());
                }
                return StreamingHelper.createSeeTecVideoFrameHeader(Codec.H265, h265Data.getWidth(), h265Data.getHeight(), h265Data.getCompleteFrameAsByteArray());
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] demaskH265Data(byte[] dataToDemask, int offset) {
        byte[] SEARCH_PATTERN = new byte[]{0, 0, 3};
        byte[] REPLACE_PATTERN = new byte[]{0, 0};
        if (dataToDemask == null) {
            return null;
        }
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            if (offset > 0 && offset <= dataToDemask.length - 1) {
                result.write(Arrays.copyOfRange(dataToDemask, 0, offset));
            }
            int index = 0;
            while (index != -1) {
                index = Basic.indexOfByteArray((byte[])dataToDemask, (byte[])SEARCH_PATTERN, (int)offset, (boolean)true);
                if (index == -1) {
                    result.write(Arrays.copyOfRange(dataToDemask, offset, dataToDemask.length));
                    break;
                }
                result.write(Arrays.copyOfRange(dataToDemask, offset, index));
                result.write(REPLACE_PATTERN);
                offset = index + SEARCH_PATTERN.length;
            }
            byte[] byArray = result.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            byte[] byArray = null;
            return byArray;
        }
        finally {
            try {
                result.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static int[] read_sps_resolution(byte[] sps, int skip) throws IOException {
        byte[] NAL_UNIT_COMPLETE = Arrays.copyOfRange(sps, 4, sps.length);
        byte[] NAL_UNIT_WITHOUT_HEADER = Arrays.copyOfRange(NAL_UNIT_COMPLETE, 2, NAL_UNIT_COMPLETE.length);
        byte[] NAL_UNIT_CLEANED = StreamingHelperH265.demaskH265Data(NAL_UNIT_WITHOUT_HEADER, 0);
        BitInputStream inputStream = new BitInputStream(NAL_UNIT_CLEANED);
        int sps_video_parameter_set_id = StreamingHelper.readBitsAsInteger(inputStream, 4);
        int sps_max_sub_layers_minus1 = StreamingHelper.readBitsAsInteger(inputStream, 3);
        int sps_temporal_id_nesting_flag = StreamingHelper.readBitsAsInteger(inputStream, 1);
        int skippedBits = StreamingHelperH265.profile_tier_level(inputStream, 1, sps_max_sub_layers_minus1);
        int seq_parameter_set_id = StreamingHelperH265.expGolomb(inputStream);
        int chroma_format_idc = StreamingHelperH265.expGolomb(inputStream);
        int width = StreamingHelperH265.expGolomb(inputStream);
        int height = StreamingHelperH265.expGolomb(inputStream);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.info("SPS NAL_UNIT: " + Basic.byteArrayToHexString((byte[])NAL_UNIT_COMPLETE));
            LOGGER.info("SPS NAL_UNIT CLEANED: " + Basic.byteArrayToHexString((byte[])NAL_UNIT_CLEANED));
            LOGGER.info("sps_video_parameter_set_id (4 bit): " + sps_video_parameter_set_id);
            LOGGER.info("READ sps_max_sub_layers_minus1 (3bit): " + sps_max_sub_layers_minus1);
            LOGGER.info("SKIPPING sps_temporal_id_nesting_flag (1 bit): " + sps_temporal_id_nesting_flag);
            LOGGER.info("profile_tier_level (" + skippedBits + " bits)");
            LOGGER.info("seq_parameter_set_id: " + seq_parameter_set_id);
            LOGGER.info("chroma_format_idc: " + chroma_format_idc);
            LOGGER.info("Resolution: " + width + "x" + height);
        }
        int[] resolution = new int[]{width, height};
        return resolution;
    }

    public static int expGolomb(BitInputStream inputStream) throws IOException {
        int numLeadingZeroBits = 0;
        int codeStart = 1;
        while (inputStream.readBit() == 0) {
            ++numLeadingZeroBits;
            codeStart *= 2;
        }
        return codeStart - 1 + StreamingHelper.readBitsAsInteger(inputStream, numLeadingZeroBits);
    }

    public static int profile_tier_level(BitInputStream inputStream, int profilePresentFlag, int spsMaxSubLayersMinus1) throws IOException {
        int i;
        int skippedBits = 0;
        inputStream.skipBits(96);
        skippedBits += 96;
        ArrayList<Boolean> sub_layer_profile_present_flag = new ArrayList<Boolean>();
        ArrayList<Boolean> sub_layer_level_present_flag = new ArrayList<Boolean>();
        for (i = 0; i < spsMaxSubLayersMinus1; ++i) {
            sub_layer_profile_present_flag.add(inputStream.readBit() == 1);
            sub_layer_level_present_flag.add(inputStream.readBit() == 1);
            skippedBits += 2;
        }
        if (spsMaxSubLayersMinus1 > 0) {
            int jump = 2 * (8 - spsMaxSubLayersMinus1);
            inputStream.skipBits(jump);
            skippedBits += jump;
        }
        for (i = 0; i < spsMaxSubLayersMinus1; ++i) {
            if (((Boolean)sub_layer_profile_present_flag.get(i)).booleanValue()) {
                inputStream.skipBits(88);
                skippedBits += 88;
            }
            if (!((Boolean)sub_layer_level_present_flag.get(i)).booleanValue()) continue;
            inputStream.skipBits(8);
            skippedBits += 8;
        }
        return skippedBits;
    }

    private static void removeAccessUnitDelimiter(H265Data h265Data) {
        byte[] data = h265Data.getCompleteFrameAsByteArray();
        int startIndex = Basic.indexOfByteArray((byte[])data, (byte[])START_SEQUENCE_0001, (int)START_SEQUENCE_0001.length, (boolean)true);
        if (startIndex > 0) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(data, startIndex, data.length - startIndex);
            byte[] b = baos.toByteArray();
            int mediaType = StreamingHelperH265.checkForH265MediaType(null, b);
            if (mediaType == 288) {
                h265Data.setCompleteFrameAsByteArray(b);
                h265Data.setVideoParameterSet(b);
                h265Data.mediaType = mediaType;
            }
        }
    }
}

