/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared.videosource;

import de.seetec.v5.re.cm.device.shared.BitInputStream;
import de.seetec.v5.re.cm.device.shared.Device;
import de.seetec.v5.re.cm.device.shared.videosource.H264Data;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingHelper;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.re.shared.MediaFrame;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StreamingHelperH264
extends StreamingHelper {
    private static final Logger LOGGER = LogManager.getLogger(StreamingHelperH264.class);

    public static int checkForH264MediaType(Device device, byte[] data) {
        return StreamingHelperH264.checkForH264MediaType(device, data, 0);
    }

    public static int checkForH264MediaType(Device device, byte[] data, int skipBytes) {
        if (data == null) {
            LOGGER.error("Given data is null");
            return Integer.MIN_VALUE;
        }
        int startIndex = Basic.indexOfByteArray((byte[])data, (byte[])START_SEQUENCE, (int)(skipBytes = skipBytes < 0 ? 0 : skipBytes), (boolean)true);
        if (startIndex < 0) {
            LOGGER.error("Bytes to skip specified but after that no START_SEQUENCE found. skip: " + skipBytes);
            return Integer.MIN_VALUE;
        }
        int OFFSET = startIndex + 3;
        if (data.length - 1 >= OFFSET) {
            switch (data[OFFSET] & 0x1F) {
                case 5: {
                    return 33;
                }
                case 1: {
                    byte[] bytesToEvaluate = new byte[data.length - (OFFSET + 1)];
                    System.arraycopy(data, OFFSET + 1, bytesToEvaluate, 0, data.length - (OFFSET + 1));
                    BitInputStream bin = new BitInputStream(bytesToEvaluate);
                    try {
                        StreamingHelperH264.calculateExpGolomb(bin);
                        int sliceType = StreamingHelperH264.calculateExpGolomb(bin);
                        if (sliceType == 2 || sliceType == 4 || sliceType == 7 || sliceType == 9) {
                            return 33;
                        }
                        return 35;
                    }
                    catch (IOException e) {
                        LOGGER.error("Exception while extracting slice type from H.264 stream: " + e.getMessage(), (Throwable)e);
                        return 35;
                    }
                }
                case 6: {
                    return 6;
                }
                case 7: {
                    return 7;
                }
                case 8: {
                    return 8;
                }
                case 9: {
                    return 9;
                }
                case 10: {
                    return 16;
                }
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.warn("Unknown frametype '" + (data[OFFSET] & 0x1F) + "'. (length:" + data.length + ")!");
                LOGGER.warn("Given skip " + skipBytes);
                LOGGER.info(Basic.byteArrayToHexString((byte[])data, (int)0, (int)(data.length > 100 ? 100 : data.length)));
            }
            return Integer.MIN_VALUE;
        }
        LOGGER.error("Unexpected (Length: " + data.length + ", try to access: " + OFFSET + ") data for" + device);
        return Integer.MIN_VALUE;
    }

    public static final int[] extractH264Resolution(byte[] data) {
        return StreamingHelperH264.extractH264Resolution(data, 0);
    }

    public static int[] extractH264Resolution(byte[] data, int skip) {
        int OFFSET = 3;
        int chromaFormatIdc = 1;
        if (skip < 0) {
            LOGGER.fatal("Skip must not be negative: " + skip);
        }
        if (data != null && data.length > (OFFSET += skip) + 4) {
            if ((data[OFFSET] & 0x1F) == 7) {
                byte profileIDC = data[OFFSET + 1];
                byte[] bytesToEvaluate = new byte[data.length - (OFFSET + 4)];
                System.arraycopy(data, OFFSET + 4, bytesToEvaluate, 0, data.length - (OFFSET + 4));
                BitInputStream bin = new BitInputStream(bytesToEvaluate);
                try {
                    int i;
                    StreamingHelperH264.calculateExpGolomb(bin);
                    if (profileIDC == 100 || profileIDC == 110 || profileIDC == 122 || profileIDC == 144) {
                        chromaFormatIdc = StreamingHelperH264.calculateExpGolomb(bin);
                        if (chromaFormatIdc == 3) {
                            bin.readBit();
                        }
                        StreamingHelperH264.calculateExpGolomb(bin);
                        StreamingHelperH264.calculateExpGolomb(bin);
                        bin.readBit();
                        int seqScalingMatrixPresentFlag = bin.readBit();
                        if (seqScalingMatrixPresentFlag == 1) {
                            for (i = 0; i < (chromaFormatIdc != 3 ? 8 : 12); ++i) {
                                if (bin.readBit() != 1) continue;
                                if (i < 6) {
                                    StreamingHelperH264.scalingList(16, bin);
                                    continue;
                                }
                                StreamingHelperH264.scalingList(64, bin);
                            }
                        }
                    }
                    StreamingHelperH264.calculateExpGolomb(bin);
                    int picOrderCntType = StreamingHelperH264.calculateExpGolomb(bin);
                    if (picOrderCntType == 0) {
                        i = StreamingHelperH264.calculateExpGolomb(bin);
                    } else if (picOrderCntType == 1) {
                        int delta_pic_order_always_zero_flag = bin.readBit();
                        StreamingHelperH264.calculateExpGolomb(bin);
                        int offset_for_top_to_bottom_field = StreamingHelperH264.calculateExpGolomb(bin);
                        int numRefFramesInPicOrderCntCycle = StreamingHelperH264.calculateExpGolomb(bin);
                        for (int i2 = 0; i2 < numRefFramesInPicOrderCntCycle; ++i2) {
                            StreamingHelperH264.calculateExpGolomb(bin);
                        }
                    }
                    StreamingHelperH264.calculateExpGolomb(bin);
                    bin.readBit();
                    int pic_width_in_mbs_minus1 = StreamingHelperH264.calculateExpGolomb(bin);
                    int[] resolution = new int[2];
                    resolution[0] = (pic_width_in_mbs_minus1 + 1) * 16;
                    int pic_height_in_map_units_minus1 = StreamingHelperH264.calculateExpGolomb(bin);
                    resolution[1] = (pic_height_in_map_units_minus1 + 1) * 16;
                    int frameMBSOnlyFlag = bin.readBit();
                    if (frameMBSOnlyFlag == 0) {
                        bin.readBit();
                    }
                    resolution[1] = (2 - frameMBSOnlyFlag) * resolution[1];
                    bin.readBit();
                    int frame_cropping_flag = bin.readBit();
                    if (frame_cropping_flag == 1) {
                        int cropUnitY;
                        int cropUnitX;
                        if (chromaFormatIdc == 0) {
                            cropUnitX = 1;
                            cropUnitY = 2;
                        } else {
                            cropUnitX = chromaFormatIdc == 3 ? 1 : 2;
                            cropUnitY = chromaFormatIdc == 1 ? 2 : 1;
                            cropUnitY *= 2 - frameMBSOnlyFlag;
                        }
                        int cropLeft = StreamingHelperH264.calculateExpGolomb(bin);
                        int cropRight = StreamingHelperH264.calculateExpGolomb(bin);
                        int cropTop = StreamingHelperH264.calculateExpGolomb(bin);
                        int cropDown = StreamingHelperH264.calculateExpGolomb(bin);
                        resolution[0] = resolution[0] - (cropUnitX * cropLeft + cropUnitX * cropRight);
                        resolution[1] = resolution[1] - (cropUnitY * cropTop + cropUnitY * cropDown);
                    }
                    return resolution;
                }
                catch (IOException e) {
                    LOGGER.error("Exception while extracting resolution from H.264 stream: " + e.getMessage(), (Throwable)e);
                    return null;
                }
            }
            LOGGER.warn("Inspected data not a parameter set! Can't extract resolution info.");
            return null;
        }
        LOGGER.error("Given data is null.");
        return null;
    }

    public static MediaFrame processH264Data(H264Data h264Data, Basic basic) throws SeeTecException {
        if (h264Data.getMediaType() >= 0) {
            if (h264Data.getMediaType() == 7) {
                if (h264Data.getParameterSetPart() == null || h264Data.isRespectEveryParameterSet()) {
                    h264Data.setParameterSetPart(new byte[h264Data.getCompleteFrameAsByteArray().length]);
                    System.arraycopy(h264Data.getCompleteFrameAsByteArray(), 0, h264Data.getParameterSetPart(), 0, h264Data.getCompleteFrameAsByteArray().length);
                }
            } else if (h264Data.getMediaType() == 8) {
                if (h264Data.getPictureSet() == null || h264Data.isRespectEveryParameterSet()) {
                    h264Data.setPictureSet(new byte[h264Data.getCompleteFrameAsByteArray().length]);
                    System.arraycopy(h264Data.getCompleteFrameAsByteArray(), 0, h264Data.getPictureSet(), 0, h264Data.getCompleteFrameAsByteArray().length);
                }
            } else {
                if (h264Data.getMediaType() == 33) {
                    if (h264Data.getParameterSetPart() == null && h264Data.getDescribeResponse().getSequenceParameterSet().length > 0) {
                        h264Data.setParameterSetPart(new byte[StreamingHelper.START_SEQUENCE.length + h264Data.getDescribeResponse().getSequenceParameterSet().length]);
                        System.arraycopy(StreamingHelper.START_SEQUENCE, 0, h264Data.getParameterSetPart(), 0, StreamingHelper.START_SEQUENCE.length);
                        System.arraycopy(h264Data.getDescribeResponse().getSequenceParameterSet(), 0, h264Data.getParameterSetPart(), StreamingHelper.START_SEQUENCE.length, h264Data.getDescribeResponse().getSequenceParameterSet().length);
                    }
                    if (h264Data.getPictureSet() == null && h264Data.getDescribeResponse().getPictureParameterSet().length > 0) {
                        h264Data.setPictureSet(new byte[StreamingHelper.START_SEQUENCE.length + h264Data.getDescribeResponse().getPictureParameterSet().length]);
                        System.arraycopy(StreamingHelper.START_SEQUENCE, 0, h264Data.getPictureSet(), 0, StreamingHelper.START_SEQUENCE.length);
                        System.arraycopy(h264Data.getDescribeResponse().getPictureParameterSet(), 0, h264Data.getPictureSet(), StreamingHelper.START_SEQUENCE.length, h264Data.getDescribeResponse().getPictureParameterSet().length);
                    }
                    if ((h264Data.getConfigHeader() == null || h264Data.isRespectEveryParameterSet()) && h264Data.getParameterSetPart() != null && h264Data.getPictureSet() != null) {
                        h264Data.setConfigHeader(new byte[h264Data.getParameterSetPart().length + h264Data.getPictureSet().length]);
                        System.arraycopy(h264Data.getParameterSetPart(), 0, h264Data.getConfigHeader(), 0, h264Data.getParameterSetPart().length);
                        System.arraycopy(h264Data.getPictureSet(), 0, h264Data.getConfigHeader(), h264Data.getParameterSetPart().length, h264Data.getPictureSet().length);
                        int[] resolutionFromStream = StreamingHelperH264.extractH264Resolution(h264Data.getConfigHeader());
                        if (!h264Data.isUseResolutionFromConfiguration() && resolutionFromStream != null) {
                            if (h264Data.isCheckResolution() && (h264Data.getWidth() != resolutionFromStream[0] || h264Data.getHeight() != resolutionFromStream[1])) {
                                LOGGER.warn("Resolution was not changed. Required resolution: " + h264Data.getWidth() + "x" + h264Data.getHeight() + ", Resolution on stream is " + resolutionFromStream[0] + "x" + resolutionFromStream[1] + " .Shutting down " + basic);
                                basic.shutdown();
                                return null;
                            }
                            h264Data.setWidth(resolutionFromStream[0]);
                            h264Data.setHeight(resolutionFromStream[1]);
                        }
                    }
                    if (h264Data.getConfigHeader() == null && h264Data.getWidth() > 0 && h264Data.getHeight() > 0) {
                        LOGGER.fatal("Config frame not arrived as first frame. Abort!");
                        basic.shutdown();
                    }
                    if (h264Data.isUseFrameCropping()) {
                        if (h264Data.isFirstIFramePart()) {
                            h264Data.setFirstIFramePart(false);
                            h264Data.setFirstPartIFrame(h264Data.getCompleteFrameAsByteArray());
                            return null;
                        }
                        h264Data.setFirstIFramePart(true);
                        ByteArrayOutputStream b = new ByteArrayOutputStream();
                        try {
                            b.write(h264Data.getFirstPartIFrame());
                            b.write(h264Data.getCompleteFrameAsByteArray());
                            h264Data.setCompleteFrameAsByteArray(b.toByteArray());
                        }
                        catch (IOException ex) {
                            LOGGER.info("Exception: " + ex.getMessage());
                        }
                    }
                    return StreamingHelper.createSeeTecVideoFrameHeader(Codec.H264, h264Data.getWidth(), h264Data.getHeight(), h264Data.getCompleteFrameAsByteArray(), h264Data.getConfigHeader());
                }
                if (h264Data.getMediaType() == 35) {
                    if (h264Data.isUseFrameCropping()) {
                        if (h264Data.isFirstPFramePart()) {
                            h264Data.setFirstPFramePart(false);
                            h264Data.setFirstPartPFrame(h264Data.getCompleteFrameAsByteArray());
                            return null;
                        }
                        h264Data.setFirstPFramePart(true);
                        ByteArrayOutputStream b = new ByteArrayOutputStream();
                        try {
                            if (h264Data.getFirstPartPFrame().length < h264Data.getCompleteFrameAsByteArray().length) {
                                h264Data.setFirstPFramePart(false);
                                return null;
                            }
                            b.write(h264Data.getFirstPartPFrame());
                            b.write(h264Data.getCompleteFrameAsByteArray());
                            h264Data.setCompleteFrameAsByteArray(b.toByteArray());
                        }
                        catch (IOException ex) {
                            LOGGER.error("Exception: " + ex.getMessage());
                        }
                    }
                    if (h264Data.isDeliverPPSBeforePFrameIfAvailable()) {
                        int[] resolutionFromStream = StreamingHelperH264.extractH264Resolution(h264Data.getConfigHeader());
                        if (!h264Data.isUseResolutionFromConfiguration() && resolutionFromStream != null) {
                            if (h264Data.isCheckResolution() && (h264Data.getWidth() != resolutionFromStream[0] || h264Data.getHeight() != resolutionFromStream[1])) {
                                LOGGER.warn("Resolution was not changed. Required resolution: " + h264Data.getWidth() + "x" + h264Data.getHeight() + ", Resolution on stream is " + resolutionFromStream[0] + "x" + resolutionFromStream[1] + " .Shutting down " + basic);
                                basic.shutdown();
                                return null;
                            }
                            h264Data.setWidth(resolutionFromStream[0]);
                            h264Data.setHeight(resolutionFromStream[1]);
                        }
                        return StreamingHelper.createSeeTecVideoFrameHeader(Codec.H264, h264Data.getWidth(), h264Data.getHeight(), h264Data.getCompleteFrameAsByteArray(), h264Data.getPictureSet());
                    }
                    return StreamingHelper.createSeeTecVideoFrameHeader(Codec.H264, h264Data.getWidth(), h264Data.getHeight(), h264Data.getCompleteFrameAsByteArray());
                }
            }
        }
        return null;
    }

    public static List<byte[]> parseH264Data(byte[] data) {
        ArrayList<byte[]> list = new ArrayList<byte[]>();
        int marker = 0;
        int previousMarker = 1;
        while ((marker = Basic.indexOfByteArray((byte[])data, (byte[])StreamingHelper.START_SEQUENCE, (int)(marker + StreamingHelper.START_SEQUENCE.length), (boolean)true)) != -1) {
            list.add(Arrays.copyOfRange(data, previousMarker, marker));
            previousMarker = marker;
        }
        list.add(Arrays.copyOfRange(data, previousMarker, data.length));
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] demaskH264Data(byte[] dataToDemask, int offset) {
        byte[] SEARCH_PATTERN = new byte[]{0, 0, 3, 1};
        byte[] REPLACE_PATTERN = new byte[]{0, 0, 1};
        if (dataToDemask == null) {
            return null;
        }
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            if (offset > 0 && offset <= dataToDemask.length - 1) {
                result.write(Arrays.copyOfRange(dataToDemask, 0, offset));
            }
            int index = 0;
            while (index != -1) {
                index = Basic.indexOfByteArray((byte[])dataToDemask, (byte[])SEARCH_PATTERN, (int)offset, (boolean)true);
                if (index == -1) {
                    result.write(Arrays.copyOfRange(dataToDemask, offset, dataToDemask.length));
                    break;
                }
                result.write(Arrays.copyOfRange(dataToDemask, offset, index));
                result.write(REPLACE_PATTERN);
                offset = index + SEARCH_PATTERN.length;
            }
            byte[] byArray = result.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            byte[] byArray = null;
            return byArray;
        }
        finally {
            try {
                result.close();
            }
            catch (IOException iOException) {}
        }
    }
}

