/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared.videosource;

import de.seetec.v5.re.cm.device.shared.videoprofile.BasicVideoProfileHandler;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.Arrays;

public class RTPHeader {
    private byte[] extension;
    private boolean hasExtension = false;
    private int extensionLength = 0;
    private boolean hasMarker;
    private String ssrc;
    private long timestamp;
    private int profile;

    public RTPHeader(byte[] data) throws SeeTecException {
        if (data != null && data.length >= 12) {
            if ((data[0] & 0x80) != 128) {
                throw new SeeTecException(-21000, "No valid image data found ");
            }
            if ((data[0] & 0x10) == 16) {
                this.hasExtension = true;
                int rtpHeaderExtensionLength = 0;
                rtpHeaderExtensionLength |= data[14] & 0xFF;
                rtpHeaderExtensionLength <<= 8;
                rtpHeaderExtensionLength |= data[15] & 0xFF;
                this.extensionLength = rtpHeaderExtensionLength *= 4;
                this.extension = Arrays.copyOfRange(data, 16, 16 + this.extensionLength);
                this.profile = data[13];
            }
        } else {
            throw new SeeTecException(-21000, "No valid RTP header length.");
        }
        this.ssrc = "";
        byte[] timestampByteArray = new byte[]{0, 0, 0, 0, data[4], data[5], data[6], data[7]};
        this.timestamp = BasicVideoProfileHandler.byteArrayToInt8((byte[])timestampByteArray);
        this.hasMarker = (data[1] & 0xFFFFFF80) == -128;
    }

    public int getProfile() {
        return this.profile;
    }

    public byte[] getExtension() {
        return this.extension;
    }

    public boolean isHasExtension() {
        return this.hasExtension;
    }

    public int getExtensionLength() {
        return this.extensionLength;
    }

    public boolean isHasMarker() {
        return this.hasMarker;
    }

    public String getSsrc() {
        return this.ssrc;
    }

    public long getTimestamp() {
        return this.timestamp;
    }
}

