/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared.videosource;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.device.shared.VideoSrv;
import de.seetec.v5.re.cm.device.shared.videoprofile.VideoProfileHandler;
import de.seetec.v5.re.cm.device.shared.videosource.PlaybackVideoSourceClient;
import de.seetec.v5.re.cm.device.video.axis.videosource.AxisPlaybackVideoSourceClient;
import de.seetec.v5.re.cm.device.video.bosch.BoschPlaybackVideoSourceClient;
import de.seetec.v5.re.cm.device.video.hikvision.HikvisionPlaybackVideoSourceClient;
import de.seetec.v5.re.cm.device.video.onvif.generic.GenericOnvifPlaybackVideoSourceClient;
import de.seetec.v5.re.cm.device.video.samsung.SamsungPlaybackVideoSourceClient;
import de.seetec.v5.re.shared.EdgeStorageParameter;
import de.seetec.v5.shared.util.SeeTecException;

public final class PlaybackVideoSourceClientFactory {
    public static PlaybackVideoSourceClient createPlaybackVideoSourceClient(long srvEntityType, EdgeStorageParameter edgeStorageParameter, Core core, VideoSrv videoSrv, VideoProfileHandler videoProfileHandler, boolean manualTrigger) throws SeeTecException {
        PlaybackVideoSourceClient playbackVideoSourceClient = PlaybackVideoSourceClientFactory.createPlaybackVideoSourceClient(srvEntityType);
        playbackVideoSourceClient.setManualTrigger(manualTrigger);
        playbackVideoSourceClient.setEdgeStorageParameter(edgeStorageParameter);
        int errorCode = playbackVideoSourceClient.init(core, videoSrv, videoProfileHandler);
        if (errorCode != 0) {
            throw new SeeTecException(errorCode, "PlaybackVideoSourceClient could not be initialized for " + srvEntityType);
        }
        return playbackVideoSourceClient;
    }

    protected static PlaybackVideoSourceClient createPlaybackVideoSourceClient(long srvEntityType) throws SeeTecException {
        PlaybackVideoSourceClient playbackVideoSourceClient;
        if (srvEntityType / 100L == 2117L) {
            playbackVideoSourceClient = new BoschPlaybackVideoSourceClient();
        } else if (srvEntityType / 100L == 2118L || srvEntityType / 100L == 2164L || srvEntityType / 100L == 2168L) {
            playbackVideoSourceClient = new SamsungPlaybackVideoSourceClient();
        } else if (srvEntityType / 100L == 2100L || srvEntityType / 100L == 2123L) {
            playbackVideoSourceClient = new AxisPlaybackVideoSourceClient();
        } else if (srvEntityType / 100L == 2196L || srvEntityType / 100L == 2165L || srvEntityType / 100L == 2155L || srvEntityType / 100L == 2142L || srvEntityType / 100L == 2166L) {
            playbackVideoSourceClient = new GenericOnvifPlaybackVideoSourceClient();
        } else if (srvEntityType / 100L == 2104L || srvEntityType / 100L == 2144L || srvEntityType / 100L == 2159L || srvEntityType / 100L == 2160L || srvEntityType / 100L == 2161L || srvEntityType == 212706L || srvEntityType == 214190L || srvEntityType / 100L == 2163L || srvEntityType / 100L == 2167L) {
            playbackVideoSourceClient = new HikvisionPlaybackVideoSourceClient();
        } else {
            throw new SeeTecException(-21601, "EntityType could not be matched for PlaybackVideoSourceClient: " + srvEntityType);
        }
        return playbackVideoSourceClient;
    }
}

