/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared.videosource;

import de.seetec.v5.re.cm.device.shared.net.rtcp.RTCPHandlerIntf;
import de.seetec.v5.re.cm.device.shared.net.rtcp.RTCPParser;
import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPStreamSettings;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingVideoSourceClientRTSP;
import de.seetec.v5.re.cm.device.shared.videosource.UseSimpleRelativeRTPTimestampForPlayback;
import de.seetec.v5.re.cm.shared.timerange.TimeRange;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.re.shared.EdgeStorageMode;
import de.seetec.v5.re.shared.EdgeStorageParameter;
import de.seetec.v5.re.shared.TransmissionType;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;

public abstract class PlaybackVideoSourceClient
extends StreamingVideoSourceClientRTSP
implements RTCPHandlerIntf {
    public static final String CLASS_NAME = "de.seetec.v5.re.cm.device.shared.PlaybackVideoSourceClient";
    private List<TimeRange> rangesToFill;
    private Long timeDifference;
    private boolean executeOperationAfterSetupFlag = false;
    private boolean executeOperationAfterPlayFlag = false;
    private boolean startAllTrackIds = false;
    private Double rtspPlaybackSpeed = null;
    private String frameParameter = "";
    private Codec playbackCodec = null;
    private TransmissionType playbackTransmissionID = null;
    private boolean executeOperationAfterDescribeFlag = false;
    private boolean firstPacketReceived = false;
    private EdgeStorageMode edgeStorageMode = EdgeStorageMode.DISABLED;
    private final Object PLAYBACK_VIEDOSOURCE_CLIENT_SEMAPHORE = new Object();
    private Long startTime = null;
    private Long endTime = null;
    private Long lastPacketReceived = null;
    private RTCPParser rtcpParser;
    private boolean manualTrigger = false;

    public List<TimeRange> getRangesToFill() {
        return this.rangesToFill;
    }

    public void setRangesToFill(List<TimeRange> rangesToFill) {
        this.rangesToFill = rangesToFill;
    }

    public Long getTimeDifference() {
        return this.timeDifference;
    }

    public void setTimeDifference(Long timeDifference) {
        this.timeDifference = timeDifference;
    }

    public void setExecuteOperationAfterSetupFlag(boolean executeOperationAfterSetupFlag) {
        this.executeOperationAfterSetupFlag = executeOperationAfterSetupFlag;
    }

    public void setExecuteOperationAfterPlayFlag(boolean executeOperationAfterPlayFlag) {
        this.executeOperationAfterPlayFlag = executeOperationAfterPlayFlag;
    }

    public void setStartAllTrackIds(boolean startAllTrackIds) {
        this.startAllTrackIds = startAllTrackIds;
    }

    public void setRtspPlaybackSpeed(Double rtspPlaybackSpeed) {
        this.rtspPlaybackSpeed = rtspPlaybackSpeed;
    }

    public void setFrameParameter(String frameParameter) {
        this.frameParameter = frameParameter;
    }

    public Codec getPlaybackCodec() {
        return this.playbackCodec;
    }

    public void setPlaybackCodec(Codec playbackCodec) {
        this.playbackCodec = playbackCodec;
    }

    public void setPlaybackTransmissionID(TransmissionType playbackTransmissionID) {
        this.playbackTransmissionID = playbackTransmissionID;
    }

    @Override
    public int init() {
        this.isLocalStorageHandler = true;
        this.rtcpParser = new RTCPParser(this);
        try {
            this.edgeStorageMode = this.getVideoSrv().getVideoProfileHandler(null).getVideoSourceParameter().getEdgeStorageParameter().getEdgeStorageMode();
        }
        catch (ConfigurationException configurationException) {
            this.logger.error("Could not read EdgeStorageConfiguration for " + this, (Throwable)configurationException);
            return -21602;
        }
        return super.init();
    }

    @Override
    public final void processData(byte[] data) {
        if (!this.firstPacketReceived) {
            this.firstPacketReceived = true;
        }
        if (this.rtcpParser != null) {
            this.rtcpParser.parsePackage(data);
        }
        if (super.isStopPlaybackStream()) {
            this.lastPacketReceived = null;
            this.timestampCalculator.reset();
            this.stopRtspStreaming();
        } else {
            this.lastPacketReceived = System.currentTimeMillis();
            this.processRtpData(data);
        }
    }

    public static final long calculateTimeMillis(long millisSinceMidnight) {
        Calendar synchronizationTimeCalendar = Calendar.getInstance();
        synchronizationTimeCalendar.set(11, 0);
        synchronizationTimeCalendar.set(12, 0);
        synchronizationTimeCalendar.set(13, 0);
        synchronizationTimeCalendar.set(14, 0);
        return synchronizationTimeCalendar.getTimeInMillis() + millisSinceMidnight;
    }

    public void setManualTrigger(boolean manualTrigger) {
        this.manualTrigger = manualTrigger;
    }

    public boolean isManualTrigger() {
        return this.manualTrigger;
    }

    public final TimeRange fillGap(long startTimeStamp, long endTimeStamp, String nameOfTimerange) throws SeeTecException {
        this.logger.info("Check for filling gap between " + new Date(startTimeStamp) + " = " + startTimeStamp + " and " + new Date(endTimeStamp) + " = " + endTimeStamp + " for " + this);
        if (startTimeStamp >= endTimeStamp) {
            this.logger.warn("Cannot fill gap: Start = " + new Date(startTimeStamp) + " , End = " + new Date(endTimeStamp) + " for " + this);
            return null;
        }
        this.videoPlaybackStartingTime = startTimeStamp + 1L;
        ((UseSimpleRelativeRTPTimestampForPlayback)this.timestampCalculator).setPlaybackStartingTime(this.videoPlaybackStartingTime);
        this.endTimeStamp = endTimeStamp - 1L;
        this.setVideoPlaybackEndTime(this.endTimeStamp);
        this.logger.info("Check for filling (adapted) gap between " + new Date(this.videoPlaybackStartingTime) + " = " + this.videoPlaybackStartingTime + " and " + new Date(this.endTimeStamp) + " = " + this.endTimeStamp + " for " + this);
        this.listener.setIsFillingFromEdgeStorage(true);
        int tempErrorCode = this.startRtspStreaming(this.videoPlaybackStartingTime, this.endTimeStamp, nameOfTimerange);
        if (tempErrorCode != 0) {
            throw new SeeTecException(tempErrorCode, "Error [" + tempErrorCode + "] while starting RTSP Streaming for EdgeStorage for " + this);
        }
        long oneMinute = TimeUnit.SECONDS.toMillis(60L);
        while (!this.isStopPlaybackStream()) {
            if (this.lastPacketReceived != null && System.currentTimeMillis() > this.lastPacketReceived + oneMinute) {
                this.logger.warn("One minute without received data for " + this);
                break;
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.getTimeStampFirstFrame() == -1L || this.getTimeStampLastFrame() == Long.MAX_VALUE) {
            this.logger.warn("Error while filling gap for " + this);
            return null;
        }
        this.logger.info("Filled " + new Date(this.getTimeStampFirstFrame()) + " = " + this.getTimeStampFirstFrame() + " - " + new Date(this.getTimeStampLastFrame()) + " = " + this.getTimeStampLastFrame() + " for " + this);
        this.listener.setIsFillingFromEdgeStorage(false);
        this.stopRtspStreaming();
        return new TimeRange(this.getTimeStampFirstFrame(), this.getTimeStampLastFrame());
    }

    @Override
    public final void onNetworkError(int error) {
        this.logger.warn("Network error with error code: " + error + " for " + this);
        this.setStopPlaybackStream(true);
    }

    @Override
    public final void sendStatusService(int errorCode) {
        if (errorCode != 0) {
            this.logger.warn("Received error code: " + errorCode + " for " + this);
            this.setStopPlaybackStream(true);
        }
    }

    public final void setTimeRangeToSynchronize(Long startTime, Long endTime) {
        this.startTime = startTime;
        this.endTime = endTime;
    }

    public final EdgeStorageMode getEdgeStorageMode() {
        return this.edgeStorageMode;
    }

    public Long getStartTime() {
        return this.startTime;
    }

    public Long getEndTime() {
        return this.endTime;
    }

    @Override
    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    @Override
    public final int shutdown() {
        this.logger.info("Shutdown local storage for " + this);
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        this.listener.setIsFillingFromEdgeStorage(false);
        this.setLocalStorageReady(false);
        this.setStopPlaybackStream(true);
        this.firstPacketReceived = false;
        this.timeDifference = null;
        this.startTime = null;
        this.endTime = null;
        this.setVideoPlaybackEndTime(-1L);
        this.timestampCalculator.reset();
        return super.shutdown();
    }

    public EdgeStorageParameter getEdgeStorageParameter() {
        return this.edgeStorageParameter;
    }

    @Override
    public void RTCPReceiverReportReceived() {
    }

    @Override
    public void RTCPSenderReportReceived() {
    }

    @Override
    public void RTCPSDESReceived() {
    }

    @Override
    public void RTCPBYEReceived() {
        this.setStopPlaybackStream(true);
    }

    public int hashCode() {
        int hash = 5;
        hash = 29 * hash + (this.rangesToFill != null ? this.rangesToFill.hashCode() : 0);
        hash = 29 * hash + (this.videoSrv != null ? this.videoSrv.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PlaybackVideoSourceClient other = (PlaybackVideoSourceClient)obj;
        if (!(this.rangesToFill == other.rangesToFill || this.rangesToFill != null && this.rangesToFill.equals(other.rangesToFill))) {
            return false;
        }
        return this.videoSrv == other.videoSrv || this.videoSrv != null && this.videoSrv.equals(other.videoSrv);
    }

    public List<TimeRange> getRecordingInfosFromDevice(long startTimestamp, long endTimestamp) {
        return this.getVideoSrv().getDevice().getRecordingInfosFromDevice(startTimestamp, endTimestamp, this.getVideoSourceNr());
    }

    protected final int startRtspStreaming(long startTimeStamp, long endTimeStamp, String nameOfTimerange) {
        int tempErrorCode;
        this.setStopPlaybackStream(false);
        int track = (int)this.edgeStorageParameter.getTrack();
        super.getLocalStorageWriter().shutdown();
        super.getLocalStorageWriter().setupLocalStorage(track);
        this.firstDeliver = true;
        this.timestampCalculator.reset();
        if (this.rtspHandler != null) {
            this.rtspHandler.shutdown();
        }
        try {
            this.rtspSettings = new RTSPStreamSettings();
            this.rtspUrl = this.getRtspUrl(startTimeStamp, endTimeStamp, nameOfTimerange);
            int rtspPort = -1;
            try {
                rtspPort = this.rtspSettings.getRtspPortFromUrl(this.rtspUrl);
            }
            catch (Exception ex) {
                this.logger.info("Exception while extracting port number from url for " + this + ". Will not use Port number from RTSP Url");
            }
            if (rtspPort == -1) {
                rtspPort = this.listener.getVideoSourceParameter().getRtspPort();
            }
            this.errorCode = this.rtspSettings.init(this, this.audioSourceClient, this.networkParameter, rtspPort, this.rtspUrl, this.printDebug, this.transmissionID, this.networkParameter.getSoTimeout(), this.isAudioEnabled, 3, this.rtspUrl);
            this.rtspSettings.disableBasicAuthentication();
            String requireField = this.getRequireField();
            if (requireField != null && !requireField.isEmpty()) {
                this.rtspSettings.setRequireField(requireField);
            }
            if (!this.frameParameter.isEmpty()) {
                this.rtspSettings.setFrames(this.frameParameter);
            }
            if (this.errorCode != 0) {
                this.logger.error("Error while setting RTSP parameters for EdgeStorage for " + this.getVideoSrv());
                return this.errorCode;
            }
            String timeRange = this.getTimeRange(startTimeStamp, endTimeStamp, nameOfTimerange);
            if (timeRange == null) {
                this.logger.error("TimeRange needed for EdgeStorage RTSP Playback but not available here for " + this);
                return -21601;
            }
            if (!timeRange.isEmpty()) {
                this.rtspSettings.setRange(timeRange);
            }
            this.rtspSettings.setIsEdgeStoragePlayback(true);
            Codec recordingCodec = this.getRecordingCodec();
            if (recordingCodec != null) {
                this.rtspSettings.setCodec(recordingCodec);
            }
            if (this.playbackTransmissionID != null) {
                this.rtspSettings.setTransmissionID(this.playbackTransmissionID);
            }
            this.rtspSettings.setPlaybackCodec(this.playbackCodec);
            this.rtspSettings.arrangeFurtherOperations(this.executeOperationAfterDescribeFlag, this.executeOperationAfterSetupFlag, this.executeOperationAfterPlayFlag);
            this.rtspSettings.setScale(this.rtspPlaybackSpeed);
            this.rtspSettings.setStartAllTrackIds(this.startAllTrackIds);
        }
        catch (Throwable throwable) {
            this.logger.error("Error while first RTSP request. errorCode: " + this.errorCode + " for " + this.getVideoSrv(), throwable);
            return this.errorCode;
        }
        try {
            this.rtspHandler = this.rtspSettings.getRTSPHandler();
            tempErrorCode = this.rtspHandler.start();
        }
        catch (SeeTecException seeTecException) {
            this.logger.error("Error while starting RTSP streaming for " + this);
            tempErrorCode = seeTecException.getErrorCode();
        }
        this.rtspPlaybackSpeed = this.rtspSettings.getScale();
        ((UseSimpleRelativeRTPTimestampForPlayback)this.timestampCalculator).setScale(this.rtspPlaybackSpeed == null ? 1.0 : this.rtspPlaybackSpeed);
        if (tempErrorCode != 0) {
            this.logger.error("Error while starting RTSP streaming (replay) for " + this.getVideoSrv());
        }
        this.firstPacketReceived = false;
        long streamingStartTime = System.currentTimeMillis();
        if (tempErrorCode != -2147483647) {
            while (!this.firstPacketReceived) {
                try {
                    Thread.sleep(50L);
                    if (System.currentTimeMillis() <= streamingStartTime + TimeUnit.SECONDS.toMillis(10L)) continue;
                    this.logger.error("No packets received after starting RTSP/Streaming for " + this);
                    tempErrorCode = -20008;
                    break;
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
        return tempErrorCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void stopRtspStreaming() {
        Object object = this.PLAYBACK_VIEDOSOURCE_CLIENT_SEMAPHORE;
        synchronized (object) {
            if (this.rtspHandler != null) {
                this.logger.info("Stop local storage streaming for " + this);
                this.rtspHandler.shutdown();
                this.rtspHandler = null;
            }
            if (this.isLocalStorageReady()) {
                try {
                    this.getLocalStorageWriter().finalizeCurrentSequence();
                }
                catch (Throwable throwable) {
                    this.logger.warn("Error finalizing sequence [" + throwable.getMessage() + "] for " + this);
                }
            }
        }
    }

    protected double calculatePlaybackSpeed(double realTimeValue) {
        try {
            double edgeStorageSpeed = this.getCore().getDmCnfMgr().getEdgeStorageSpeed();
            if (edgeStorageSpeed < 1.0) {
                edgeStorageSpeed = 1.0;
            } else if (edgeStorageSpeed > this.getMaxPlaybackSpeed()) {
                edgeStorageSpeed = this.getMaxPlaybackSpeed();
            }
            return realTimeValue * edgeStorageSpeed;
        }
        catch (ConfigurationException configurationException) {
            return realTimeValue;
        }
    }

    protected Codec getRecordingCodec() {
        return null;
    }

    public double getRtspPlaybackSpeed() {
        return this.rtspPlaybackSpeed;
    }

    protected abstract Long getTimeDifferenceFromDevice() throws Exception;

    protected abstract double getMaxPlaybackSpeed();

    protected abstract String getRtspUrl(long var1, long var3, String var5) throws ConfigurationException;

    protected abstract String getTimeRange(long var1, long var3, String var5);

    protected abstract String getRequireField();
}

