/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared.videosource;

public enum NALUnitPayloadStructureH265 {
    TRAIL(new byte[]{0, 1}),
    TSA(new byte[]{2, 3}),
    STSA(new byte[]{4}),
    RADL(new byte[]{6, 7}),
    RASL(new byte[]{8, 9}),
    BLA(new byte[]{16, 17, 18}),
    IDR(new byte[]{19, 20}),
    CRA(new byte[]{21}),
    VPS(new byte[]{32}),
    SPS(new byte[]{33}),
    PPS(new byte[]{34}),
    AUD(new byte[]{35}),
    EOS(new byte[]{36}),
    EOB(new byte[]{27}),
    FD(new byte[]{38}),
    SEI(new byte[]{39, 40}),
    AGGREGATED(new byte[]{48}),
    FU(new byte[]{49}),
    PACI(new byte[]{50}),
    RESERVED(new byte[]{10, 11, 12, 13, 14, 15, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 41, 42, 43, 44, 45, 46, 47}),
    UNDEFINED(new byte[]{51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63});

    private final byte[] NALUnitTypes;

    private NALUnitPayloadStructureH265(byte[] nalUnitTypes) {
        this.NALUnitTypes = nalUnitTypes;
    }

    public static NALUnitPayloadStructureH265 getNALUnitPayloadStructure(byte nalUnitTypeOctet) {
        nalUnitTypeOctet = (byte)(nalUnitTypeOctet >> 1 & 0x3F);
        for (NALUnitPayloadStructureH265 payloadStructure : NALUnitPayloadStructureH265.values()) {
            if (payloadStructure.getNALUnitTypesOfPayloadStructure() == null) continue;
            for (byte NALUnitType : payloadStructure.getNALUnitTypesOfPayloadStructure()) {
                if (NALUnitType != nalUnitTypeOctet) continue;
                return payloadStructure;
            }
        }
        return UNDEFINED;
    }

    private byte[] getNALUnitTypesOfPayloadStructure() {
        return this.NALUnitTypes;
    }
}

