/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared.videosource;

import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushContent;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingHelper;
import de.seetec.v5.re.cm.device.shared.videosource.VideoSourceClient;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.re.shared.MediaFrame;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.EventType;
import de.seetec.v5.shared.SSLConstantsIntf;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.BindException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.net.UnknownHostException;

public abstract class JPEGVideoSourceClient
extends VideoSourceClient
implements Runnable {
    private static final String CLASS = "de.seetec.v5.re.cm.device.shared.JPEGVideoSourceClient";
    protected Thread myThread = null;
    protected Socket serverPushSocket = null;
    protected long highestFramerate = -1L;

    public void deliverContent(HttpServerPushContent httpServerPushContent) {
        byte[] contentData = httpServerPushContent.getContentBody();
        if (contentData.length > 0) {
            this.deliverContent(contentData);
        }
    }

    public void deliverContent(byte[] contentData) {
        try {
            MediaFrame mediaFrame = StreamingHelper.createSeeTecVideoFrameHeader(Codec.MJPEG, contentData, false);
            this.deliverFrameCreateServerTimestamp(0, mediaFrame);
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while creating video frame for " + this + " : " + ex.getMessage());
        }
    }

    protected int init(boolean startThread) {
        int errorCode = super.init();
        if (errorCode != 0) {
            this.logger.error("Error while initializing. Code: " + errorCode + " for " + this);
            return errorCode;
        }
        if (this.listener == null) {
            return -21601;
        }
        this.highestFramerate = this.listener.getHighestFramerate();
        if (this.highestFramerate < 0L) {
            this.logger.error("Framerate [" + this.highestFramerate + "] is not valid");
            return -21601;
        }
        if (startThread) {
            this.myThread = new Thread((Runnable)this, this.toString());
            this.myThread.start();
        }
        return 0;
    }

    @Override
    protected int init() {
        return this.init(true);
    }

    @Override
    public final boolean isShutdown() {
        return this.isShutdown(CLASS);
    }

    protected abstract boolean isRunFinished();

    public int shutdown() {
        if (this.startShutdown(CLASS)) {
            return 0;
        }
        if (this.myThread != null) {
            long timeout = System.currentTimeMillis() + 30000L;
            while (!this.isRunFinished()) {
                if (System.currentTimeMillis() > timeout) {
                    this.logger.warn("Thread of " + this + " didn't finished in time");
                    break;
                }
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.myThread = null;
        }
        try {
            if (this.serverPushSocket != null) {
                this.logger.warn("ATTENTION: " + this.serverPushSocket + " has not been discarded by the thread, so discarding now ...");
                this.serverPushSocket.close();
                this.serverPushSocket = null;
            }
        }
        catch (Throwable ex) {
            this.logger.warn(ex.getMessage());
        }
        return 0;
    }

    protected final void readSingleImages(String url) throws IOException {
        byte[] contentHeader = new byte[4096];
        Socket socket = null;
        InputStream is = null;
        byte[] doubleLineDelimitter = SSLConstantsIntf.DOUBLE_CRLF_BYTE;
        long tsLastContentRead = System.currentTimeMillis();
        block8: while (true) {
            try {
                while (!this.isShutdown()) {
                    char c;
                    int endPos;
                    int len;
                    long loopTime = 1000000L / this.highestFramerate;
                    long tsStart = System.currentTimeMillis();
                    socket = this.establishStream(url);
                    if (socket == null) break block8;
                    is = socket.getInputStream();
                    int index = 0;
                    while ((len = is.read(contentHeader, index, contentHeader.length - index)) > 0 && (index += len) <= 1024) {
                    }
                    int read = index;
                    if (read <= 0) {
                        this.logger.info("No valid content header for " + this);
                        break block8;
                    }
                    int headerLength = Basic.indexOfByteArray((byte[])contentHeader, (byte[])doubleLineDelimitter, (int)0);
                    if (headerLength < 0) {
                        this.logger.error("Invalid header for " + this);
                        break block8;
                    }
                    String contentHeaderString = new String(contentHeader, 0, headerLength - 4).toLowerCase();
                    if (!contentHeaderString.contains("image/jpeg")) {
                        this.logger.error("Header [" + contentHeaderString + "] is not valid for " + this);
                        break block8;
                    }
                    String key = "content-length: ";
                    index = contentHeaderString.toLowerCase().indexOf(key);
                    if (index < 0) {
                        this.logger.error("No content length found in header [" + contentHeaderString);
                        break block8;
                    }
                    index += key.length();
                    while (contentHeaderString.charAt(index) == ' ') {
                        ++index;
                    }
                    for (endPos = index; endPos < contentHeaderString.length() && (c = contentHeaderString.charAt(endPos)) >= '0' && c <= '9'; ++endPos) {
                    }
                    int contentLength = Integer.parseInt(contentHeaderString.substring(index, endPos));
                    byte[] contentBody = new byte[contentLength];
                    System.arraycopy(contentHeader, headerLength, contentBody, 0, index);
                    for (index = read - headerLength; index < contentBody.length && (len = is.read(contentBody, index, contentBody.length - index)) > 0; index += len) {
                    }
                    if (index < contentBody.length) {
                        this.logger.error("Stream terminated during reading image for " + this);
                        break block8;
                    }
                    if (this.logger.isDebugEnabled()) {
                        this.logger.info("... " + this + " delivers content of [" + Basic.longToFormattedString((long)contentBody.length) + " b] to listener [" + this.listener + "] ...");
                    }
                    this.deliverContent(contentBody);
                    is.close();
                    is = null;
                    socket.close();
                    socket = null;
                    long duration = System.currentTimeMillis() - tsLastContentRead;
                    if (duration > 60000L) {
                        this.logger.warn("Content read within [" + Basic.longToFormattedString((long)duration) + " ms] via " + this);
                    }
                    tsLastContentRead = System.currentTimeMillis();
                    duration = System.currentTimeMillis() - tsStart;
                    long sleepTime = loopTime - duration;
                    if (sleepTime <= 0L) continue;
                    try {
                        Thread.sleep(sleepTime);
                        continue block8;
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
                break;
            }
            catch (Throwable ex) {
                this.logger.error((Object)ex, ex);
                break;
            }
        }
        try {
            if (is != null) {
                is.close();
            }
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
        }
        try {
            if (socket != null) {
                socket.close();
            }
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
        }
    }

    protected Socket establishStream(String url) {
        int statusCode;
        String request = null;
        Socket socket = null;
        try {
            if (this.networkParameter.useHTTPS()) {
                socket = NetworkHelper.establishServerPushStream((NetworkParameter)this.networkParameter, (String[])this.networkParameter.getUserPWD(), (String)url);
            } else {
                String authorization = NetworkHelper.createBasicAuthorization((NetworkParameter)this.networkParameter);
                authorization = authorization == null ? "" : authorization;
                request = "GET " + url + " HTTP/1.1\r\n" + authorization + "User-Agent: Java/1.4.2\r\nHost: " + this.host + "\r\nAccept: text/html, image/gif, image/jpeg, *; q=.2, */*; q=.2\r\nConnection: keep-alive\r\n\r\n";
                if (this.logger.isDebugEnabled()) {
                    this.logger.info("Request=[\r\n" + request + "]");
                }
                socket = new Socket(this.host, this.port);
                socket.setSoTimeout(5000);
                OutputStream os = socket.getOutputStream();
                os.write(request.getBytes());
                os.flush();
            }
            this.getVideoSrv().getDevice().sendResolvedConnectionEvent(this.getVideoSrv().getEntityID());
            return socket;
        }
        catch (ConnectException ex) {
            this.logger.error("ConnectException: " + ex.getMessage());
            statusCode = -21656;
        }
        catch (UnknownHostException ex) {
            this.logger.error("UnknownHostException: " + ex.getMessage());
            statusCode = -21656;
        }
        catch (NoRouteToHostException ex) {
            this.logger.error("NoRouteToHostException: " + ex.getMessage());
            statusCode = -21656;
        }
        catch (BindException ex) {
            this.logger.error("Cannot get socket to [" + this.host + ":" + this.port + "]: " + ex.getMessage());
            statusCode = -21656;
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            statusCode = -21652;
        }
        try {
            if (socket != null) {
                socket.close();
            }
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
        }
        this.listener.sendStatusService(statusCode);
        String entityName = null;
        String localHostAddress = null;
        try {
            localHostAddress = this.getVideoSrv().getCore().getDmCnfMgr().getServerAddress();
            if (this.getVideoSrv() != null) {
                entityName = this.getVideoSrv().getEntityName();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (System.currentTimeMillis() > this.lastCannotCreateDeviceEventSent + 5000L) {
            this.lastCannotCreateDeviceEventSent = System.currentTimeMillis();
            this.core.sendErrorEvent(EventType.CM_EVENTTYPE_DEVICE_CONNECTIVITY_PROBLEM, this.getVideoSrv().getEntityID());
            this.core.sendLoggingEvent(EventType.CM_EVENTTYPE_DEVICE_CONNECTIVITY_PROBLEM, this.getVideoSrv().getEntityID(), statusCode, "Cannot establish stream for [" + entityName + "]", "Cannot establish stream for [" + entityName + "] from [" + localHostAddress + "].");
        }
        return null;
    }

    public long getFramerate() {
        return this.highestFramerate;
    }

    public final String toString() {
        String sThis = "de.seetec.v5.re.cm.device.shared.JPEGVideoSourceClient@" + Integer.toHexString(this.hashCode());
        return "[" + sThis.substring(sThis.lastIndexOf(46) + 1) + ", Socket=[" + this.host + ":" + this.port + "], Framerate=[" + this.highestFramerate / 1000L + "." + this.highestFramerate % 1000L + "]]";
    }
}

