/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared.videoprofile;

import de.seetec.v5.shared.Basic;

class RtpHeader {
    public static final int SIZE = 12;
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.shared.RTPheader";
    private byte version = 0;
    private byte padding = 0;
    private byte extension = 0;
    private int countCSRC = -1;
    private byte marker = 0;
    private byte payloadType = 0;
    private int sequenceNumber = -1;
    private int timestamp = -1;
    private int syncSrcID = -1;

    RtpHeader(byte version, byte padding, byte extension, int countCSRC, byte marker, byte payloadType, int sequenceNumber, int timestamp, int syncSrcID) {
        this.version = version;
        this.padding = padding;
        this.extension = extension;
        this.countCSRC = countCSRC;
        this.marker = marker;
        this.payloadType = payloadType;
        this.sequenceNumber = sequenceNumber;
        this.timestamp = timestamp;
        this.syncSrcID = syncSrcID;
    }

    public byte[] getBytes() {
        byte[] header = new byte[12];
        header[0] = (byte)(header[0] | (this.version & 3) << 6);
        header[0] = (byte)(header[0] | (this.padding & 1) << 5);
        header[0] = (byte)(header[0] | (this.extension & 1) << 4);
        header[0] = (byte)(header[0] | this.countCSRC & 0xF);
        header[1] = (byte)(header[1] | (this.marker & 1) << 7);
        header[1] = (byte)(header[1] | this.payloadType & 0x7F);
        header[2] = (byte)(this.sequenceNumber >> 8 & 0xFF);
        header[3] = (byte)(this.sequenceNumber & 0xFF);
        header[4] = (byte)(this.timestamp >> 24 & 0xFF);
        header[5] = (byte)(this.timestamp >> 16 & 0xFF);
        header[6] = (byte)(this.timestamp >> 8 & 0xFF);
        header[7] = (byte)(this.timestamp & 0xFF);
        header[8] = (byte)(this.syncSrcID >> 24 & 0xFF);
        header[9] = (byte)(this.syncSrcID >> 16 & 0xFF);
        header[10] = (byte)(this.syncSrcID >> 8 & 0xFF);
        header[11] = (byte)(this.syncSrcID & 0xFF);
        return header;
    }

    public String toString() {
        String sThis = "de.seetec.v5.re.cm.shared.RTPheader@" + Integer.toHexString(this.hashCode());
        String sVersion = (this.version & 3) + "";
        String sPadding = "" + (this.padding & 1);
        String sExtension = "" + (this.extension & 1);
        String sCountCSRC = Basic.longToFormattedString((long)(this.countCSRC & 0xF));
        String sPayloadType = "" + (this.payloadType & 0x7F);
        String sSequenceNumber = Basic.longToFormattedString((long)this.sequenceNumber);
        String sTimestamp = Basic.longToFormattedString((long)this.timestamp);
        return "[" + sThis.substring(sThis.lastIndexOf(46) + 1) + ", Version=[" + sVersion + "], Padding=[" + sPadding + "], Extension=[" + sExtension + "], CountCSRC=[" + sCountCSRC + "], PayloadType=[" + sPayloadType + "], SequenceNumber=[" + sSequenceNumber + "], Timestamp=[" + sTimestamp + "]]";
    }
}

