/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared.videoprofile;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.device.shared.videoprofile.RtpGenerator;
import de.seetec.v5.re.shared.ContentFrame;
import de.seetec.v5.shared.Basic;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MulticastGateway {
    private static final int SEETEC_HEADER_SIZE = 26;
    private Logger logger = null;
    private String multicastHost = null;
    private int multicastPort = -1;
    private int multicastTtl = -1;
    private InetAddress multicastHostAdress = null;
    private MulticastSocket multicastSocket = null;
    private DatagramPacket datagramPacket = null;
    private byte[] udpPacket = null;
    private int udpDataSize = 0;
    private int cfCounter = -1;
    private final RtpGenerator rtpGenerator = new RtpGenerator();
    private int rtpTimestamp = (int)System.currentTimeMillis() & 0xFFFFFFF;
    private long entityID = -1L;
    private final Core core;

    protected MulticastGateway(Core core, long entityID, String multicastHost, int multicastPort, int ttl) throws IllegalArgumentException {
        this.logger = LogManager.getLogger((String)this.getClass().getName());
        this.core = core;
        this.checkEntityId(entityID);
        this.checkMulticastHost(multicastHost);
        this.checkMulticastPort(multicastPort);
        this.checkTtl(ttl);
        this.evaluateUdpPacketSize();
        this.udpDataSize = this.udpPacket.length - 26 - 12;
        this.multicastHost = multicastHost;
        this.multicastPort = multicastPort;
        this.multicastTtl = ttl;
        try {
            this.multicastHostAdress = InetAddress.getByName(this.multicastHost);
            this.multicastSocket = new MulticastSocket(this.multicastPort + 1);
            this.multicastSocket.setTimeToLive(this.multicastTtl);
            this.logger.info("Using MulticastHost [" + this.multicastHostAdress + "] and MulticastSocket " + this.multicastSocket + " with TTL=[" + this.multicastTtl + "] for " + this);
        }
        catch (IOException ioex) {
            this.logger.error("Using MulticastHost [" + this.multicastHostAdress + "] and MulticastSocket " + this.multicastSocket + " with TTL=[" + this.multicastTtl + "] FAILED for " + this);
        }
        this.datagramPacket = new DatagramPacket(this.udpPacket, this.udpPacket.length, this.multicastHostAdress, this.multicastPort);
    }

    private void evaluateUdpPacketSize() {
        this.udpPacket = new byte[7392];
        try {
            if (this.core.getConfigurationProvider().getDMConfigurationFromFile().getUdpPacketSize() > 0) {
                this.udpPacket = new byte[this.core.getConfigurationProvider().getDMConfigurationFromFile().getUdpPacketSize()];
                this.logger.info("Custom UDP packet size '" + this.udpPacket.length + "' set.");
            }
        }
        catch (Exception e) {
            this.logger.debug("No custom UDP packet size set.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sendContentFrame(ContentFrame contentFrame) throws IOException {
        byte[] transmissionFrame = contentFrame.createTransmissionFrame();
        this.core.deviceManagerStatistic.incrementClientFrames();
        ++this.cfCounter;
        DatagramPacket datagramPacket = this.datagramPacket;
        synchronized (datagramPacket) {
            long tsTransmissionStart = System.currentTimeMillis();
            this.rtpTimestamp += 2048;
            for (int i = 0; i < transmissionFrame.length; i += this.udpDataSize) {
                byte[] nextUdpPacket = i + this.udpDataSize < transmissionFrame.length ? this.udpPacket : new byte[transmissionFrame.length - i + 26 + 12];
                boolean stillFollowingFrames = i + this.udpDataSize < transmissionFrame.length;
                byte[] rtpHeader = this.rtpGenerator.createRTPheader(stillFollowingFrames, this.rtpTimestamp).getBytes();
                System.arraycopy(rtpHeader, 0, nextUdpPacket, 0, rtpHeader.length);
                Basic.int4ToByteArray((int)1592257553, (byte[])nextUdpPacket, (int)12, (int)4);
                Basic.int8ToByteArray((long)this.entityID, (byte[])nextUdpPacket, (int)16, (int)8);
                Basic.int4ToByteArray((int)0, (byte[])nextUdpPacket, (int)24, (int)2);
                Basic.int8ToByteArray((long)this.cfCounter, (byte[])nextUdpPacket, (int)26, (int)4);
                Basic.int4ToByteArray((int)transmissionFrame.length, (byte[])nextUdpPacket, (int)30, (int)4);
                Basic.int4ToByteArray((int)i, (byte[])nextUdpPacket, (int)34, (int)4);
                int completeHeaderSize = 38;
                System.arraycopy(transmissionFrame, i, nextUdpPacket, completeHeaderSize, nextUdpPacket.length - completeHeaderSize);
                this.datagramPacket.setData(nextUdpPacket);
                this.datagramPacket.setLength(nextUdpPacket.length);
                this.multicastSocket.send(this.datagramPacket);
            }
            long transmissionTime = System.currentTimeMillis() - tsTransmissionStart;
            if (transmissionTime > 999L) {
                this.logger.info("TransmissionTime for [" + Basic.longToFormattedString((long)transmissionFrame.length) + " B]=[" + Basic.longToFormattedString((long)transmissionTime) + " ms], this=" + this);
            }
        }
        return transmissionFrame.length;
    }

    public String toString() {
        String sThis = MulticastGateway.class.getName() + "@" + Integer.toHexString(this.hashCode());
        return "[" + sThis.substring(sThis.lastIndexOf(46) + 1) + ", EntityID=[" + this.entityID + "], Multicast=[" + this.multicastHost + ":" + this.multicastPort + "], UDP packet size=[" + this.udpPacket.length + "], TTL=[" + this.multicastTtl + "]]";
    }

    private void checkTtl(int ttl) throws IllegalArgumentException {
        if (ttl < 0 || ttl > 255) {
            throw new IllegalArgumentException("TTL [" + ttl + "] not suitable for " + this);
        }
    }

    private void checkMulticastPort(int multicastPort1) throws IllegalArgumentException {
        if (multicastPort1 <= 0 || multicastPort1 >= 65535) {
            throw new IllegalArgumentException("Port [" + multicastPort1 + "] not suitable for " + this);
        }
    }

    private void checkMulticastHost(String multicastHost1) throws IllegalArgumentException {
        if (multicastHost1 == null || multicastHost1.trim().length() <= 0) {
            throw new IllegalArgumentException("MulticastHost [" + multicastHost1 + "] not suitable for " + this);
        }
    }

    private void checkEntityId(long entityID1) throws IllegalArgumentException {
        this.entityID = entityID1;
        if (this.entityID < 0L) {
            throw new IllegalArgumentException("EntityID [" + entityID1 + "] not valid");
        }
    }
}

