/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared.onvif.services;

import de.seetec.v5.re.cm.device.shared.onvif.OnvifDevice;
import de.seetec.v5.re.cm.device.shared.onvif.OnvifService;
import de.seetec.v5.re.cm.device.shared.onvif.enums.PTZMode;
import de.seetec.v5.re.cm.shared.Tools;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.ws.Holder;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.onvif.ver10.schema.PTZPreset;
import org.onvif.ver10.schema.PTZSpeed;
import org.onvif.ver10.schema.PTZVector;
import org.onvif.ver10.schema.Vector1D;
import org.onvif.ver10.schema.Vector2D;
import org.onvif.ver20.ptz.wsdl.PTZ;

public final class PtzService
extends OnvifService {
    private final PTZ onvifPtzService;
    private final String ptzServiceAddress;
    private float previousPanSpeed = 0.0f;
    private float previousTiltSpeed = 0.0f;
    private float previousZoomSpeed = 0.0f;
    private boolean ptzCommandSent = false;
    private boolean isStopCommand = false;

    public PtzService(JaxWsProxyFactoryBean factory, OnvifDevice onvifDevice, String ptzServiceAddress) throws Exception {
        super(factory, onvifDevice);
        this.ptzServiceAddress = ptzServiceAddress;
        this.onvifPtzService = this.createService(PTZ.class, this.ptzServiceAddress);
    }

    public PTZ getOnvifPtzService() {
        return this.onvifPtzService;
    }

    public String getPtzServiceAddress() {
        return this.ptzServiceAddress;
    }

    public void sendAbsolutePtzCommand(String token, float pan, float tilt, float zoom) throws Exception {
        this.sendPtzCommand(token, PTZMode.ABSOLUTE, pan, tilt, zoom, 1.0f, 1.0f, 1.0f, false, null);
    }

    public void sendContinuousPtzCommand(String profileToken, Integer pan, Integer tilt, Integer zoom, int steps, long interval) throws Exception {
        this.sendContinuousPtzCommand(profileToken, pan, tilt, zoom, steps, interval, null);
    }

    public void sendContinuousPtzCommand(String profileToken, Integer pan, Integer tilt, Integer zoom, int steps, final long interval, String timeout) throws Exception {
        float speedX = pan == null ? this.previousPanSpeed / 100000.0f : (float)pan.intValue() / 100000.0f;
        speedX *= (float)steps;
        speedX = Tools.round(speedX);
        speedX /= (float)steps;
        float speedY = tilt == null ? this.previousTiltSpeed / 100000.0f : (float)tilt.intValue() / 100000.0f;
        speedY *= (float)steps;
        speedY = Tools.round(speedY);
        speedY /= (float)steps;
        float speedZ = zoom == null ? this.previousZoomSpeed / 100000.0f : (float)zoom.intValue() / 100000.0f;
        speedZ *= (float)steps;
        speedZ = Tools.round(speedZ);
        if (this.isInverted(speedX * 100000.0f, this.previousPanSpeed) || this.isInverted(speedY * 100000.0f, this.previousTiltSpeed) || this.isInverted((speedZ /= (float)steps) * 100000.0f, this.previousZoomSpeed)) {
            this.ptzCommandSent = false;
        }
        if (speedX == 0.0f && speedY == 0.0f && speedZ == 0.0f && !this.isStopCommand) {
            this.onvifPtzService.stop(profileToken, Boolean.valueOf(true), Boolean.valueOf(true));
            Thread.sleep(100L);
            this.onvifPtzService.stop(profileToken, Boolean.valueOf(true), Boolean.valueOf(true));
            this.previousPanSpeed = 0.0f;
            this.previousTiltSpeed = 0.0f;
            this.previousZoomSpeed = 0.0f;
            this.ptzCommandSent = false;
            this.isStopCommand = true;
        } else if (!this.ptzCommandSent) {
            long time2;
            long timeStep;
            long time1 = System.currentTimeMillis();
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().info("X: " + speedX * 100000.0f + " == " + this.previousPanSpeed);
                this.getLogger().info("Y: " + speedY * 100000.0f + " == " + this.previousTiltSpeed);
                this.getLogger().info("Z: " + speedZ * 100000.0f + " == " + this.previousZoomSpeed);
            }
            if (speedX * 100000.0f != this.previousPanSpeed || speedY * 100000.0f != this.previousTiltSpeed || speedZ * 100000.0f != this.previousZoomSpeed) {
                this.sendPtzCommand(profileToken, PTZMode.CONTINUOUS, 0.0f, 0.0f, 0.0f, speedX, speedY, speedZ, timeout != null, timeout);
                this.previousPanSpeed = (int)(speedX * 100000.0f);
                this.previousTiltSpeed = (int)(speedY * 100000.0f);
                this.previousZoomSpeed = (int)(speedZ * 100000.0f);
                this.ptzCommandSent = true;
                this.isStopCommand = false;
            }
            if ((timeStep = (time2 = System.currentTimeMillis()) - time1) < interval) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(interval - timeStep);
                            PtzService.this.ptzCommandSent = false;
                        }
                        catch (Exception exception) {
                            PtzService.this.getLogger().debug("Error while sleeping.");
                        }
                    }
                }, "ONVIF PTZ Service Waiting Thread for " + this.getOnvifDevice()).start();
            } else {
                this.ptzCommandSent = false;
            }
        }
    }

    private boolean isInverted(float x, float y) {
        return x * y < 0.0f;
    }

    public void sendPtzCommand(String profileToken, PTZMode ptzMode, float x, float y, float z, float speedX, float speedY, float speedZ, boolean useTimeout, String timeout) throws Exception {
        Vector2D moveVector2D = new Vector2D();
        moveVector2D.setX(x);
        moveVector2D.setY(y);
        Vector1D moveVector1D = new Vector1D();
        moveVector1D.setX(z);
        PTZVector location = new PTZVector();
        location.setPanTilt(moveVector2D);
        location.setZoom(moveVector1D);
        Vector2D speedVector2D = new Vector2D();
        speedVector2D.setX(speedX);
        speedVector2D.setY(speedY);
        Vector1D speedVector1D = new Vector1D();
        speedVector1D.setX(speedZ);
        PTZSpeed speed = new PTZSpeed();
        speed.setPanTilt(speedVector2D);
        speed.setZoom(speedVector1D);
        switch (ptzMode) {
            case ABSOLUTE: {
                this.onvifPtzService.absoluteMove(profileToken, location, speed);
                break;
            }
            case CONTINUOUS: {
                Duration duration = null;
                if (useTimeout) {
                    DatatypeFactory datatypeFactory = DatatypeFactory.newInstance();
                    duration = datatypeFactory.newDuration(timeout);
                }
                this.onvifPtzService.continuousMove(profileToken, speed, duration);
                break;
            }
            case RELATIVE: {
                this.onvifPtzService.relativeMove(profileToken, location, speed);
                break;
            }
        }
    }

    public String addPresetPosition(String presetName, String profileToken) {
        for (PTZPreset preset : this.onvifPtzService.getPresets(profileToken)) {
            try {
                if (!preset.getName().equals(presetName)) continue;
                this.onvifPtzService.removePreset(profileToken, preset.getToken());
                break;
            }
            catch (Exception exception) {
                this.getLogger().warn(exception.getMessage());
                this.getLogger().warn("existing preset deleted, because it was not set by SeeTec");
                this.onvifPtzService.removePreset(profileToken, preset.getToken());
            }
        }
        Holder presetToken = new Holder();
        this.onvifPtzService.setPreset(profileToken, presetName, presetToken);
        return (String)presetToken.value;
    }

    public void setPresetPosition(String presetName, String profileToken) {
        String token = null;
        for (PTZPreset preset : this.onvifPtzService.getPresets(profileToken)) {
            try {
                if (!preset.getName().equals(presetName)) continue;
                token = preset.getToken();
                break;
            }
            catch (NullPointerException exception) {
                this.getLogger().warn(exception.getMessage());
                this.getLogger().warn("preset name is noet set yet");
            }
        }
        this.onvifPtzService.gotoPreset(profileToken, token, null);
    }

    public void removePresetPosition(String presetName, String profileToken) {
        String token = null;
        for (PTZPreset preset : this.onvifPtzService.getPresets(profileToken)) {
            try {
                if (!preset.getName().equals(presetName)) continue;
                token = preset.getToken();
                break;
            }
            catch (NullPointerException exception) {
                this.getLogger().warn(exception.getMessage());
                this.getLogger().warn("preset name is not set yet");
            }
        }
        this.onvifPtzService.removePreset(profileToken, token);
    }
}

