/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared.onvif.services;

import de.seetec.v5.re.cm.device.shared.onvif.EventMessage;
import de.seetec.v5.re.cm.device.shared.onvif.EventMessageDescription;
import de.seetec.v5.re.cm.device.shared.onvif.OnvifDevice;
import de.seetec.v5.re.cm.device.shared.onvif.OnvifHelper;
import de.seetec.v5.re.cm.device.shared.onvif.OnvifService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.headers.Header;
import org.apache.cxf.jaxb.JAXBDataBinding;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.jdom.transform.JDOMResult;
import org.oasis_open.docs.wsn.b_2.NotificationMessageHolderType;
import org.oasis_open.docs.wsn.b_2.Renew;
import org.oasis_open.docs.wsn.b_2.TopicExpressionType;
import org.oasis_open.docs.wsn.b_2.UnableToDestroySubscriptionFaultType;
import org.oasis_open.docs.wsn.b_2.UnacceptableTerminationTimeFaultType;
import org.oasis_open.docs.wsn.bw_2.SubscriptionManager;
import org.oasis_open.docs.wsn.bw_2.UnableToDestroySubscriptionFault;
import org.oasis_open.docs.wsn.bw_2.UnacceptableTerminationTimeFault;
import org.oasis_open.docs.wsrf.r_2.ResourceUnknownFaultType;
import org.oasis_open.docs.wsrf.rw_2.ResourceUnknownFault;
import org.onvif.ver10.events.wsdl.CreatePullPointSubscription;
import org.onvif.ver10.events.wsdl.CreatePullPointSubscriptionResponse;
import org.onvif.ver10.events.wsdl.EventPortType;
import org.onvif.ver10.events.wsdl.GetEventProperties;
import org.onvif.ver10.events.wsdl.GetEventPropertiesResponse;
import org.onvif.ver10.events.wsdl.PullMessages;
import org.onvif.ver10.events.wsdl.PullMessagesFaultResponse_Exception;
import org.onvif.ver10.events.wsdl.PullMessagesResponse;
import org.onvif.ver10.events.wsdl.PullPointSubscription;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class EventService
extends OnvifService {
    private static final int TIMEOUTINSECONDS = 60;
    private static final String TIMEOUT = "PT60S";
    private static Duration timeOutSubscription;
    private final EventPortType onvifEventService;
    private final String eventServiceAddress;
    private PullPointSubscription pullPointSubscriptionService = null;
    private SubscriptionManager subscriptionManagerService = null;

    public EventService(JaxWsProxyFactoryBean factory, OnvifDevice onvifDevice, String eventServiceAddress) throws Exception {
        super(factory, onvifDevice);
        this.eventServiceAddress = eventServiceAddress;
        this.onvifEventService = this.createService(EventPortType.class, this.eventServiceAddress);
        timeOutSubscription = OnvifHelper.intToDuration(60);
    }

    public EventPortType getOnvifEventService() {
        return this.onvifEventService;
    }

    public String getEventServiceAddress() {
        return this.eventServiceAddress;
    }

    public List<EventMessage> pullMessages(Duration timeoutPullMessages, int messageLimit) throws PullMessagesFaultResponse_Exception, Exception {
        ArrayList<EventMessage> eventMessages = new ArrayList<EventMessage>();
        PullMessages pullMessages = new PullMessages();
        pullMessages.setTimeout(timeoutPullMessages);
        pullMessages.setMessageLimit(messageLimit);
        PullMessagesResponse pullMessagesResponse = this.getPullPointSubscriptionService().pullMessages(pullMessages);
        List notificationMessages = pullMessagesResponse.getNotificationMessage();
        this.renewSubscription(pullMessagesResponse, timeOutSubscription);
        for (NotificationMessageHolderType notificationMessage : notificationMessages) {
            List topicExpressionTypeContent;
            TopicExpressionType topicExpressionType = notificationMessage.getTopic();
            if (topicExpressionType == null || (topicExpressionTypeContent = topicExpressionType.getContent()) == null || topicExpressionTypeContent.size() <= 0) continue;
            String topic = (String)topicExpressionTypeContent.get(0);
            EventMessage eventMessageType = new EventMessage(topic, (Element)notificationMessage.getMessage().getAny());
            eventMessages.add(eventMessageType);
        }
        return eventMessages;
    }

    private void createSubscriptionServices() throws Exception {
        if (this.pullPointSubscriptionService == null || this.subscriptionManagerService == null) {
            CreatePullPointSubscription createPullPointSubscription = new CreatePullPointSubscription();
            createPullPointSubscription.setFilter(null);
            JAXBElement initialTerminationTime = new JAXBElement(new QName("http://www.onvif.org/ver10/events/wsdl", "InitialTerminationTime"), String.class, (Object)TIMEOUT);
            createPullPointSubscription.setInitialTerminationTime(initialTerminationTime);
            createPullPointSubscription.setSubscriptionPolicy(null);
            CreatePullPointSubscriptionResponse createPullPointSubscriptionResponse = this.getOnvifEventService().createPullPointSubscription(createPullPointSubscription);
            JDOMResult result = new JDOMResult();
            createPullPointSubscriptionResponse.getSubscriptionReference().writeTo((Result)result);
            org.jdom.Element root = result.getDocument().getRootElement();
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("SubscriptionReference: " + createPullPointSubscriptionResponse.getSubscriptionReference().toString());
            }
            String serviceAddress = null;
            ArrayList<Header> headers = new ArrayList<Header>();
            for (Object rootChild : root.getChildren()) {
                org.jdom.Element element = (org.jdom.Element)rootChild;
                if (element.getName().equalsIgnoreCase("Address")) {
                    Header toHeader = new Header(new QName(element.getNamespaceURI(), "To", "wsa5"), (Object)element.getText(), (DataBinding)new JAXBDataBinding(new Class[]{String.class}));
                    headers.add(toHeader);
                    serviceAddress = element.getText();
                    serviceAddress = OnvifHelper.changeIPAddressPortOfUrl(serviceAddress, this.getOnvifDevice().getIp(), this.getOnvifDevice().useHttps() ? this.getOnvifDevice().getSslPort() : this.getOnvifDevice().getPort(), this.getLogger());
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("SubscriptionReference->Address: " + toHeader);
                    }
                }
                if (!element.getName().equalsIgnoreCase("ReferenceParameters")) continue;
                for (Object child : element.getChildren()) {
                    org.jdom.Element subscriptionId = (org.jdom.Element)child;
                    if (!subscriptionId.getName().equalsIgnoreCase("SubscriptionId")) continue;
                    Header subscriptionIdHeader = new Header(new QName(subscriptionId.getNamespaceURI(), subscriptionId.getName(), subscriptionId.getNamespacePrefix()), (Object)subscriptionId.getText(), (DataBinding)new JAXBDataBinding(new Class[]{String.class}));
                    headers.add(subscriptionIdHeader);
                    if (!this.getLogger().isDebugEnabled()) continue;
                    this.getLogger().debug("SubscriptionReference->dom0: " + subscriptionId);
                }
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("CurrentTime: " + createPullPointSubscriptionResponse.getCurrentTime().toString());
                this.getLogger().debug("TerminationTime: " + createPullPointSubscriptionResponse.getTerminationTime().toString());
            }
            if (this.pullPointSubscriptionService == null) {
                this.pullPointSubscriptionService = this.createService(PullPointSubscription.class, serviceAddress, headers);
            }
            if (this.subscriptionManagerService == null) {
                this.subscriptionManagerService = this.createService(SubscriptionManager.class, serviceAddress, headers);
            }
        }
    }

    private PullPointSubscription getPullPointSubscriptionService() throws Exception {
        if (this.pullPointSubscriptionService == null) {
            this.createSubscriptionServices();
        }
        return this.pullPointSubscriptionService;
    }

    public void setSynchronizationPoint() {
        try {
            this.getPullPointSubscriptionService().setSynchronizationPoint();
        }
        catch (Exception exception) {
            this.getLogger().warn("Could not set synchronizaation point. Maybe there is a timeout?");
            this.pullPointSubscriptionService = null;
        }
    }

    private void unsubscribe() {
        try {
            this.subscriptionManagerService.unsubscribe(null);
        }
        catch (ResourceUnknownFault resourceUnknownFault) {
            ResourceUnknownFaultType resourceUnknownFaultType = resourceUnknownFault.getFaultInfo();
            this.getLogger().warn("ONVIF Fault : " + resourceUnknownFaultType.getFaultCause().toString() + " [" + this.getOnvifDevice().getIp() + "]");
        }
        catch (UnableToDestroySubscriptionFault unableToDestroySubscriptionFault) {
            UnableToDestroySubscriptionFaultType unableToDestroySubscriptionFaultType = unableToDestroySubscriptionFault.getFaultInfo();
            this.getLogger().warn("ONVIF Fault : " + unableToDestroySubscriptionFaultType.getFaultCause().toString() + " [" + this.getOnvifDevice().getIp() + "]");
        }
        catch (Exception exception) {
            this.getLogger().warn("Unable to unsubscribe. No subscription created or cancelled by camera  [" + this.getOnvifDevice().getIp() + "]");
        }
        finally {
            this.subscriptionManagerService = null;
        }
    }

    public Map<String, EventMessageDescription> getEventProperties() {
        GetEventProperties getEventProperties = new GetEventProperties();
        GetEventPropertiesResponse getEventPropertiesResponse = this.onvifEventService.getEventProperties(getEventProperties);
        List objects = getEventPropertiesResponse.getTopicSet().getAny();
        HashMap<String, EventMessageDescription> eventTypesMap = new HashMap<String, EventMessageDescription>();
        if (objects != null) {
            for (Object e : objects) {
                if (e == null) continue;
                Element topic = (Element)e;
                this.getMessageDescription(topic, topic.getLocalName(), eventTypesMap);
            }
        }
        if (this.getLogger().isDebugEnabled()) {
            for (Map.Entry entry : eventTypesMap.entrySet()) {
                this.getLogger().debug((String)entry.getKey() + " ---> " + entry.getValue());
            }
        }
        return eventTypesMap;
    }

    private void getMessageDescription(Node node, String name, Map<String, EventMessageDescription> foundNodes) {
        if (node != null && node.getChildNodes() != null) {
            NodeList children = node.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (child == null || child.getLocalName() == null) continue;
                if (!child.getLocalName().equalsIgnoreCase("MessageDescription")) {
                    this.getMessageDescription(child, name + "/" + child.getLocalName(), foundNodes);
                    continue;
                }
                EventMessageDescription eventMessageDescription = this.getEventMessageDescriptionFromNode(child);
                if (eventMessageDescription == null) continue;
                foundNodes.put(name, eventMessageDescription);
            }
        }
    }

    private EventMessageDescription getEventMessageDescriptionFromNode(Node messageDescription) {
        String sourceName = "";
        String sourceType = "";
        String[] dataName = new String[]{};
        String[] dataType = new String[]{};
        NodeList nodeList = messageDescription.getChildNodes();
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node child = nodeList.item(i);
                if (child == null || child.getLocalName() == null) continue;
                if (child.getLocalName().equals("Source")) {
                    Node simpleItemDescription = child.getFirstChild();
                    if (simpleItemDescription == null) continue;
                    NamedNodeMap attributes = simpleItemDescription.getAttributes();
                    if (attributes != null) {
                        Node nameNode = attributes.getNamedItem("Name");
                        sourceName = nameNode.getNodeValue();
                        Node typeNode = attributes.getNamedItem("Type");
                        sourceType = typeNode.getNodeValue();
                        continue;
                    }
                    return null;
                }
                if (!child.getLocalName().equals("Data")) continue;
                NodeList simpleItemDescriptions = child.getChildNodes();
                dataName = new String[simpleItemDescriptions.getLength()];
                dataType = new String[simpleItemDescriptions.getLength()];
                for (int j = 0; j < simpleItemDescriptions.getLength(); ++j) {
                    Node simpleItemDescription = simpleItemDescriptions.item(j);
                    if (simpleItemDescription == null || simpleItemDescription.getNodeType() != 1) continue;
                    NamedNodeMap attributes = simpleItemDescription.getAttributes();
                    if (attributes != null) {
                        Node nameNode = attributes.getNamedItem("Name");
                        dataName[j] = nameNode.getNodeValue();
                        Node typeNode = attributes.getNamedItem("Type");
                        dataType[j] = typeNode.getNodeValue();
                        continue;
                    }
                    return null;
                }
            }
        }
        return new EventMessageDescription(sourceName, sourceType, dataName, dataType);
    }

    private void renewSubscription(PullMessagesResponse pullMessagesResponse, Duration timeout) {
        XMLGregorianCalendar newTimeoutXml = pullMessagesResponse.getCurrentTime();
        newTimeoutXml.add(timeout);
        Renew renew = new Renew();
        renew.setTerminationTime(newTimeoutXml.toString());
        try {
            this.subscriptionManagerService.renew(renew);
        }
        catch (ResourceUnknownFault resourceUnknownFault) {
            ResourceUnknownFaultType resourceUnknownFaultType = resourceUnknownFault.getFaultInfo();
            this.getLogger().warn("ONVIF Fault : " + resourceUnknownFaultType.getFaultCause().toString() + " [" + this.getOnvifDevice().getIp() + "]");
        }
        catch (UnacceptableTerminationTimeFault unacceptableTerminationTimeFault) {
            UnacceptableTerminationTimeFaultType unacceptableTerminationTimeFaultType = unacceptableTerminationTimeFault.getFaultInfo();
            this.getLogger().warn("ONVIF Fault : " + unacceptableTerminationTimeFaultType.getFaultCause() + " [" + this.getOnvifDevice().getIp() + "]");
        }
        catch (Exception exception) {
            this.getLogger().error("Error renewing PullPoint-Subscription for [" + this.getOnvifDevice().getIp() + "]");
        }
    }

    public void resetEventService() {
        this.unsubscribe();
        this.pullPointSubscriptionService = null;
        this.getLogger().info("Subscription Service Resetted for  [" + this.getOnvifDevice().getIp() + "]");
    }
}

