/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared.onvif.services;

import de.seetec.v5.re.cm.device.shared.onvif.DeviceInformation;
import de.seetec.v5.re.cm.device.shared.onvif.OnvifDevice;
import de.seetec.v5.re.cm.device.shared.onvif.OnvifService;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import javax.xml.ws.Holder;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.onvif.ver10.device.wsdl.Device;
import org.onvif.ver10.device.wsdl.Service;
import org.onvif.ver10.schema.Capabilities;
import org.onvif.ver10.schema.CapabilityCategory;
import org.onvif.ver10.schema.Date;
import org.onvif.ver10.schema.DateTime;
import org.onvif.ver10.schema.IPv4Configuration;
import org.onvif.ver10.schema.IPv4NetworkInterface;
import org.onvif.ver10.schema.NetworkInterface;
import org.onvif.ver10.schema.NetworkProtocol;
import org.onvif.ver10.schema.NetworkProtocolType;
import org.onvif.ver10.schema.OnvifVersion;
import org.onvif.ver10.schema.PrefixedIPv4Address;
import org.onvif.ver10.schema.SystemDateTime;
import org.onvif.ver10.schema.Time;
import org.onvif.ver20.media.wsdl.Capabilities2;

public final class DeviceService
extends OnvifService {
    private final Device onvifDeviceService;
    private final String deviceServiceAddress;
    private List<Service> services = null;
    private boolean servicesInit = false;
    private Capabilities capabilities = null;
    private Capabilities2 capabilities2 = null;
    private boolean capabilitiesInit = false;
    private boolean capabilitiesInit2 = false;
    private DeviceInformation deviceInformation = null;
    private List<NetworkProtocol> networkProtocols = null;

    public DeviceService(JaxWsProxyFactoryBean factory, OnvifDevice onvifDevice, String deviceServiceAddress) throws Exception {
        super(factory, onvifDevice);
        this.deviceServiceAddress = deviceServiceAddress;
        this.onvifDeviceService = this.createService(Device.class, this.deviceServiceAddress);
    }

    public Device getOnvifDeviceService() {
        return this.onvifDeviceService;
    }

    public String getDeviceServiceAddress() {
        return this.deviceServiceAddress;
    }

    public List<Service> getServices() {
        if (!this.servicesInit && this.services == null) {
            this.servicesInit = true;
            this.services = this.onvifDeviceService.getServices(true);
        }
        return this.services;
    }

    public Capabilities getCapabilities() {
        if (!this.capabilitiesInit && this.capabilities == null) {
            this.capabilitiesInit = true;
            ArrayList<CapabilityCategory> capabilityCategories = new ArrayList<CapabilityCategory>();
            capabilityCategories.add(CapabilityCategory.ALL);
            this.capabilities = this.onvifDeviceService.getCapabilities(capabilityCategories);
        }
        return this.capabilities;
    }

    public DeviceInformation getDeviceInformation() throws Exception {
        if (this.deviceInformation == null) {
            Holder manufacturer = new Holder();
            Holder deviceModel = new Holder();
            Holder firmwareVersion = new Holder();
            Holder serialNumber = new Holder();
            Holder hardwareId = new Holder();
            this.onvifDeviceService.getDeviceInformation(manufacturer, deviceModel, firmwareVersion, serialNumber, hardwareId);
            this.deviceInformation = new DeviceInformation((String)manufacturer.value, (String)deviceModel.value, (String)firmwareVersion.value, (String)serialNumber.value, (String)hardwareId.value);
        }
        return this.deviceInformation;
    }

    public int getNumberOfInputs() {
        try {
            return this.getCapabilities().getDevice().getIO().getInputConnectors();
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public int getNumberOfRelays() {
        try {
            return this.getCapabilities().getDevice().getIO().getRelayOutputs();
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public boolean isTimeSynchronized(long timeDifferenceInMs) {
        try {
            SystemDateTime systemDateTime = this.onvifDeviceService.getSystemDateAndTime();
            DateTime dateTime = systemDateTime.getLocalDateTime();
            Date date = dateTime.getDate();
            Time time = dateTime.getTime();
            String string = date.getYear() + "-" + date.getMonth() + "-" + date.getDay() + " " + time.getHour() + ":" + time.getMinute() + ":" + time.getSecond();
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            java.util.Date cameraDate = format.parse(string);
            java.util.Date serverDate = new java.util.Date();
            long timeDifference = serverDate.getTime() - cameraDate.getTime();
            return Math.abs(timeDifference) <= timeDifferenceInMs;
        }
        catch (ParseException exception) {
            this.getLogger().warn("Time comparison failed");
            return false;
        }
    }

    public List<String> getIpV4Addresses() {
        ArrayList<String> ipV4Adresses = new ArrayList<String>();
        List networkInterfaces = this.onvifDeviceService.getNetworkInterfaces();
        if (networkInterfaces != null && networkInterfaces.size() > 0) {
            for (NetworkInterface networkInterface : networkInterfaces) {
                IPv4Configuration ipV4Configuration;
                List prefixedIPv4Addresses;
                IPv4NetworkInterface iPv4NetworkInterface = networkInterface.getIPv4();
                if (iPv4NetworkInterface == null || (prefixedIPv4Addresses = (ipV4Configuration = iPv4NetworkInterface.getConfig()).getManual()) == null || prefixedIPv4Addresses.size() <= 0) continue;
                for (PrefixedIPv4Address prefixedIPv4Address : prefixedIPv4Addresses) {
                    String ipV4Address = prefixedIPv4Address.getAddress();
                    ipV4Adresses.add(ipV4Address);
                }
            }
        }
        return ipV4Adresses;
    }

    public List<Integer> getPorts(NetworkProtocolType networkProtocolType) {
        ArrayList<Integer> ports = new ArrayList<Integer>();
        if (this.networkProtocols == null) {
            try {
                this.networkProtocols = this.onvifDeviceService.getNetworkProtocols();
            }
            catch (Exception exception) {
                this.getLogger().warn("No Response to getNetworkProtocols for " + this.getOnvifDevice());
                this.networkProtocols = new ArrayList<NetworkProtocol>();
            }
        }
        if (this.networkProtocols != null && this.networkProtocols.size() > 0) {
            for (NetworkProtocol networkProtocol : this.networkProtocols) {
                if (networkProtocol.getName() != networkProtocolType) continue;
                ports.addAll(networkProtocol.getPort());
            }
        }
        return ports;
    }

    public void setPorts(NetworkProtocolType networkProtocolType, List<Integer> ports) {
        List netProtocols = this.onvifDeviceService.getNetworkProtocols();
        if (netProtocols != null && netProtocols.size() > 0) {
            for (NetworkProtocol networkProtocol : netProtocols) {
                if (networkProtocol.getName() != networkProtocolType) continue;
                List existingPorts = networkProtocol.getPort();
                existingPorts.clear();
                existingPorts.addAll(ports);
            }
        }
    }

    public List<OnvifVersion> getOnvifSupportedVersions() {
        List onvifVersions;
        ArrayList<OnvifVersion> supportedVersions = new ArrayList<OnvifVersion>();
        if (this.getCapabilities() != null && this.getCapabilities().getDevice() != null && this.getCapabilities().getDevice().getSystem() != null && (onvifVersions = this.getCapabilities().getDevice().getSystem().getSupportedVersions()) != null && onvifVersions.size() > 0) {
            supportedVersions.addAll(onvifVersions);
        }
        return supportedVersions;
    }
}

