/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared.onvif.services;

import de.seetec.v5.re.cm.device.shared.onvif.OnvifDevice;
import de.seetec.v5.re.cm.device.shared.onvif.OnvifService;
import java.util.List;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.onvif.ver10.deviceio.wsdl.DeviceIOPort;
import org.onvif.ver10.schema.RelayLogicalState;
import org.onvif.ver10.schema.RelayOutput;

public final class DeviceIoService
extends OnvifService {
    private final DeviceIOPort onvifDeviceIoService;
    private final String deviceIoServiceAddress;

    public DeviceIoService(JaxWsProxyFactoryBean factory, OnvifDevice onvifDevice, String deviceIoServiceAddress) throws Exception {
        super(factory, onvifDevice);
        this.deviceIoServiceAddress = deviceIoServiceAddress;
        this.onvifDeviceIoService = this.createService(DeviceIOPort.class, this.deviceIoServiceAddress);
    }

    public DeviceIOPort getOnvifDeviceIoService() {
        return this.onvifDeviceIoService;
    }

    public String getDeviceIoServiceAddress() {
        return this.deviceIoServiceAddress;
    }

    public void setOutputState(int outputNumber, int value) {
        List relayOutputs = this.onvifDeviceIoService.getRelayOutputs();
        if (relayOutputs.size() > 0 && relayOutputs.size() >= outputNumber) {
            RelayOutput relayOutput = (RelayOutput)relayOutputs.get(outputNumber);
            this.onvifDeviceIoService.setRelayOutputState(relayOutput.getToken(), value > 0 ? RelayLogicalState.ACTIVE : RelayLogicalState.INACTIVE);
        }
    }
}

