/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared.onvif;

import de.seetec.v5.re.cm.device.shared.onvif.OnvifDevice;
import de.seetec.v5.re.cm.device.shared.onvif.WebServicePasswordHandler;
import de.seetec.v5.shared.net.SeeTecX509TrustManager;
import java.util.HashMap;
import java.util.List;
import javax.net.ssl.TrustManager;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.headers.Header;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.ws.security.wss4j.WSS4JOutInterceptor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class OnvifService {
    private Logger logger = LogManager.getLogger((String)this.getClass().getName());
    private JaxWsProxyFactoryBean factory = null;
    private OnvifDevice onvifDevice = null;

    public OnvifService(JaxWsProxyFactoryBean factory, OnvifDevice onvifDevice) {
        this.factory = factory;
        this.onvifDevice = onvifDevice;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public JaxWsProxyFactoryBean getFactory() {
        return this.factory;
    }

    public OnvifDevice getOnvifDevice() {
        return this.onvifDevice;
    }

    protected <T> T createService(Class<T> c, String serviceAdress, List<Header> headers) {
        this.factory.setServiceClass(c);
        this.factory.setAddress(serviceAdress);
        Object service = this.factory.create(c);
        Client client = ClientProxy.getClient((Object)service);
        if (this.onvifDevice.useAuthorization()) {
            String passwordType = this.onvifDevice.getPasswordType();
            HTTPConduit httpConduit = (HTTPConduit)client.getConduit();
            TLSClientParameters tlsClientParameters = httpConduit.getTlsClientParameters();
            if (tlsClientParameters == null) {
                tlsClientParameters = new TLSClientParameters();
                httpConduit.setTlsClientParameters(tlsClientParameters);
            }
            tlsClientParameters.setTrustManagers(new TrustManager[]{new SeeTecX509TrustManager()});
            tlsClientParameters.setDisableCNCheck(true);
            if (passwordType.equals("HttpDigest")) {
                AuthorizationPolicy authorizationPolicy = new AuthorizationPolicy();
                authorizationPolicy.setAuthorizationType("Digest");
                authorizationPolicy.setUserName(this.onvifDevice.getUsername());
                authorizationPolicy.setPassword(this.onvifDevice.getPassword());
                httpConduit.setAuthorization(authorizationPolicy);
            } else {
                Endpoint endpoint = client.getEndpoint();
                HashMap<String, Object> properties = new HashMap<String, Object>();
                properties.put("action", "UsernameToken");
                properties.put("user", this.onvifDevice.getUsername());
                properties.put("passwordType", this.onvifDevice.getPasswordType());
                properties.put("passwordCallbackRef", new WebServicePasswordHandler(this.onvifDevice.getPassword()));
                WSS4JOutInterceptor wssOut = new WSS4JOutInterceptor(properties);
                endpoint.getOutInterceptors().add(wssOut);
            }
        }
        if (headers != null && headers.size() > 0) {
            client.getRequestContext().put(Header.HEADER_LIST, headers);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.info(c.getName() + " service initialized");
        }
        return (T)service;
    }

    protected <T> T createService(Class<T> c, String serviceAddress) {
        return this.createService(c, serviceAddress, null);
    }
}

