/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared.onvif;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import org.apache.logging.log4j.Logger;
import org.onvif.ver10.schema.IntItems;
import org.onvif.ver10.schema.VideoResolution;
import org.onvif.ver10.schema.VideoResolution2;

public final class OnvifHelper {
    protected OnvifHelper() {
    }

    public static boolean isDefaultPort(String originalUrl, int newPort) {
        return originalUrl.toLowerCase().startsWith("http:") && newPort == 80 || originalUrl.toLowerCase().startsWith("https") && newPort == 443 || originalUrl.toLowerCase().startsWith("rtsp") && newPort == 554;
    }

    public static int exceptionToErrorCode(Exception exception) {
        String exceptionMessage = exception != null && exception.getMessage() != null ? exception.getMessage().trim() : "";
        String causeMessage = exception != null && exception.getCause() != null && exception.getCause().getMessage() != null ? exception.getCause().getMessage().trim() : "";
        int errorCode = -21600;
        if ((exceptionMessage = exceptionMessage + causeMessage).contains("HTTP response '401: Unauthorized'") || exceptionMessage.contains("wsse:FailedAuthentication") || exceptionMessage.contains("HTTP response '400: Bad Request'")) {
            errorCode = -21657;
        } else if (exceptionMessage.contains("Action failed")) {
            errorCode = -21670;
        } else if (exceptionMessage.contains("Connection timed out") || exceptionMessage.contains("Could not send Message")) {
            errorCode = -21656;
        }
        return errorCode;
    }

    public static String[] extractOnvifProfileAndStreamName(String cnf) {
        String[] result = new String[2];
        if (cnf.contains("||")) {
            result[0] = cnf.substring(0, cnf.indexOf("||"));
            result[1] = cnf.substring(cnf.indexOf("||") + "||".length());
        } else {
            result[0] = "VMS default";
            result[1] = cnf;
        }
        return result;
    }

    public static VideoResolution getBiggestResolution(List<VideoResolution> resolutions) {
        VideoResolution biggestResolution = null;
        for (VideoResolution resolution : resolutions) {
            if (biggestResolution != null && resolution.getWidth() <= biggestResolution.getWidth()) continue;
            biggestResolution = resolution;
        }
        return biggestResolution;
    }

    public static boolean contains(List<VideoResolution> videoResolutions, VideoResolution videoResolutionSearched) {
        for (VideoResolution videoResolution : videoResolutions) {
            if (videoResolution.getWidth() != videoResolutionSearched.getWidth() || videoResolution.getHeight() != videoResolutionSearched.getHeight()) continue;
            return true;
        }
        return false;
    }

    public static int getBiggestIntValueAndConvert(IntItems intList, boolean convert) {
        int biggestValue = 0;
        for (Integer value : intList.getItems()) {
            biggestValue = value > biggestValue ? value : biggestValue;
        }
        if (convert && biggestValue < 1000) {
            biggestValue *= 1000;
        }
        return biggestValue;
    }

    public static int durationToInt(Duration duration) {
        int durationInSec = 0;
        if (duration != null) {
            durationInSec += duration.getDays() * 86400;
            durationInSec += duration.getHours() * 3600;
            durationInSec += duration.getMinutes() * 60;
            durationInSec += duration.getSeconds();
        }
        return durationInSec;
    }

    public static Duration intToDuration(int timeInS) throws DatatypeConfigurationException {
        int time = timeInS;
        StringBuilder durationBuilder = new StringBuilder("P");
        if (time <= 0) {
            durationBuilder.append("T0S");
        } else {
            int minutes;
            int days = time / 86400;
            if (days != 0) {
                durationBuilder.append(days);
                durationBuilder.append("D");
                time -= days * 86400;
            }
            durationBuilder.append("T");
            int hours = time / 3600;
            if (hours != 0) {
                durationBuilder.append(hours);
                durationBuilder.append("H");
                time -= hours * 3600;
            }
            if ((minutes = time / 60) != 0) {
                durationBuilder.append(minutes);
                durationBuilder.append("M");
                time -= minutes * 60;
            }
            if (time != 0) {
                durationBuilder.append(time);
                durationBuilder.append("S");
            }
        }
        DatatypeFactory datatypeFactory = DatatypeFactory.newInstance();
        return datatypeFactory.newDuration(durationBuilder.toString());
    }

    public static String changeIPAddressPortOfUrl(String originalUrl, String newHost, int newPort, Logger logger) {
        String newUrl = OnvifHelper.changeIPAddressOfUrl(originalUrl, newHost, logger);
        newUrl = OnvifHelper.changePortOfUrl(newUrl, newPort, logger);
        return newUrl;
    }

    private static String changeIPAddressOfUrl(String originalUrl, String newIPAddress, Logger logger) {
        String newUrl;
        if (newIPAddress != null && !originalUrl.contains(newIPAddress)) {
            newUrl = originalUrl.replaceFirst("(\\d{1,3}.){3}\\d{1,3}", newIPAddress);
            if (logger != null) {
                logger.info(String.format("Device is behind a NAT. Replacing [%s] with [%s]", originalUrl, newUrl));
            }
        } else {
            newUrl = originalUrl;
        }
        return newUrl;
    }

    private static String changePortOfUrl(String originalUrl, int newPort, Logger logger) {
        String newUrl = originalUrl;
        String[] tempUrl = originalUrl.split(":");
        String tempPort = Integer.toString(newPort);
        if (newPort >= 0 && newPort <= 65535) {
            if (tempUrl.length == 3) {
                if (!tempUrl[2].contains(tempPort)) {
                    newUrl = tempUrl[0] + ":" + tempUrl[1] + ":" + tempUrl[2].replaceFirst("\\d{1,5}", tempPort);
                    if (logger != null) {
                        logger.info(String.format("Device is behind a NAT. Replacing [%s] with [%s]", originalUrl, newUrl));
                    }
                }
            } else if (tempUrl.length == 2 && !OnvifHelper.isDefaultPort(originalUrl, newPort)) {
                try {
                    URI uri = new URI(originalUrl);
                    URI newUri = new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), newPort, uri.getPath(), uri.getQuery(), uri.getFragment());
                    newUrl = newUri.toString();
                }
                catch (Exception ex) {
                    logger.info("Exception while adapting url " + originalUrl + " and port " + newPort);
                }
            }
        }
        return newUrl;
    }

    static List<VideoResolution> convertResolution2ToResolution(List<VideoResolution2> videoResolutions2) {
        ArrayList<VideoResolution> ret = new ArrayList<VideoResolution>();
        for (VideoResolution2 videoResolution2 : videoResolutions2) {
            VideoResolution videoResolution = new VideoResolution();
            videoResolution.setHeight(videoResolution2.getHeight());
            videoResolution.setWidth(videoResolution2.getWidth());
            ret.add(videoResolution);
        }
        return ret;
    }
}

