/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared.onvif;

import de.seetec.v5.re.cm.device.shared.onvif.OnvifDevice;
import de.seetec.v5.re.cm.device.shared.onvif.OnvifException;
import de.seetec.v5.re.cm.device.shared.onvif.OnvifHelper;
import de.seetec.v5.re.cm.device.shared.onvif.OnvifService;
import de.seetec.v5.re.cm.device.shared.onvif.enums.ServiceConstants;
import de.seetec.v5.re.cm.device.shared.onvif.services.AnalyticsService;
import de.seetec.v5.re.cm.device.shared.onvif.services.DeviceIoService;
import de.seetec.v5.re.cm.device.shared.onvif.services.DeviceService;
import de.seetec.v5.re.cm.device.shared.onvif.services.EventService;
import de.seetec.v5.re.cm.device.shared.onvif.services.ImagingService;
import de.seetec.v5.re.cm.device.shared.onvif.services.Media2Service;
import de.seetec.v5.re.cm.device.shared.onvif.services.MediaService;
import de.seetec.v5.re.cm.device.shared.onvif.services.PtzService;
import de.seetec.v5.re.cm.device.shared.onvif.services.ReplayService;
import de.seetec.v5.re.cm.device.shared.onvif.services.SearchService;
import java.util.List;
import org.apache.cxf.interceptor.LoggingInInterceptor;
import org.apache.cxf.interceptor.LoggingOutInterceptor;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.onvif.ver10.device.wsdl.Service;
import org.onvif.ver10.schema.Capabilities;

public class OnvifCore {
    private Logger logger = LogManager.getLogger((String)this.getClass().getName());
    private OnvifDevice onvifDevice = null;
    private DeviceService deviceService = null;
    private MediaService mediaService = null;
    private Media2Service media2Service = null;
    private EventService eventService = null;
    private DeviceIoService deviceIoService = null;
    private PtzService ptzService = null;
    private ImagingService imagingService = null;
    private AnalyticsService analyticsService = null;
    private SearchService searchService = null;
    private ReplayService replayService = null;

    public OnvifCore() {
        ((org.apache.logging.log4j.core.Logger)LogManager.getLogger((String)"org.apache.cxf")).setLevel(Level.OFF);
    }

    public void init(OnvifDevice onvifDevice, boolean useLogging) throws OnvifException {
        this.logger.info("Initializing ONVIF services for " + onvifDevice);
        long startTime = System.currentTimeMillis();
        this.onvifDevice = onvifDevice;
        this.deviceService = (DeviceService)this.getService(ServiceConstants.DEVICE, useLogging);
        this.mediaService = (MediaService)this.getService(ServiceConstants.MEDIA, useLogging);
        this.media2Service = (Media2Service)this.getService(ServiceConstants.MEDIA2, useLogging);
        this.eventService = (EventService)this.getService(ServiceConstants.EVENT, useLogging);
        this.deviceIoService = (DeviceIoService)this.getService(ServiceConstants.DEVICEIO, useLogging);
        this.ptzService = (PtzService)this.getService(ServiceConstants.PTZ, useLogging);
        this.imagingService = (ImagingService)this.getService(ServiceConstants.IMAGING, useLogging);
        this.analyticsService = (AnalyticsService)this.getService(ServiceConstants.ANALYTICS, useLogging);
        this.searchService = (SearchService)this.getService(ServiceConstants.SEARCH, useLogging);
        this.replayService = (ReplayService)this.getService(ServiceConstants.REPLAY, useLogging);
        long endTime = System.currentTimeMillis();
        this.logger.info("ONVIF services initialized (time: " + (endTime - startTime) + "ms) for " + onvifDevice);
    }

    private <S extends OnvifService> S getService(ServiceConstants serviceConstant, boolean useLogging) throws OnvifException {
        Class s = serviceConstant.getOnvifServiceClass();
        JaxWsProxyFactoryBean serviceFactory = this.getServiceFactory(useLogging, serviceConstant);
        if (this.logger.isDebugEnabled()) {
            this.logger.info("Initialize " + (Object)((Object)serviceConstant) + "-Service for " + this.onvifDevice + " ...");
        }
        try {
            if (serviceConstant.equals((Object)ServiceConstants.DEVICE)) {
                String deviceServiceAddress = "";
                deviceServiceAddress = this.onvifDevice.useHttps() ? "https://" + this.onvifDevice.getIp() + ":" + this.onvifDevice.getSslPort() + "/onvif/device_service" : "http://" + this.onvifDevice.getIp() + ":" + this.onvifDevice.getPort() + "/onvif/device_service";
                DeviceService instance = new DeviceService(serviceFactory, this.onvifDevice, deviceServiceAddress);
                if (s.isInstance(instance)) {
                    this.logger.info((Object)((Object)serviceConstant) + "-Service for " + this.onvifDevice + " successfully initialized");
                    return (S)instance;
                }
                throw new Exception("Error casting DeviceService to " + s.getSimpleName());
            }
        }
        catch (Exception exception) {
            OnvifException onvifException = new OnvifException(this.onvifDevice, serviceConstant, "could not be initialized", exception);
            throw onvifException;
        }
        List<Service> services = null;
        try {
            services = this.deviceService.getServices();
            if (services != null) {
                for (Service service : services) {
                    String address;
                    if (!service.getNamespace().equals(serviceConstant.getServiceNamespace()) || (address = service.getXAddr()) == null || address.isEmpty()) continue;
                    address = this.onvifDevice.useHttps() ? OnvifHelper.changeIPAddressPortOfUrl(address, this.onvifDevice.getIp(), this.onvifDevice.getSslPort(), this.logger) : OnvifHelper.changeIPAddressPortOfUrl(address, this.onvifDevice.getIp(), this.onvifDevice.getPort(), this.logger);
                    OnvifService instance = (OnvifService)s.getConstructor(JaxWsProxyFactoryBean.class, OnvifDevice.class, String.class).newInstance(serviceFactory, this.onvifDevice, address);
                    this.logger.info((Object)((Object)serviceConstant) + "-Service for " + this.onvifDevice + " successfully initialized");
                    return (S)instance;
                }
            }
        }
        catch (Exception exception) {
            OnvifException onvifException;
            if (services == null) {
                onvifException = new OnvifException(this.onvifDevice, ServiceConstants.DEVICE, "doesn't support the getServices operation", exception);
                this.logger.warn((Object)onvifException);
            }
            onvifException = new OnvifException(this.onvifDevice, serviceConstant, "could not be initialized, try fallback implementation", exception);
            this.logger.warn((Object)onvifException);
        }
        Capabilities capabilities = null;
        try {
            String address;
            capabilities = this.deviceService.getCapabilities();
            if (capabilities != null && (address = this.getServiceAddress(capabilities, serviceConstant)) != null && !address.isEmpty()) {
                address = this.onvifDevice.useHttps() ? OnvifHelper.changeIPAddressPortOfUrl(address, this.onvifDevice.getIp(), this.onvifDevice.getSslPort(), this.logger) : OnvifHelper.changeIPAddressPortOfUrl(address, this.onvifDevice.getIp(), this.onvifDevice.getPort(), this.logger);
                OnvifService instance = (OnvifService)s.getConstructor(JaxWsProxyFactoryBean.class, OnvifDevice.class, String.class).newInstance(serviceFactory, this.onvifDevice, address);
                this.logger.info((Object)((Object)serviceConstant) + "-Service for " + this.onvifDevice + " successfully initialized");
                return (S)instance;
            }
        }
        catch (Exception exception) {
            OnvifException onvifException;
            if (capabilities == null) {
                onvifException = new OnvifException(this.onvifDevice, ServiceConstants.DEVICE, "could not provide capabilities", exception);
                throw onvifException;
            }
            if (!serviceConstant.isMandatory()) {
                onvifException = new OnvifException(this.onvifDevice, serviceConstant, "could not be initialized, but is skipped because not mandatory", exception);
                this.logger.warn((Object)onvifException);
                return null;
            }
            onvifException = new OnvifException(this.onvifDevice, serviceConstant, "could not be initialized", exception);
            throw onvifException;
        }
        this.logger.warn((Object)((Object)serviceConstant) + "-Service for " + this.onvifDevice + " could not be initialized");
        return null;
    }

    private String getServiceAddress(Capabilities capabilities, ServiceConstants serviceConstant) {
        switch (serviceConstant) {
            case MEDIA: {
                return capabilities.getMedia() != null ? capabilities.getMedia().getXAddr() : null;
            }
            case EVENT: {
                return capabilities.getEvents() != null ? capabilities.getEvents().getXAddr() : null;
            }
            case DEVICEIO: {
                return capabilities.getDevice() != null ? capabilities.getDevice().getXAddr() : null;
            }
            case PTZ: {
                return capabilities.getPTZ() != null ? capabilities.getPTZ().getXAddr() : null;
            }
            case IMAGING: {
                return capabilities.getImaging() != null ? capabilities.getImaging().getXAddr() : null;
            }
            case ANALYTICS: {
                return capabilities.getAnalytics() != null ? capabilities.getAnalytics().getXAddr() : null;
            }
        }
        return null;
    }

    private JaxWsProxyFactoryBean getServiceFactory(boolean useLogging, ServiceConstants serviceConstant) {
        JaxWsProxyFactoryBean serviceFactory = new JaxWsProxyFactoryBean();
        serviceFactory.setBindingId("http://schemas.xmlsoap.org/wsdl/soap12/");
        if (useLogging) {
            ((org.apache.logging.log4j.core.Logger)LogManager.getLogger((String)"org.apache.cxf")).setLevel(Level.INFO);
            LoggingOutInterceptor loggingOutInterceptor = new LoggingOutInterceptor();
            LoggingInInterceptor loggingInInterceptor = new LoggingInInterceptor();
            loggingOutInterceptor.setPrettyLogging(true);
            loggingInInterceptor.setPrettyLogging(true);
            serviceFactory.getInInterceptors().add(loggingInInterceptor);
            serviceFactory.getOutInterceptors().add(loggingOutInterceptor);
        }
        return serviceFactory;
    }

    public final void shutdown() {
        if (this.onvifDevice != null) {
            this.onvifDevice = null;
        }
        if (this.deviceService != null) {
            this.deviceService = null;
        }
        if (this.mediaService != null) {
            this.mediaService = null;
        }
        if (this.eventService != null) {
            this.eventService = null;
        }
        if (this.deviceIoService != null) {
            this.deviceIoService = null;
        }
        if (this.ptzService != null) {
            this.ptzService = null;
        }
        if (this.imagingService != null) {
            this.imagingService = null;
        }
        if (this.analyticsService != null) {
            this.analyticsService = null;
        }
        if (this.replayService != null) {
            this.replayService = null;
        }
        if (this.searchService != null) {
            this.searchService = null;
        }
    }

    public OnvifDevice getOnvifDevice() {
        return this.onvifDevice;
    }

    public final DeviceService getDeviceService() {
        return this.deviceService;
    }

    public final MediaService getMediaService() {
        return this.mediaService;
    }

    public final Media2Service getMedia2Service() {
        return this.media2Service;
    }

    public final EventService getEventService() {
        return this.eventService;
    }

    public final DeviceIoService getDeviceIoService() {
        return this.deviceIoService;
    }

    public final PtzService getPtzService() {
        return this.ptzService;
    }

    public final ImagingService getImagingService() {
        return this.imagingService;
    }

    public final AnalyticsService getAnalyticsService() {
        return this.analyticsService;
    }

    public final SearchService getSearchService() {
        return this.searchService;
    }

    public final ReplayService getReplayService() {
        return this.replayService;
    }
}

