/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared.net.udp;

import de.seetec.v5.re.cm.device.shared.net.udp.UdpWriter;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import org.apache.logging.log4j.LogManager;

public final class UdpWriterUnicastBackChannel
extends UdpWriter {
    private final int localPort;

    public UdpWriterUnicastBackChannel(DatagramSocket givenSocket, int localPort) {
        this.logger = LogManager.getLogger((String)this.getClass().getName());
        this.localPort = localPort;
        this.shutdown = false;
        if (givenSocket != null) {
            this.socket = givenSocket;
        } else {
            this.openSocket();
        }
        if (this.socket == null) {
            this.logger.warn("No socket, shutting down");
        }
    }

    @Override
    protected void openSocket() {
        int i = 0;
        while (this.socket == null && i < 10) {
            ++i;
            try {
                this.socket = new DatagramSocket(this.localPort);
                this.socket.setSoTimeout(100000);
            }
            catch (Exception e) {
                this.logger.info((Object)e);
                this.socket = null;
            }
        }
        if (this.socket == null) {
            this.logger.warn("No socket available");
        }
    }

    @Override
    public int send(byte[] data) {
        return 0;
    }

    public int send(byte[] data, InetAddress remoteAddress, int remotePort) {
        if (this.shutdown) {
            return -21609;
        }
        try {
            DatagramPacket p = new DatagramPacket(data, data.length, remoteAddress, remotePort);
            this.socket.send(p);
        }
        catch (Exception e) {
            if (this.shutdown) {
                return -21609;
            }
            this.logger.warn((Object)e);
            this.shutdown();
            return -21656;
        }
        return 0;
    }

    public int getLocalPort() {
        if (this.socket != null) {
            return this.socket.getLocalPort();
        }
        return -1;
    }
}

