/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared.net.udp;

import de.seetec.v5.re.cm.device.shared.net.NetworkCallback;
import de.seetec.v5.re.cm.device.shared.net.udp.UdpReader;
import java.net.DatagramSocket;
import java.net.InetAddress;
import org.apache.logging.log4j.LogManager;

public class UdpReaderUnicast
extends UdpReader {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.shared.net.udp.UdpReaderUnicast";
    private int port = -1;

    public UdpReaderUnicast(NetworkCallback callback) {
        this.logger = LogManager.getLogger((String)CLASS_NAME);
        this.shutdown = false;
        this.callback = callback;
    }

    private UdpReaderUnicast(NetworkCallback callback, int port) {
        this(callback);
        this.port = port;
    }

    public UdpReaderUnicast(NetworkCallback callback, int port, InetAddress inetAddress, int serverPort) {
        this(callback, port);
        this.remotePort = serverPort;
        this.remoteAddress = inetAddress;
    }

    @Override
    protected void openSocket(int bufferSize, int soTimeout, boolean onlyAcceptEvenPorts) {
        int i = 0;
        while (i < 10 && this.socket == null) {
            ++i;
            try {
                if (this.port != -1) {
                    this.socket = new DatagramSocket(this.port);
                } else if (onlyAcceptEvenPorts) {
                    while ((this.socket = new DatagramSocket()).getLocalPort() % 2 != 0) {
                        this.logger.info("UDP server port is specified to be EVEN, but we got '" + this.socket.getLocalPort() + "'. Close and try again.");
                        this.socket.close();
                    }
                } else {
                    this.socket = new DatagramSocket();
                }
                this.socket.setSoTimeout(soTimeout);
                this.socket.setReceiveBufferSize(bufferSize);
            }
            catch (Exception e) {
                this.socket = null;
            }
        }
        if (this.socket == null) {
            this.logger.warn("No socket available");
        }
    }
}

