/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared.net.udp;

import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPHandlerIntf;
import de.seetec.v5.re.cm.device.shared.net.udp.UdpRTPReader;
import java.net.DatagramSocket;
import java.net.InetAddress;
import org.apache.logging.log4j.LogManager;

public class UdpRTPReaderUnicast
extends UdpRTPReader {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.shared.net.udp.UdpRTPReaderUnicast";
    private int port = -1;

    public UdpRTPReaderUnicast(RTSPHandlerIntf callback) {
        this.logger = LogManager.getLogger((String)CLASS_NAME);
        this.shutdown = false;
        this.callback = callback;
    }

    public UdpRTPReaderUnicast(RTSPHandlerIntf callback, int port) {
        this(callback);
        this.port = port;
    }

    public UdpRTPReaderUnicast(RTSPHandlerIntf callback, int port, InetAddress inetAddress, int serverPort) {
        this(callback, port);
        this.remotePort = serverPort;
        this.remoteAddress = inetAddress;
    }

    @Override
    protected void openSocket(int bufferSize, int soTimeout) {
        int i = 0;
        while (i < 10 && this.socket == null) {
            ++i;
            try {
                if (this.port != -1) {
                    this.socket = new DatagramSocket(this.port);
                } else {
                    while ((this.socket = new DatagramSocket()).getLocalPort() % 2 != 0) {
                        this.logger.info("UDP server port is specified to be EVEN, but we got '" + this.socket.getLocalPort() + "'. Close and try again.");
                        this.socket.close();
                    }
                }
                this.socket.setSoTimeout(soTimeout);
                this.socket.setReceiveBufferSize(bufferSize);
            }
            catch (Exception e) {
                this.socket = null;
            }
        }
        if (this.socket == null) {
            this.logger.warn("No socket available");
        }
    }
}

