/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared.net.rtsp.request;

import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPRequest;
import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPStreamSettings;
import de.seetec.v5.re.shared.TransmissionType;

public class SetupRequest
extends RTSPRequest {
    private boolean useMulticast;
    private boolean useTCP;
    private int lowerStream = 1;
    private int udpPort;
    private int multicastClientPort = 0;
    private String requireField;

    public void setIsAudioSetup(boolean isAudioSetup) {
        this.isAudioSetup = isAudioSetup;
    }

    public void setIsMetadataSetup(boolean isMetadataSetup) {
        this.isMetadataSetup = isMetadataSetup;
    }

    public int init(String url, RTSPStreamSettings rtspSettings) {
        this.command = 11;
        this.url = url;
        this.useMulticast = rtspSettings.getTransmissionID() == TransmissionType.RTP_OVER_UDP_MULTICAST;
        this.useTCP = rtspSettings.getTransmissionID() == TransmissionType.RTP_OVER_RTSP_OVER_TCP || rtspSettings.getTransmissionID() == TransmissionType.RTP_OVER_RTSP_OVER_HTTP_UNICAST;
        this.isVideoSetup = !this.isAudioSetup && !this.isMetadataSetup && rtspSettings.isVideoEnabled();
        this.userAgent = rtspSettings.getUserAgent();
        if (rtspSettings.getTCPChannel() != -1) {
            this.lowerStream = rtspSettings.getTCPChannel();
        }
        if (rtspSettings.getRequireField() != null) {
            this.requireField = rtspSettings.getRequireField();
        }
        if (this.isAudioSetup) {
            this.lowerStream += 2;
        }
        if (this.isMetadataSetup) {
            this.lowerStream += 4;
        }
        return super.init();
    }

    @Override
    public String toString() {
        String ret = "SETUP " + this.url + " RTSP/1.0" + "\r\n";
        if (this.sequenceNumber != null) {
            ret = ret + "CSeq: " + this.sequenceNumber + "\r\n";
        }
        if (this.userAgent != null) {
            ret = ret + "User-Agent: " + this.userAgent + "\r\n";
        }
        if (this.useMulticast) {
            ret = ret + "Transport: RTP/AVP;multicast;";
            if (this.multicastClientPort != 0) {
                ret = ret + "client_port=" + this.multicastClientPort + "-" + (this.multicastClientPort + 1);
            }
            ret = ret + "\r\n";
        } else {
            ret = this.useTCP ? (this.lowerStream != -1 ? ret + "Transport: RTP/AVP/TCP;unicast;interleaved=" + this.lowerStream + "-" + (this.lowerStream + 1) + "\r\n" : ret + "Transport: RTP/AVP/TCP;unicast\r\n") : ret + "Transport: RTP/AVP;unicast;client_port=" + this.udpPort + "-" + (this.udpPort + 1) + "\r\n";
        }
        if (this.sessionID != null) {
            ret = ret + "Session: " + this.sessionID + "\r\n";
        }
        if (this.isBackChannelEnabled) {
            ret = ret + "Require: www.onvif.org/ver20/backchannel\r\n";
        }
        if (this.requireField != null) {
            ret = ret + "Require: " + this.requireField + "\r\n";
        }
        if (this.passPhrase != null) {
            ret = ret + this.passPhrase;
        }
        return ret;
    }

    public void setUdpPort(int udpPort) {
        this.udpPort = udpPort;
    }

    public void setMulticastClientPort(int multicastClientPort) {
        this.multicastClientPort = multicastClientPort;
    }

    public void setIsBackChannelSetup(boolean enabled) {
        this.isBackChannelEnabled = enabled;
    }
}

