/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared.net.rtsp;

import de.seetec.v5.re.cm.device.shared.net.rtsp.SdpAudioData;
import de.seetec.v5.re.cm.device.shared.net.rtsp.SdpVideoData;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.ArrayList;
import java.util.List;

public class SDPContent {
    private String header;
    private String body;

    public SDPContent(String content) throws SeeTecException {
        if (content == null) {
            throw new IllegalArgumentException();
        }
        String[] headerAndBody = content.split("\r\n\r\n");
        if (headerAndBody.length != 2) {
            throw new SeeTecException(-20000, "Not possible to split SDP in header and body.");
        }
        this.header = headerAndBody[0];
        this.body = headerAndBody[1];
    }

    public List<String> getAttributes(String key) {
        ArrayList<String> attributes = new ArrayList<String>();
        String[] bodyLines = this.body.split("[\r\n]+");
        String attributeToSearch = "a=" + key + ":";
        for (String line : bodyLines) {
            if (!line.startsWith(attributeToSearch)) continue;
            attributes.add(line.substring(attributeToSearch.length()));
        }
        return attributes;
    }

    public String getHeader() {
        return this.header;
    }

    public String getBody() {
        return this.body;
    }

    public List<SdpVideoData> getSdpVideoData() {
        ArrayList<SdpVideoData> result = new ArrayList<SdpVideoData>();
        String contentLines = this.getBody();
        int index = contentLines.indexOf("m=video");
        while (index >= 0) {
            SdpVideoData sdpVideoData;
            int nextIndex = contentLines.indexOf("m=", index + 1);
            if (nextIndex == -1) {
                sdpVideoData = new SdpVideoData(contentLines.substring(index, contentLines.length() - 1));
                result.add(sdpVideoData);
                continue;
            }
            sdpVideoData = new SdpVideoData(contentLines.substring(index, nextIndex));
            result.add(sdpVideoData);
            ++index;
            index = contentLines.indexOf("m=video", index);
        }
        return result;
    }

    public List<SdpAudioData> getSdpAudioData() {
        ArrayList<SdpAudioData> result = new ArrayList<SdpAudioData>();
        String contentLines = this.getBody();
        int index = contentLines.indexOf("m=audio");
        while (index >= 0) {
            SdpAudioData sdpAudioData;
            int nextIndex = contentLines.indexOf("m=", index + 1);
            if (nextIndex == -1) {
                sdpAudioData = new SdpAudioData(contentLines.substring(index, contentLines.length() - 1));
                result.add(sdpAudioData);
                continue;
            }
            sdpAudioData = new SdpAudioData(contentLines.substring(index, nextIndex));
            result.add(sdpAudioData);
            ++index;
            index = contentLines.indexOf("m=audio", index);
        }
        return result;
    }
}

