/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared.net.rtsp;

import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPConstantsIntf;
import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPHandlerHTTP;
import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPHandlerIntf;
import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPHandlerSuper;
import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPHandlerTCP;
import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPHandlerUDP;
import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPHandlerUDPMulticast;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingVideoSourceClientRTSP;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.re.shared.TransmissionType;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.SeeTecException;
import java.net.DatagramSocket;
import java.net.MalformedURLException;
import java.net.URL;

public class RTSPStreamSettings
implements RTSPConstantsIntf {
    private int timeOut;
    private NetworkParameter networkParameter;
    private boolean printDebug;
    private DatagramSocket socket;
    private int keepAliveMethod;
    private String rtspUrl;
    private String keepAliveUrl;
    private RTSPHandlerIntf callback;
    private RTSPHandlerIntf audioHandlerCallback;
    private TransmissionType transmissionID;
    private boolean isAudioEnabled = false;
    private boolean isVideoEnabled = true;
    private int errorCode;
    private int[] resolution;
    private int udpBuffer = 2048;
    private String useRange;
    private boolean receiverReportsEnabled = true;
    private boolean isFrameCropping;
    private RTSPHandlerIntf metadataHandlerCallback;
    private boolean isMetadataEnabled;
    private int keepAliveInterval;
    private Codec codec;
    private String userAgent;
    private int rtspPort = -1;
    private int tcpChannel = -1;
    private int checkResolutionTries = 9;
    private boolean checkResolution;
    private boolean checkResolutionWidth;
    private int metadataTimeout = -1;
    private String rtspHost = null;
    private StreamingVideoSourceClientRTSP streamingVideoSourceClientRtsp;
    private boolean executeOperationAfterDescribe = false;
    private boolean executeOperationAfterSetup = false;
    private boolean executeOperationAfterPlay = false;
    private boolean startAllTrackIds = false;
    private long waitingTime = 0L;
    private boolean keepAliveForTimeouts = false;
    private boolean ignoreSSRC = false;
    private boolean useHTTPPersistentDuplexTunnel = false;
    private Double scale = null;
    private boolean basicAuthenticationDisabled = false;
    private boolean useAuthenticationForHTTPTunnel = false;
    private boolean isBackChannelEnabled;
    private RTSPHandlerIntf backChannelCallback;
    private boolean considerAspectRatio = false;
    private String frames;
    private Codec playbackCodec = null;
    private String requireField;
    private boolean isEdgeStoragePlayback;
    private boolean shutdownOnKeepAliveError = false;
    private Codec audioCodec;

    public boolean isIsBackChannelEnabled() {
        return this.isBackChannelEnabled;
    }

    public String getRtspUrl() {
        return this.rtspUrl;
    }

    public String getRequireField() {
        return this.requireField;
    }

    public int getTimeOut() {
        return this.timeOut;
    }

    public boolean getIgnoreSSRC() {
        return this.ignoreSSRC;
    }

    public void setIgnoreSSRC(boolean ssrc) {
        this.ignoreSSRC = ssrc;
    }

    public NetworkParameter getNetworkParameter() {
        return this.networkParameter;
    }

    public boolean isPrintDebug() {
        return this.printDebug;
    }

    public void setRTCPSocket(DatagramSocket socket) {
        this.socket = socket;
    }

    public DatagramSocket getSocket() {
        return this.socket;
    }

    public int getKeepAliveMethod() {
        return this.keepAliveMethod;
    }

    public String getKeepAliveUrl() {
        return this.keepAliveUrl;
    }

    public RTSPHandlerIntf getCallback() {
        return this.callback;
    }

    public void setEnableBackchannel(boolean enable) {
        this.isBackChannelEnabled = enable;
    }

    RTSPHandlerIntf getAudioHandlerCallback() {
        return this.audioHandlerCallback;
    }

    public RTSPHandlerIntf getBackChannelCallback() {
        return this.backChannelCallback;
    }

    public TransmissionType getTransmissionID() {
        return this.transmissionID;
    }

    public void setIsVideoEnabled(boolean videoEnabled) {
        this.isVideoEnabled = videoEnabled;
    }

    public boolean isVideoEnabled() {
        return this.isVideoEnabled;
    }

    public boolean isIsAudioEnabled() {
        return this.isAudioEnabled;
    }

    public void setAudioHandlerCallback(RTSPHandlerIntf audioHandlerCallback) {
        this.audioHandlerCallback = audioHandlerCallback;
    }

    public void setBackChannelCallback(RTSPHandlerIntf backChannelCallback) {
        this.backChannelCallback = backChannelCallback;
    }

    public void setCallback(RTSPHandlerIntf callback) {
        this.callback = callback;
    }

    public void setCheckResolution(boolean enable, int[] resolution) {
        this.setCheckResolution(enable, resolution, false);
    }

    public void setCheckResolution(boolean enable, int[] resolution, boolean considerAspectRatio) {
        this.resolution = new int[resolution.length];
        System.arraycopy(resolution, 0, this.resolution, 0, resolution.length);
        this.checkResolution = enable;
        this.considerAspectRatio = considerAspectRatio;
    }

    public void setCheckResolution(boolean enable, int[] resolution, int tries) {
        this.resolution = new int[resolution.length];
        System.arraycopy(resolution, 0, this.resolution, 0, resolution.length);
        this.checkResolution = enable;
        this.checkResolutionTries = tries;
    }

    public void setCheckResolution(boolean enable, int[] resolution, int tries, long waitingTime) {
        this.resolution = new int[resolution.length];
        System.arraycopy(resolution, 0, this.resolution, 0, resolution.length);
        this.checkResolution = enable;
        this.checkResolutionTries = tries;
        this.waitingTime = waitingTime;
    }

    public void setCheckResolutionWidth(boolean enable, int[] resolution) {
        this.resolution = new int[resolution.length];
        System.arraycopy(resolution, 0, this.resolution, 0, resolution.length);
        this.checkResolutionWidth = enable;
    }

    public void setCheckResolutionWidth(boolean enable, int[] resolution, int tries) {
        this.resolution = new int[resolution.length];
        System.arraycopy(resolution, 0, this.resolution, 0, resolution.length);
        this.checkResolutionWidth = enable;
        this.checkResolutionTries = tries;
    }

    public int[] getResolution() {
        int[] result;
        if (this.resolution != null) {
            result = new int[this.resolution.length];
            System.arraycopy(this.resolution, 0, result, 0, this.resolution.length);
        } else {
            result = new int[]{};
        }
        return result;
    }

    public boolean isCheckResolution() {
        return this.checkResolution;
    }

    public boolean isCheckResolutionWidth() {
        return this.checkResolutionWidth;
    }

    public int getCheckResolutionTries() {
        return this.checkResolutionTries;
    }

    public boolean isConsiderAspectRatio() {
        return this.considerAspectRatio;
    }

    public void setUdpBuffer(int bufferSize) {
        this.udpBuffer = bufferSize;
    }

    public int getUdpBuffer() {
        return this.udpBuffer;
    }

    public final String getRange() {
        return this.useRange;
    }

    public final void setRange(String range) {
        this.useRange = range;
    }

    public final Double getScale() {
        return this.scale;
    }

    public final void setScale(Double scale) {
        this.scale = scale;
    }

    boolean receiverReportsEnabled() {
        return this.receiverReportsEnabled;
    }

    public void setReceiverReportsEnabled(boolean enabled) {
        this.receiverReportsEnabled = enabled;
    }

    public boolean isFrameCropping() {
        return this.isFrameCropping;
    }

    public void setIsFrameCropping(boolean cropping) {
        this.isFrameCropping = cropping;
    }

    public RTSPHandlerIntf getMetadataHandlerCallback() {
        return this.metadataHandlerCallback;
    }

    public boolean isMetadataEnabled() {
        return this.isMetadataEnabled;
    }

    public void setKeepAliveInterval(int keepAliveInterval) {
        this.keepAliveInterval = keepAliveInterval;
    }

    int getKeepAliveInterval() {
        return this.keepAliveInterval;
    }

    public void setCodec(Codec codec) {
        this.codec = codec;
    }

    Codec getCodec() {
        return this.codec;
    }

    public void setAudioCodec(Codec codec) {
        this.audioCodec = codec;
    }

    Codec getAudioCodec() {
        return this.audioCodec;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public void enableMetadata(RTSPHandlerIntf metadataHandler) {
        this.metadataHandlerCallback = metadataHandler;
        this.isMetadataEnabled = true;
    }

    void setKeepAliveMethod(int keepAliveMethod) {
        this.keepAliveMethod = keepAliveMethod;
    }

    public void setRTSPPort(int rtspPort) {
        this.rtspPort = rtspPort;
    }

    public int getRTSPPort() {
        return this.rtspPort;
    }

    void setRTSPUrl(String contentBase) {
        this.rtspUrl = contentBase;
    }

    public int getTCPChannel() {
        return this.tcpChannel;
    }

    public void setTcpChannel(int tcpChannel) {
        this.tcpChannel = tcpChannel;
    }

    public void setMetadataTimeout(int metadataTimeout) {
        this.metadataTimeout = metadataTimeout;
    }

    public int getMetadataTimeout() {
        return this.metadataTimeout;
    }

    public String getRtspHost() {
        return this.rtspHost;
    }

    public void setHost(String rtspHost) {
        this.rtspHost = rtspHost;
    }

    public StreamingVideoSourceClientRTSP getStreamingVideoSourceClientRtsp() {
        return this.streamingVideoSourceClientRtsp;
    }

    public boolean haveToExecuteOperationAfterDescribe() {
        return this.executeOperationAfterDescribe;
    }

    public boolean haveToExecuteOperationAfterSetup() {
        return this.executeOperationAfterSetup;
    }

    public boolean haveToExecuteOperationAfterPlay() {
        return this.executeOperationAfterPlay;
    }

    public final boolean isStartAllTrackIds() {
        return this.startAllTrackIds;
    }

    public final void setStartAllTrackIds(boolean startAllTrackIds) {
        this.startAllTrackIds = startAllTrackIds;
    }

    public long getWaitingTime() {
        return this.waitingTime;
    }

    boolean getKeepAliveForTimeouts() {
        return this.keepAliveForTimeouts;
    }

    public void setKeepAliveForTimeouts(boolean keepAliveForTimeouts) {
        this.keepAliveForTimeouts = keepAliveForTimeouts;
    }

    public boolean useHTTPPersistentDuplexTunnel() {
        return this.useHTTPPersistentDuplexTunnel;
    }

    public boolean useAuthenticationForHTTPTunnel() {
        return this.useAuthenticationForHTTPTunnel;
    }

    public boolean isBasicAuthenticationDisabled() {
        return this.basicAuthenticationDisabled;
    }

    public void disableBasicAuthentication() {
        this.basicAuthenticationDisabled = true;
    }

    public int init(RTSPHandlerIntf callback, NetworkParameter networkParameter, int rtspPort, String rtspUrl, boolean printDebug, TransmissionType transmissionID) {
        return this.init(callback, networkParameter, rtspPort, rtspUrl, printDebug, transmissionID, networkParameter.getSoTimeout());
    }

    public int init(RTSPHandlerIntf callback, NetworkParameter networkParameter, int rtspPort, String rtspUrl, boolean printDebug, TransmissionType transmissionID, int timeOut) {
        return this.init(callback, null, networkParameter, rtspPort, rtspUrl, printDebug, transmissionID, timeOut);
    }

    public int init(RTSPHandlerIntf callback, RTSPHandlerIntf audioHandlerCallback, NetworkParameter networkParameter, int rtspPort, String rtspUrl, boolean printDebug, TransmissionType transmissionID, int timeOut) {
        return this.init(callback, audioHandlerCallback, networkParameter, rtspPort, rtspUrl, printDebug, transmissionID, timeOut, false);
    }

    public int init(RTSPHandlerIntf callback, RTSPHandlerIntf audioHandlerCallback, NetworkParameter networkParameter, int rtspPort, String rtspUrl, boolean printDebug, TransmissionType transmissionID, int timeOut, boolean isAudioEnabled) {
        return this.init(callback, audioHandlerCallback, networkParameter, rtspPort, rtspUrl, printDebug, transmissionID, timeOut, isAudioEnabled, 5);
    }

    public int init(RTSPHandlerIntf callback, RTSPHandlerIntf audioHandlerCallback, NetworkParameter networkParameter, int rtspPort, String rtspUrl, boolean printDebug, TransmissionType transmissionID, int timeOut, boolean isAudioEnabled, int keepAliveMethod) {
        return this.init(callback, audioHandlerCallback, networkParameter, rtspPort, rtspUrl, printDebug, transmissionID, timeOut, isAudioEnabled, keepAliveMethod, rtspUrl);
    }

    public int init(RTSPHandlerIntf callback, RTSPHandlerIntf audioHandlerCallback, NetworkParameter networkParameter, int rtspPort, String rtspUrl, boolean printDebug, TransmissionType transmissionID, int timeOut, boolean isAudioEnabled, int keepAliveMethod, String keepAliveUrl, Boolean useHTTPPersistentDuplexTunnel) {
        this.useHTTPPersistentDuplexTunnel = useHTTPPersistentDuplexTunnel;
        return this.init(callback, audioHandlerCallback, networkParameter, rtspPort, rtspUrl, printDebug, transmissionID, timeOut, isAudioEnabled, keepAliveMethod, keepAliveUrl);
    }

    public int init(RTSPHandlerIntf callback, RTSPHandlerIntf audioHandlerCallback, NetworkParameter networkParameter, int rtspPort, String rtspUrl, boolean printDebug, TransmissionType transmissionID, int timeOut, boolean isAudioEnabled, int keepAliveMethod, String keepAliveUrl, Boolean useHTTPPersistentDuplexTunnel, Boolean useAuthenticationForHTTPTunnel) {
        this.useAuthenticationForHTTPTunnel = useAuthenticationForHTTPTunnel;
        return this.init(callback, audioHandlerCallback, networkParameter, rtspPort, rtspUrl, printDebug, transmissionID, timeOut, isAudioEnabled, keepAliveMethod, keepAliveUrl, useHTTPPersistentDuplexTunnel);
    }

    public int init(RTSPHandlerIntf callback, RTSPHandlerIntf audioHandlerCallback, NetworkParameter networkParameter, int rtspPort, String rtspUrl, boolean printDebug, TransmissionType transmissionID, int timeOut, boolean isAudioEnabled, int keepAliveMethod, String keepAliveUrl) {
        if (callback == null || networkParameter == null || rtspUrl == null) {
            return -21601;
        }
        if (callback instanceof StreamingVideoSourceClientRTSP) {
            StreamingVideoSourceClientRTSP streamingVideoSourceClientRTSP = (StreamingVideoSourceClientRTSP)callback;
            streamingVideoSourceClientRTSP.publishRTSPUrl(rtspUrl);
            this.streamingVideoSourceClientRtsp = streamingVideoSourceClientRTSP;
        }
        this.callback = callback;
        this.audioHandlerCallback = audioHandlerCallback;
        this.isAudioEnabled = isAudioEnabled;
        this.networkParameter = networkParameter;
        this.rtspUrl = rtspUrl;
        this.timeOut = timeOut;
        this.printDebug = printDebug;
        this.transmissionID = transmissionID;
        this.keepAliveMethod = keepAliveMethod;
        this.keepAliveUrl = keepAliveUrl;
        this.rtspPort = rtspPort;
        return 0;
    }

    public void arrangeFurtherOperations(boolean executeOperationAfterDescribe, boolean executeOperationAfterSetup, boolean executeOperationAfterPlay) {
        this.executeOperationAfterDescribe = executeOperationAfterDescribe;
        this.executeOperationAfterSetup = executeOperationAfterSetup;
        this.executeOperationAfterPlay = executeOperationAfterPlay;
    }

    public RTSPHandlerSuper getRTSPHandler() throws SeeTecException {
        RTSPHandlerSuper rtspHandler = this.transmissionID == TransmissionType.RTP_OVER_RTSP_OVER_HTTP_UNICAST ? new RTSPHandlerHTTP() : (this.transmissionID == TransmissionType.RTP_OVER_RTSP_OVER_TCP ? new RTSPHandlerTCP() : (this.transmissionID == TransmissionType.RTP_OVER_UDP_MULTICAST ? new RTSPHandlerUDPMulticast() : new RTSPHandlerUDP()));
        this.errorCode = ((RTSPHandlerSuper)rtspHandler).init(this);
        if (this.errorCode != 0) {
            throw new SeeTecException(this.errorCode, "Could not initialize RTSP Handling");
        }
        return rtspHandler;
    }

    public void setFrames(String all) {
        this.frames = all;
    }

    public String getFrames() {
        return this.frames;
    }

    public Codec getPlaybackCodec() {
        return this.playbackCodec;
    }

    public void setPlaybackCodec(Codec playbackCodec) {
        this.playbackCodec = playbackCodec;
    }

    public void setTransmissionID(TransmissionType transmissionID) {
        this.transmissionID = transmissionID;
    }

    public void setRequireField(String requireField) {
        this.requireField = requireField;
    }

    public boolean isEdgeStoragePlayback() {
        return this.isEdgeStoragePlayback;
    }

    public void setIsEdgeStoragePlayback(boolean isPlayback) {
        this.isEdgeStoragePlayback = isPlayback;
    }

    public void setShutdownOnKeepAliveError(boolean shutdownOnKeepAliveError) {
        this.shutdownOnKeepAliveError = shutdownOnKeepAliveError;
    }

    boolean isShutdownOnKeepAliveError() {
        return this.shutdownOnKeepAliveError;
    }

    public int getRtspPortFromUrl(String url) throws MalformedURLException {
        String urlAsHttp = url.replace("rtsp://", "http://");
        return new URL(urlAsHttp).getPort();
    }
}

