/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared.net.rtsp;

import de.seetec.v5.re.cm.DMConstantsIntf;
import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPConstantsIntf;
import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPStreamSettings;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.SSLConstantsIntf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RTSPResponse
implements SSLConstantsIntf,
RTSPConstantsIntf,
DMConstantsIntf {
    protected Logger logger = null;
    private String lineDelimiter = "\r\n";
    private String data = null;
    private int errorCode = Integer.MIN_VALUE;
    private String sessionID = null;
    private String contentBase = null;
    private int timeout = Integer.MIN_VALUE;
    private String ssrc = null;
    private String destination = null;
    private String realm = null;
    private String nonce = null;
    private int secondServerPort = Integer.MIN_VALUE;
    private int firstServerPort;
    private int authenticationMethod;
    private byte[] videoParameterSet = null;
    private byte[] sequenceParameterSet = null;
    private byte[] pictureParameterSet = null;
    private int[] multicastPorts = null;
    private final HashMap<String, List<String>> setupUrls = new HashMap();
    private int channelIdentifier = -1;
    private Codec codec = null;
    private boolean hasBody;
    private int[] options;
    private int multicastClientPort = 0;
    private double scale;

    public RTSPResponse() {
        this.logger = LogManager.getLogger((String)this.getClass().getName());
    }

    public RTSPResponse(int code) {
        this.logger = LogManager.getLogger((String)this.getClass().getName());
        this.errorCode = code;
    }

    RTSPResponse(byte[] response, RTSPStreamSettings rtspSettings) {
        this.logger = LogManager.getLogger((String)this.getClass().getName());
        if (this.deserialize(response, rtspSettings) != 0) {
            this.errorCode = -21659;
        }
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getData() {
        return this.data;
    }

    public double getScale() {
        return this.scale;
    }

    public String getSessionID() {
        return this.sessionID;
    }

    public String getContentBase() {
        return this.contentBase;
    }

    public int getResponseTimeout() {
        return this.timeout;
    }

    public String getRealm() {
        return this.realm;
    }

    public String getNonce() {
        return this.nonce;
    }

    public int getAuthenticationMethod() {
        return this.authenticationMethod;
    }

    public byte[] getVideoParameterSet() {
        byte[] response = new byte[this.videoParameterSet.length];
        System.arraycopy(this.videoParameterSet, 0, response, 0, this.videoParameterSet.length);
        return response;
    }

    public byte[] getSequenceParameterSet() {
        if (this.sequenceParameterSet == null) {
            return new byte[0];
        }
        byte[] response = new byte[this.sequenceParameterSet.length];
        System.arraycopy(this.sequenceParameterSet, 0, response, 0, this.sequenceParameterSet.length);
        return response;
    }

    public byte[] getPictureParameterSet() {
        if (this.pictureParameterSet == null) {
            return new byte[0];
        }
        byte[] response = new byte[this.pictureParameterSet.length];
        System.arraycopy(this.pictureParameterSet, 0, response, 0, this.pictureParameterSet.length);
        return response;
    }

    public int getSecondServerPort() {
        return this.secondServerPort;
    }

    public int getFirstServerPort() {
        return this.firstServerPort;
    }

    public String getLineDelimiter() {
        return this.lineDelimiter;
    }

    public String getMulticastAddress() {
        return this.destination;
    }

    public int[] getMulticastPort() {
        int[] response = new int[this.multicastPorts.length];
        System.arraycopy(this.multicastPorts, 0, response, 0, this.multicastPorts.length);
        return response;
    }

    public int getMulticastClientPort() {
        return this.multicastClientPort;
    }

    public String getSSRC() {
        if (this.ssrc == null || this.ssrc.equals("0") || this.ssrc.isEmpty()) {
            return null;
        }
        return this.ssrc;
    }

    public List<String> getSetupUrls(String mediaType, String rtspUrl, String host) {
        if (this.setupUrls.get(mediaType) == null) {
            return null;
        }
        ArrayList<String> setupUrlList = new ArrayList<String>();
        for (String setupUrl : this.setupUrls.get(mediaType)) {
            String currentSetupUrl = setupUrl;
            if (!currentSetupUrl.toLowerCase().contains("rtsp://") && !currentSetupUrl.toLowerCase().contains("http://")) {
                if (this.contentBase != null) {
                    rtspUrl = this.contentBase;
                }
                if (rtspUrl.endsWith("/") && currentSetupUrl.startsWith("/")) {
                    currentSetupUrl = currentSetupUrl.substring(1);
                }
                if (!rtspUrl.endsWith("/") && !currentSetupUrl.startsWith("/")) {
                    currentSetupUrl = "/" + currentSetupUrl;
                }
                setupUrlList.add(rtspUrl + currentSetupUrl);
                continue;
            }
            setupUrlList.add(currentSetupUrl);
        }
        return setupUrlList;
    }

    protected List<String> readTrackIds(String[] body, String mediaType, Codec codec) {
        int i;
        ArrayList<String> trackIds = new ArrayList<String>();
        ArrayList<String> lineList = new ArrayList<String>();
        for (String body1 : body) {
            String[] linesSplittedByCR;
            for (String linesSplittedByCR1 : linesSplittedByCR = body1.split("\r")) {
                String[] linesSplittedByLF = linesSplittedByCR1.split("\n");
                lineList.addAll(Arrays.asList(linesSplittedByLF));
            }
        }
        String[] lines = new String[lineList.size()];
        for (int i2 = 0; i2 < lines.length; ++i2) {
            lines[i2] = (String)lineList.get(i2);
        }
        int numberOfMediaSection = 0;
        if (codec == null) {
            block3: for (i = 1; i < lines.length; ++i) {
                if (!lines[i].contains("m=" + mediaType)) continue;
                ++numberOfMediaSection;
                for (int j = i + 1; j < lines.length; ++j) {
                    int index = lines[j].indexOf("a=control:");
                    if (index == -1) continue;
                    trackIds.add(lines[j].substring(index + 10));
                    continue block3;
                }
            }
        } else {
            for (i = 1; i < lines.length; ++i) {
                if (!lines[i].contains("m=" + mediaType)) continue;
                ++numberOfMediaSection;
                block6: for (int j = i + 1; j < lines.length && !lines[j].contains("m="); ++j) {
                    if ((codec != Codec.MJPEG || !lines[j].toLowerCase().contains("jpeg")) && !lines[j].toLowerCase().contains(codec.name().toLowerCase())) continue;
                    for (int k = i + 1; k < lines.length; ++k) {
                        int index = lines[k].indexOf("a=control:");
                        if (index == -1) continue;
                        trackIds.add(lines[k].substring(index + 10));
                        continue block6;
                    }
                }
            }
        }
        if (numberOfMediaSection == 1 && trackIds.isEmpty()) {
            for (String line : lines) {
                int index = line.indexOf("a=control:");
                if (index == -1) continue;
                trackIds.add(line.substring(index + 10));
            }
        }
        return trackIds;
    }

    public int getChannelIdentifier() {
        return this.channelIdentifier;
    }

    public Codec getCodec() {
        return this.codec;
    }

    public boolean isHasBody() {
        return this.hasBody;
    }

    public int[] getOptions() {
        int[] response;
        if (this.options != null) {
            response = new int[this.options.length];
            System.arraycopy(this.options, 0, response, 0, this.options.length);
        } else {
            response = new int[]{};
        }
        return response;
    }

    public final int deserialize(byte[] data, RTSPStreamSettings rtspSettings) {
        if (data != null) {
            this.data = new String(data);
            this.lineDelimiter = new String(data).contains("\r\n\r\n") ? "\r\n" : "\n";
            String[] headerAndBody = new String(data).split(this.lineDelimiter + this.lineDelimiter);
            this.deserializeHeader(headerAndBody[0]);
            if (headerAndBody.length == 2) {
                this.hasBody = true;
                this.deserializeBody(headerAndBody[1], rtspSettings);
            }
            return 0;
        }
        return -21659;
    }

    private void deserializeBody(String data, RTSPStreamSettings rtspSettings) {
        if (data != null) {
            String[] mediaTypes;
            if (!data.contains(this.lineDelimiter)) {
                this.lineDelimiter = data.contains("\r\n\r\n") ? "\r\n" : "\n";
            }
            String[] lines = data.split(this.lineDelimiter);
            for (int i = 1; i < lines.length; ++i) {
                int endPos;
                String[] parseLine = lines[i].split("rtpmap:");
                if (parseLine.length == 2) {
                    if (parseLine[1].toLowerCase().contains("mp4v")) {
                        this.codec = Codec.MPEG4;
                    } else if (parseLine[1].toLowerCase().contains("h264")) {
                        this.codec = this.codec != null && this.codec != Codec.H264 ? Codec.UNKNOWN : Codec.H264;
                    } else if (parseLine[1].toLowerCase().contains("h265")) {
                        this.codec = this.codec != null && this.codec != Codec.H265 ? Codec.UNKNOWN : Codec.H265;
                    } else if (parseLine[1].toLowerCase().contains("jpeg")) {
                        this.codec = Codec.MJPEG;
                    }
                }
                if (this.codec == null && (parseLine = lines[i].split("a=x-qt-text-inf:")).length == 2) {
                    if (parseLine[1].toLowerCase().contains("h264")) {
                        this.codec = Codec.H264;
                    }
                    if (parseLine[1].toLowerCase().contains("h265")) {
                        this.codec = Codec.H265;
                    }
                    if (parseLine[1].toLowerCase().contains("jpeg")) {
                        this.codec = Codec.MJPEG;
                    }
                }
                if (this.codec == null && (parseLine = lines[i].split("a=x-qt-text-inf:")).length == 2) {
                    if (parseLine[1].toLowerCase().contains("h264")) {
                        this.codec = Codec.H264;
                    }
                    if (parseLine[1].toLowerCase().contains("h265")) {
                        this.codec = Codec.H265;
                    }
                    if (parseLine[1].toLowerCase().contains("jpeg")) {
                        this.codec = Codec.MJPEG;
                    }
                }
                if ((parseLine = lines[i].split("m=video ")).length == 2) {
                    try {
                        String[] mVideo = parseLine[1].split(" ");
                        if (mVideo.length > 0) {
                            this.multicastClientPort = Integer.parseInt(mVideo[0]);
                        }
                    }
                    catch (Exception mVideo) {
                        // empty catch block
                    }
                }
                if ((parseLine = lines[i].split("sprop-parameter-sets=")).length == 2) {
                    String[] spropParameterSetsCommaSeparated;
                    int indexOfSemicolon = parseLine[1].indexOf(";");
                    String spropParameterSetsOnly = parseLine[1];
                    if (indexOfSemicolon != -1) {
                        spropParameterSetsOnly = parseLine[1].substring(0, indexOfSemicolon);
                    }
                    if ((spropParameterSetsCommaSeparated = spropParameterSetsOnly.split(",")).length != 2 && spropParameterSetsOnly.contains("/")) {
                        spropParameterSetsCommaSeparated = spropParameterSetsOnly.split("/");
                    }
                    try {
                        if (spropParameterSetsCommaSeparated[0] != null) {
                            this.sequenceParameterSet = Base64.getDecoder().decode(spropParameterSetsCommaSeparated[0]);
                        }
                        if (spropParameterSetsCommaSeparated.length < 2 || spropParameterSetsCommaSeparated[1] == null) continue;
                        this.pictureParameterSet = Base64.getDecoder().decode(spropParameterSetsCommaSeparated[1].replace(";", ""));
                    }
                    catch (Exception ex) {
                        this.logger.warn("Exception while trying to parse Sequence Parameter Set or Picture Parameter Set. Will continue anyway for " + this);
                    }
                    continue;
                }
                if (lines[i].contains("sprop-vps=")) {
                    int startPos = lines[i].indexOf("sprop-vps=") + "sprop-vps=".length();
                    endPos = lines[i].indexOf(";", startPos);
                    String vpsData = lines[i].substring(startPos, endPos < 0 ? lines[i].length() : endPos);
                    this.videoParameterSet = Base64.getDecoder().decode(vpsData);
                }
                if (lines[i].contains("sprop-sps=")) {
                    int startPos = lines[i].indexOf("sprop-sps=") + "sprop-sps=".length();
                    endPos = lines[i].indexOf(";", startPos);
                    String spsData = lines[i].substring(startPos, endPos < 0 ? lines[i].length() : endPos);
                    this.sequenceParameterSet = Base64.getDecoder().decode(spsData);
                }
                if (lines[i].contains("sprop-pps=")) {
                    int startPos = lines[i].indexOf("sprop-pps=") + "sprop-pps=".length();
                    endPos = lines[i].indexOf(";", startPos);
                    String ppsData = lines[i].substring(startPos, endPos < 0 ? lines[i].length() : endPos);
                    this.pictureParameterSet = Base64.getDecoder().decode(ppsData);
                }
                if ((parseLine = lines[i].split("config=")).length != 2 || this.sequenceParameterSet != null) continue;
                this.sequenceParameterSet = Basic.hexStringToByteArray((String)parseLine[1]);
            }
            if (this.codec == Codec.UNKNOWN) {
                this.codec = this.parseSdpWithSeveralCodecs(data, this.lineDelimiter);
            }
            if (this.codec == null) {
                this.codec = rtspSettings.getCodec() != null ? rtspSettings.getCodec() : Codec.MJPEG;
            }
            for (String mediaType : mediaTypes = new String[]{"audio", "video", "text", "application", "message", "metadata"}) {
                List<String> trackIds = this.readTrackIds(lines, mediaType, rtspSettings.getPlaybackCodec());
                this.setupUrls.put(mediaType, trackIds);
            }
        }
    }

    private void deserializeHeader(String data) {
        if (data != null) {
            String[] lines;
            if (data.startsWith("\r\n")) {
                data = data.substring(2);
            }
            if ((lines = data.split(this.lineDelimiter)).length >= 1) {
                block45: {
                    String[] firstLineSplit = lines[0].split(" ");
                    if (firstLineSplit.length >= 3) {
                        try {
                            this.errorCode = Integer.parseInt(firstLineSplit[1]);
                        }
                        catch (NumberFormatException e) {
                            if (data.length() > 50) {
                                this.logger.error("Error when converting RTSP Statuscode to number. Statuscode = \"" + firstLineSplit[1] + "\". Header: " + data.substring(0, 50));
                                break block45;
                            }
                            this.logger.error("Error when converting RTSP Statuscode to number. Statuscode = \"" + firstLineSplit[1] + "\". Header: " + data);
                        }
                    } else {
                        this.logger.warn("First line of RTSP-response not valid");
                        this.logger.warn("First line: " + lines[0]);
                        if (data.length() > 50) {
                            this.logger.warn("Received data: " + data.substring(0, 50));
                        } else {
                            this.logger.warn("Received data: " + data);
                        }
                    }
                }
                for (int i = 1; i < lines.length; ++i) {
                    String[] optionsLines;
                    String[] interleavedLine;
                    String[] interleavedLines;
                    int additionalInfoPos;
                    String[] ports;
                    String[] parseLine = lines[i].split("realm=\"");
                    if (parseLine.length == 2) {
                        String[] realmLine = parseLine[1].split("\"");
                        this.realm = realmLine[0];
                    }
                    if ((parseLine = lines[i].split("nonce=\"")).length == 2) {
                        String[] nonceLine = parseLine[1].split("\"");
                        this.nonce = nonceLine[0];
                    }
                    if ((parseLine = lines[i].toLowerCase().split("www-authenticate:")).length == 2) {
                        if (parseLine[1].toLowerCase().contains("digest")) {
                            this.authenticationMethod = this.authenticationMethod == 100 ? 102 : 101;
                        }
                        if (parseLine[1].toLowerCase().contains("basic")) {
                            this.authenticationMethod = this.authenticationMethod == 101 ? 102 : 100;
                        }
                    }
                    if ((parseLine = lines[i].split("Session: ")).length == 2) {
                        String[] session = parseLine[1].split(";");
                        this.sessionID = session[0];
                    }
                    if ((parseLine = lines[i].split("Scale: ")).length == 2) {
                        this.scale = Double.parseDouble(parseLine[1].trim());
                    }
                    if ((parseLine = lines[i].split("Content-Base: ")).length == 2) {
                        this.contentBase = parseLine[1];
                    }
                    if ((parseLine = lines[i].split("timeout=")).length == 2) {
                        try {
                            this.timeout = Integer.parseInt(parseLine[1].trim());
                        }
                        catch (NumberFormatException nfe) {
                            this.logger.warn("Error while converting '" + parseLine[1] + "' into a number while reading session timeout.Using default timeout.");
                        }
                    }
                    if ((parseLine = lines[i].split("server_port=")).length == 2) {
                        ports = parseLine[1].split("-");
                        additionalInfoPos = ports[1].indexOf(";");
                        if (additionalInfoPos != -1) {
                            ports[1] = ports[1].substring(0, additionalInfoPos);
                        }
                        try {
                            this.secondServerPort = Integer.parseInt(ports[1]);
                            this.firstServerPort = Integer.parseInt(ports[0]);
                        }
                        catch (NumberFormatException nfe) {
                            this.logger.error("Error while converting '" + parseLine[1] + " into a number.");
                        }
                    }
                    if ((parseLine = lines[i].split("destination=")).length == 2) {
                        String[] dest = parseLine[1].split(";");
                        this.destination = dest[0];
                        this.logger.info("destination: " + this.destination);
                    }
                    if ((parseLine = lines[i].split("port=")).length == 2) {
                        ports = parseLine[1].split("-");
                        additionalInfoPos = ports[1].indexOf(";");
                        if (additionalInfoPos != -1) {
                            ports[1] = ports[1].substring(0, additionalInfoPos);
                        }
                        try {
                            this.multicastPorts = new int[2];
                            this.multicastPorts[0] = Integer.parseInt(ports[0]);
                            this.multicastPorts[1] = Integer.parseInt(ports[1]);
                            this.logger.info("Received multicast port pair: " + this.multicastPorts[0] + "-" + this.multicastPorts[1]);
                        }
                        catch (NumberFormatException nfe) {
                            this.logger.error("Error while converting '" + ports[0] + "and " + ports[1] + " into a number.");
                        }
                    }
                    if ((parseLine = lines[i].split("ssrc=")).length == 2) {
                        String[] ssrcParts = parseLine[1].split(";");
                        this.ssrc = ssrcParts[0];
                    }
                    if ((parseLine = lines[i].split("interleaved=")).length >= 2 && (interleavedLines = parseLine[parseLine.length - 1].split(";")).length > 0 && (interleavedLine = interleavedLines[0].split("-")).length == 2) {
                        this.channelIdentifier = Integer.parseInt(interleavedLine[0]);
                    }
                    if (!lines[i].toLowerCase().contains("public: ") || (parseLine = lines[i].split(":")).length != 2 || (optionsLines = parseLine[1].split(",")).length <= 0) continue;
                    this.options = new int[optionsLines.length];
                    for (int j = 0; j < optionsLines.length; ++j) {
                        if (optionsLines[j].trim().toLowerCase().equals("describe")) {
                            this.options[j] = 5;
                            continue;
                        }
                        if (optionsLines[j].trim().toLowerCase().equals("announce")) {
                            this.options[j] = 6;
                            continue;
                        }
                        if (optionsLines[j].trim().toLowerCase().equals("pause")) {
                            this.options[j] = 7;
                            continue;
                        }
                        if (optionsLines[j].trim().toLowerCase().equals("get_parameter")) {
                            this.options[j] = 2;
                            continue;
                        }
                        if (optionsLines[j].trim().toLowerCase().equals("options")) {
                            this.options[j] = 4;
                            continue;
                        }
                        if (optionsLines[j].trim().toLowerCase().equals("play")) {
                            this.options[j] = 8;
                            continue;
                        }
                        if (optionsLines[j].trim().toLowerCase().equals("record")) {
                            this.options[j] = 9;
                            continue;
                        }
                        if (optionsLines[j].trim().toLowerCase().equals("redirect")) {
                            this.options[j] = 10;
                            continue;
                        }
                        if (optionsLines[j].trim().toLowerCase().equals("setup")) {
                            this.options[j] = 11;
                            continue;
                        }
                        if (optionsLines[j].trim().toLowerCase().equals("set_parameter")) {
                            this.options[j] = 12;
                            continue;
                        }
                        if (!optionsLines[j].trim().toLowerCase().equals("teardown")) continue;
                        this.options[j] = 13;
                    }
                }
            } else {
                this.logger.warn("The reponse header has 0 lines.");
            }
        }
    }

    protected Codec parseSdpWithSeveralCodecs(String data, String lineDelimiter) {
        String[] lines = data.split(lineDelimiter);
        String mediaFormat = "";
        Codec codec = null;
        for (String line : lines) {
            String[] mediaDescription;
            if (line.contains("m=video ") && (mediaDescription = line.split(" ")).length > 3) {
                mediaFormat = mediaDescription[3];
            }
            if (!line.contains("a=rtpmap:")) continue;
            String[] rtpMap = line.split(" ");
            if (mediaFormat.isEmpty() || !rtpMap[0].contains(mediaFormat)) continue;
            if (line.toLowerCase().contains("h264")) {
                codec = Codec.H264;
                continue;
            }
            if (line.toLowerCase().contains("h265")) {
                codec = Codec.H265;
                continue;
            }
            if (!line.toLowerCase().contains("jpeg")) continue;
            codec = Codec.MJPEG;
        }
        return codec;
    }
}

