/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared.net.rtsp;

import de.seetec.v5.re.cm.device.shared.net.rtp.RtpSenderPacket;
import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPHandlerSuper;
import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPRequest;
import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPResponse;
import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPStreamSettings;
import de.seetec.v5.re.cm.device.shared.net.rtsp.request.SetupRequest;
import de.seetec.v5.re.cm.device.shared.net.udp.UdpRTPReaderMulticast;
import de.seetec.v5.shared.Basic;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketTimeoutException;
import org.apache.logging.log4j.LogManager;

public class RTSPHandlerUDPMulticast
extends RTSPHandlerSuper {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPHandlerUDPMulticast";
    private final Object sendSemaphore = new Object();
    protected OutputStream outStream = null;
    protected InputStream inStream = null;
    protected Socket socket = null;
    protected String lineDelimiter = null;
    private long sentRequests = 0L;
    private long sentBytes = 0L;
    private long receivedResponses = 0L;
    private long receivedBytes = 0L;
    private UdpRTPReaderMulticast udpRTPReaderAudio = null;
    private UdpRTPReaderMulticast udpRTPReaderMetadata = null;
    protected UdpRTPReaderMulticast udpRTPReader = null;
    private String multicastAdress;
    private int[] multicastPort;
    private int multicastClientPort;
    private int[] multicastPortAudio;
    private String multicastAdressAudio;
    private String multicastAdressMetadata;
    private int[] multicastPortMetadata;

    public RTSPHandlerUDPMulticast() {
        this.shutdown = false;
        this.logger = LogManager.getLogger((String)CLASS_NAME);
    }

    @Override
    public int init(RTSPStreamSettings rtspSettings) {
        if (rtspSettings == null) {
            return -21601;
        }
        this.rtspSettings = rtspSettings;
        this.callback = rtspSettings.getCallback();
        this.audioHandlerCallback = rtspSettings.getAudioHandlerCallback();
        this.metadataHandlerCallback = rtspSettings.getMetadataHandlerCallback();
        this.networkParameter = rtspSettings.getNetworkParameter();
        this.printDebug = rtspSettings.isPrintDebug();
        this.isAudioEnabled = rtspSettings.isIsAudioEnabled();
        this.isMetadataEnabled = rtspSettings.isMetadataEnabled();
        this.basicAuthenticationDisabled = rtspSettings.isBasicAuthenticationDisabled();
        if (this.networkParameter == null || this.callback == null) {
            return -21601;
        }
        return this.init(this.networkParameter.getHost(), this.rtspSettings.getRTSPPort(), new String(this.networkParameter.getHttpSingleLineDelimitter()), rtspSettings.getTimeOut());
    }

    public int init(String host, int port) {
        return this.init(host, port, "\r\n");
    }

    public int init(String host, int port, String lineDelimiter) {
        return this.init(host, port, lineDelimiter, 10000);
    }

    @SuppressFBWarnings(value={"UNENCRYPTED_SOCKET"}, justification="No encryption possible for RTSP 1.")
    public int init(String host, int port, String lineDelimiter, int timeOut) {
        if (host == null || port <= 0 || port > 65535 || lineDelimiter == null) {
            return -21601;
        }
        this.lineDelimiter = lineDelimiter;
        try {
            this.socket = new Socket(host, port);
            this.socket.setSoTimeout(timeOut);
            this.socket.setReceiveBufferSize(262144);
            this.socket.setSendBufferSize(262144);
            this.logger.info(Basic.generateIndentedMultiLineLog((String[])new String[]{"   Socket            : [" + this.socket + "]", "   SoTimeout         : [" + this.socket.getSoTimeout() + "]", "   ReceiveBufferSize : [" + this.socket.getReceiveBufferSize() + "]"}));
        }
        catch (Exception e) {
            this.logger.error("Cannot connect to " + host + ":" + port, (Throwable)e);
            return -21662;
        }
        try {
            this.inStream = this.socket.getInputStream();
            this.outStream = this.socket.getOutputStream();
        }
        catch (Exception e) {
            this.logger.error("Cannot get streams from socket", (Throwable)e);
            return -21662;
        }
        return 0;
    }

    @Override
    public void shutdown() {
        block10: {
            if (this.shutdown) {
                return;
            }
            if (this.udpRTPReader != null) {
                this.udpRTPReader.shutdown();
                this.udpRTPReader = null;
            }
            if (this.udpRTPReaderAudio != null) {
                this.udpRTPReaderAudio.shutdown();
                this.udpRTPReaderAudio = null;
            }
            if (this.udpRTPReaderMetadata != null) {
                this.udpRTPReaderMetadata.shutdown();
                this.udpRTPReaderMetadata = null;
            }
            super.shutdown();
            this.shutdown = true;
            try {
                if (this.inStream != null) {
                    this.inStream.close();
                }
                if (this.outStream != null) {
                    this.outStream.close();
                }
                if (this.socket == null) break block10;
                try {
                    this.socket.close();
                }
                catch (Exception e) {
                    this.logger.error("Cannot close socket", (Throwable)e);
                }
                this.socket = null;
            }
            catch (Exception e) {
                this.logger.error("Exception closing stream", (Throwable)e);
            }
        }
    }

    @Override
    public int start() {
        super.start();
        this.udpRTPReader = new UdpRTPReaderMulticast(this.callback, this.multicastAdress, this.multicastPort[0], this.networkParameter.getLocalServerAddress());
        this.udpRTPReader.init(524288, this.networkParameter.getSoTimeout(), true);
        if (this.isAudioEnabled) {
            this.udpRTPReaderAudio = new UdpRTPReaderMulticast(this.audioHandlerCallback, this.multicastAdressAudio, this.multicastPortAudio[0], this.networkParameter.getLocalServerAddress());
            this.udpRTPReaderAudio.init(524288, 5000, true);
        }
        if (this.isMetadataEnabled) {
            this.udpRTPReaderMetadata = new UdpRTPReaderMulticast(this.metadataHandlerCallback, this.multicastAdressMetadata, this.multicastPortMetadata[0], this.networkParameter.getLocalServerAddress());
            this.udpRTPReaderMetadata.init(524288, 10000, true);
        }
        return 0;
    }

    @Override
    public void run() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] send(byte[] data, boolean supressError) {
        Object object = this.sendSemaphore;
        synchronized (object) {
            return this.send(data, supressError, false);
        }
    }

    public void setLineDelimiter(String delimiter) {
        this.lineDelimiter = delimiter;
    }

    public final String getStatistics() {
        return "Send requests/bytes: " + this.sentRequests + "/" + this.sentBytes + ", Received responses/bytes: " + this.receivedResponses + "/" + this.receivedBytes;
    }

    @Override
    protected RTSPResponse sendRTSPPacket(RTSPRequest request) {
        byte[] response;
        request.setSequenceNumber(this.sequenceNumber++);
        boolean readAnswer = true;
        if (request.getCommand() == 13) {
            readAnswer = false;
        }
        if (request.getCommand() == 11 && request instanceof SetupRequest) {
            ((SetupRequest)request).setMulticastClientPort(this.multicastClientPort);
        }
        if ((response = this.send(request.serialize(), request.isSuppressError(), readAnswer)).length != 0) {
            RTSPResponse packetResponse = new RTSPResponse(response, this.rtspSettings);
            if (request.getCommand() == 5) {
                this.multicastClientPort = packetResponse.getMulticastClientPort();
            }
            if (request.getCommand() == 11) {
                if (request.isAudioSetup) {
                    if (packetResponse.getMulticastAddress() != null) {
                        this.multicastAdressAudio = packetResponse.getMulticastAddress();
                    }
                    this.multicastPortAudio = packetResponse.getMulticastPort();
                } else if (request.isMetadataSetup) {
                    if (packetResponse.getMulticastAddress() != null) {
                        this.multicastAdressMetadata = packetResponse.getMulticastAddress();
                    }
                    this.multicastPortMetadata = packetResponse.getMulticastPort();
                } else {
                    if (packetResponse.getMulticastAddress() != null) {
                        this.multicastAdress = packetResponse.getMulticastAddress();
                    }
                    this.multicastPort = packetResponse.getMulticastPort();
                }
            }
            return packetResponse;
        }
        String errorMessage = "response is null for " + this;
        this.logger.error(errorMessage);
        int errorCode = -21656;
        this.callback.onNetworkError(errorCode);
        return new RTSPResponse(errorCode);
    }

    @Override
    public int sendReceiverReportVideo(byte[] receiverReport) {
        return 0;
    }

    @Override
    public int sendReceiverReportAudio(byte[] receiverReport) {
        return 0;
    }

    @Override
    public int sendReceiverReportMetadata(byte[] receiverReport) {
        return 0;
    }

    @Override
    public int sendRTPPacket(RtpSenderPacket audioData) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private byte[] send(byte[] data, boolean supressError, boolean readAnswer) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
        byte[] buffer = new byte[4096];
        int contentLength = -1;
        int startPos = -1;
        long bytesOfContentRead = 0L;
        if (this.shutdown) {
            return new byte[0];
        }
        try {
            int len;
            long now;
            long timeRequestSent = System.currentTimeMillis();
            this.outStream.write(data);
            this.outStream.flush();
            ++this.sentRequests;
            if (data != null) {
                this.sentBytes += (long)data.length;
            }
            if ((now = System.currentTimeMillis()) > timeRequestSent + 10000L) {
                this.logger.warn("Long delay while sending RTSP request: " + (now - timeRequestSent) + "ms.");
            }
            while (readAnswer && (len = this.inStream.read(buffer, 0, buffer.length)) > 0) {
                if (len <= 0) continue;
                ++this.receivedResponses;
                this.receivedBytes += (long)len;
                baos.write(buffer, 0, len);
                String tmp = new String(buffer).toLowerCase();
                if (tmp.toLowerCase().contains("unauthorized")) break;
                if (tmp.contains("content-length:")) {
                    startPos = tmp.indexOf("content-length:") + "content-length:".length();
                    int startOfContent = tmp.indexOf(this.lineDelimiter + this.lineDelimiter) + this.lineDelimiter.length() + this.lineDelimiter.length();
                    bytesOfContentRead = len - startOfContent;
                    try {
                        contentLength = Integer.parseInt(tmp.substring(startPos, tmp.indexOf(this.lineDelimiter, startPos)).trim());
                    }
                    catch (NumberFormatException nfe) {
                        this.logger.error("Can't convert content-length into number: " + nfe.getMessage(), (Throwable)nfe);
                    }
                } else {
                    long l = bytesOfContentRead = startPos != -1 ? bytesOfContentRead + (long)len : bytesOfContentRead;
                }
                if ((startPos == -1 || bytesOfContentRead < (long)contentLength) && (!baos.toString().endsWith(this.lineDelimiter + this.lineDelimiter) || startPos != -1)) continue;
                break;
            }
            return baos.toByteArray();
        }
        catch (SocketTimeoutException ste) {
            this.logger.warn("SOTimeout reached. Aborting RTSPHandler.");
            return new byte[0];
        }
        catch (Exception e) {
            if (this.shutdown) {
                return new byte[0];
            }
            if (supressError) {
                this.logger.info("Auto-generated RTSP answer cause Camera didn't send one.");
                return "RTSP/1.0 200 OK\r\n\r\n".getBytes();
            }
            this.logger.error("Exception writing to network", (Throwable)e);
            return new byte[0];
        }
    }
}

