/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared.net.rtsp;

import de.seetec.v5.re.cm.device.shared.net.rtp.RtpSenderPacket;
import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPHandlerSuper;
import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPRequest;
import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPResponse;
import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPStreamSettings;
import de.seetec.v5.re.cm.device.shared.net.rtsp.request.SetupRequest;
import de.seetec.v5.re.cm.device.shared.net.udp.UdpRTPReaderUnicast;
import de.seetec.v5.re.cm.device.shared.net.udp.UdpWriterUnicast;
import de.seetec.v5.re.cm.device.shared.net.udp.UdpWriterUnicastBackChannel;
import de.seetec.v5.shared.Basic;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import org.apache.logging.log4j.LogManager;

public class RTSPHandlerUDP
extends RTSPHandlerSuper {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPHandlerSuper";
    protected OutputStream outStream = null;
    protected InputStream inStream = null;
    protected Socket socket = null;
    protected String lineDelimiter = null;
    protected UdpWriterUnicast udpRTCPWriter;
    protected UdpRTPReaderUnicast udpRTCPReader;
    protected UdpRTPReaderUnicast udpRTCPReaderAudio;
    protected UdpRTPReaderUnicast udpRTCPReaderMetadata;
    protected UdpRTPReaderUnicast udpReader = null;
    private final Object sendSemaphore = new Object();
    private long sentRequests = 0L;
    private long sentBytes = 0L;
    private long receivedResponses = 0L;
    private long receivedBytes = 0L;
    private UdpRTPReaderUnicast udpReaderAudio = null;
    private UdpRTPReaderUnicast udpReaderMetadata = null;
    private UdpWriterUnicast udpRTCPWriterAudio;
    private UdpWriterUnicast udpRTCPWriterMetadata;
    private int secondServerPort = -1;
    private int audioServerPort = -1;
    private int metadataServerPort = -1;
    private int rtspPort = -1;
    private boolean isVideoEnabled;
    private UdpWriterUnicastBackChannel udpWriterBackChannel;
    private int audioBackChannelServerPort;

    public RTSPHandlerUDP() {
        this.shutdown = false;
        this.logger = LogManager.getLogger((String)CLASS_NAME);
    }

    @Override
    public int init(RTSPStreamSettings rtspSettings) {
        if (rtspSettings == null) {
            return -21601;
        }
        this.rtspSettings = rtspSettings;
        this.callback = rtspSettings.getCallback();
        this.audioHandlerCallback = rtspSettings.getAudioHandlerCallback();
        this.metadataHandlerCallback = rtspSettings.getMetadataHandlerCallback();
        this.networkParameter = rtspSettings.getNetworkParameter();
        this.printDebug = rtspSettings.isPrintDebug();
        this.isAudioEnabled = rtspSettings.isIsAudioEnabled();
        this.isVideoEnabled = rtspSettings.isVideoEnabled();
        this.isMetadataEnabled = rtspSettings.isMetadataEnabled();
        this.isBackChannelEnabled = rtspSettings.isIsBackChannelEnabled();
        this.basicAuthenticationDisabled = rtspSettings.isBasicAuthenticationDisabled();
        this.backChannelCallback = rtspSettings.getBackChannelCallback();
        if (this.networkParameter == null || this.callback == null) {
            return -21601;
        }
        this.rtspPort = this.rtspSettings.getRTSPPort() != -1 ? this.rtspSettings.getRTSPPort() : 554;
        return this.init(this.networkParameter.getHost(), new String(this.networkParameter.getHttpSingleLineDelimitter()), this.networkParameter.getSoTimeout());
    }

    public int init(String host) {
        return this.init(host, "\r\n");
    }

    public int init(String host, String lineDelimiter) {
        return this.init(host, lineDelimiter, 10000);
    }

    @Override
    public int sendRTPPacket(RtpSenderPacket audioData) {
        try {
            if (this.udpWriterBackChannel == null) {
                this.udpWriterBackChannel = new UdpWriterUnicastBackChannel(this.udpReaderAudio.getSocket(), this.audioBackChannelServerPort);
            }
            this.udpWriterBackChannel.send(audioData.getData(), InetAddress.getByName(this.networkParameter.getHost()), this.audioBackChannelServerPort);
        }
        catch (Exception ex) {
            return -20100;
        }
        return 0;
    }

    @SuppressFBWarnings(value={"UNENCRYPTED_SOCKET"}, justification="No encryption possible for RTSP 1.")
    private int init(String host, String lineDelimiter, int timeOut) {
        if (this.rtspSettings.getRtspHost() != null) {
            host = this.rtspSettings.getRtspHost();
        }
        if (host == null || this.rtspPort <= 0 || this.rtspPort > 65535 || lineDelimiter == null) {
            return -21601;
        }
        this.lineDelimiter = lineDelimiter;
        try {
            this.socket = new Socket(host, this.rtspPort);
            this.socket.setSoTimeout(timeOut);
            this.socket.setReceiveBufferSize(262144);
            this.socket.setSendBufferSize(262144);
            this.logger.info(Basic.generateIndentedMultiLineLog((String[])new String[]{"   Socket            : [" + this.socket + "]", "   SoTimeout         : [" + this.socket.getSoTimeout() + "]", "   ReceiveBufferSize : [" + this.socket.getReceiveBufferSize() + "]"}));
        }
        catch (Exception e) {
            this.logger.error("Cannot connect to " + host + ":" + this.rtspPort, (Throwable)e);
            return -21662;
        }
        try {
            this.inStream = this.socket.getInputStream();
            this.outStream = this.socket.getOutputStream();
        }
        catch (Exception e) {
            this.logger.error("Cannot get streams from socket", (Throwable)e);
            return -21662;
        }
        if (this.isVideoEnabled) {
            this.udpReader = new UdpRTPReaderUnicast(this.callback);
            this.udpReader.init(524288, this.rtspSettings.getTimeOut(), true, this.rtspSettings.getUdpBuffer());
            this.logger.info("UDP port '" + this.udpReader.getPort() + "' opened for " + this.callback);
        }
        if (this.isAudioEnabled) {
            this.udpReaderAudio = new UdpRTPReaderUnicast(this.audioHandlerCallback);
            this.udpReaderAudio.init(524288, this.rtspSettings.getTimeOut(), true);
            this.logger.info("UDP audio port '" + this.udpReaderAudio.getPort() + "' opened for " + this.audioHandlerCallback);
        }
        if (this.isMetadataEnabled) {
            this.udpReaderMetadata = new UdpRTPReaderUnicast(this.metadataHandlerCallback);
            this.udpReaderMetadata.init(524288, this.rtspSettings.getMetadataTimeout(), true);
            this.logger.info("UDP metadata port '" + this.udpReaderMetadata.getPort() + "' opened for " + this.metadataHandlerCallback);
        }
        if (this.isBackChannelEnabled) {
            try {
                this.udpWriterBackChannel = new UdpWriterUnicastBackChannel(null, this.udpReaderAudio.getPort() + 2);
            }
            catch (Exception ex) {
                this.logger.error("Exception while starting UDP Writer for " + this);
            }
        }
        return 0;
    }

    @Override
    public void shutdown() {
        block15: {
            if (this.shutdown) {
                return;
            }
            if (this.udpRTCPWriter != null) {
                this.udpRTCPWriter.shutdown();
                this.udpRTCPWriter = null;
            }
            if (this.udpRTCPReader != null) {
                this.udpRTCPReader.shutdown();
                this.udpRTCPReader = null;
            }
            if (this.udpRTCPReaderAudio != null) {
                this.udpRTCPReaderAudio.shutdown();
                this.udpRTCPReaderAudio = null;
            }
            if (this.udpRTCPReaderMetadata != null) {
                this.udpRTCPReaderMetadata.shutdown();
                this.udpRTCPReaderMetadata = null;
            }
            if (this.udpReader != null) {
                this.udpReader.shutdown();
                this.udpReader = null;
            }
            if (this.udpReaderAudio != null) {
                this.udpReaderAudio.shutdown();
                this.udpReaderAudio = null;
            }
            if (this.udpReaderMetadata != null) {
                this.udpReaderMetadata.shutdown();
                this.udpReaderMetadata = null;
            }
            if (this.udpWriterBackChannel != null) {
                this.udpWriterBackChannel.shutdown();
                this.udpWriterBackChannel = null;
            }
            super.shutdown();
            this.shutdown = true;
            try {
                if (this.inStream != null) {
                    this.inStream.close();
                }
                if (this.outStream != null) {
                    this.outStream.close();
                }
                if (this.socket == null) break block15;
                try {
                    this.socket.close();
                }
                catch (Exception e) {
                    this.logger.error("Cannot close socket", (Throwable)e);
                }
                this.socket = null;
            }
            catch (Exception e) {
                this.logger.error("Exception closing stream", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] send(byte[] data, boolean supressError) {
        Object object = this.sendSemaphore;
        synchronized (object) {
            return this.send(data, supressError, false);
        }
    }

    public final String getStatistics() {
        return "Send requests/bytes: " + this.sentRequests + "/" + this.sentBytes + ", Received responses/bytes: " + this.receivedResponses + "/" + this.receivedBytes;
    }

    @Override
    protected RTSPResponse sendRTSPPacket(RTSPRequest request) {
        byte[] response;
        request.setSequenceNumber(this.sequenceNumber++);
        boolean readAnswer = true;
        if (request.getCommand() == 13) {
            readAnswer = false;
        }
        if (request.getCommand() == 11) {
            int udpPort = -1;
            if (request.isVideoSetup) {
                udpPort = this.udpReader.getPort();
            }
            if (request.isAudioSetup) {
                udpPort = this.udpReaderAudio.getPort();
            } else if (request.isMetadataSetup) {
                udpPort = this.udpReaderMetadata.getPort();
            } else if (request.isBackChannelEnabled) {
                udpPort = this.udpWriterBackChannel.getLocalPort();
            }
            if (request instanceof SetupRequest) {
                ((SetupRequest)request).setUdpPort(udpPort);
            }
        }
        if ((response = this.send(request.serialize(), request.isSuppressError(), readAnswer)).length > 0) {
            RTSPResponse packetResponse = new RTSPResponse(response, this.rtspSettings);
            if (request.isAudioSetup && packetResponse.getSecondServerPort() > 0 && this.audioServerPort < 0) {
                this.audioServerPort = packetResponse.getSecondServerPort();
                if (this.startRTCPAudio(this.audioServerPort) != 0) {
                    String errorMessage = "Error initializing RTCP for " + this;
                    this.logger.error(errorMessage);
                    int errorCode = -21656;
                    this.callback.onNetworkError(errorCode);
                    return new RTSPResponse(errorCode);
                }
            }
            if (request.isBackChannelEnabled && request instanceof SetupRequest) {
                this.audioBackChannelServerPort = packetResponse.getFirstServerPort();
            }
            if (request.isMetadataSetup && packetResponse.getSecondServerPort() > 0 && this.metadataServerPort < 0) {
                this.metadataServerPort = packetResponse.getSecondServerPort();
                if (this.startRTCPMetadata(this.metadataServerPort) != 0) {
                    String errorMessage = "Error initializing RTCP for " + this;
                    this.logger.error(errorMessage);
                    int errorCode = -21656;
                    this.callback.onNetworkError(errorCode);
                    return new RTSPResponse(errorCode);
                }
            }
            if (request.isVideoSetup && packetResponse.getSecondServerPort() > 0 && this.secondServerPort < 0) {
                this.secondServerPort = packetResponse.getSecondServerPort();
                if (this.startRTCPVideo(this.secondServerPort) != 0) {
                    String errorMessage = "Error initializing RTCP for " + this;
                    this.logger.error(errorMessage);
                    int errorCode = -21656;
                    this.callback.onNetworkError(errorCode);
                    return new RTSPResponse(errorCode);
                }
            }
            return packetResponse;
        }
        if (!readAnswer) {
            return new RTSPResponse(0);
        }
        String errorMessage = "response is null for " + this;
        this.logger.error(errorMessage);
        int errorCode = -21656;
        this.callback.onNetworkError(errorCode);
        return new RTSPResponse(errorCode);
    }

    @Override
    public int sendReceiverReportVideo(byte[] receiverReport) {
        if (receiverReport != null) {
            this.setReceiverReportVideo(new byte[receiverReport.length]);
            System.arraycopy(receiverReport, 0, this.getReceiverReportVideo(), 0, this.getReceiverReportVideo().length);
            return this.udpRTCPWriter.send(receiverReport);
        }
        return -20001;
    }

    @Override
    public int sendReceiverReportAudio(byte[] receiverReport) {
        if (receiverReport != null) {
            return this.udpRTCPWriterAudio.send(receiverReport);
        }
        return -20001;
    }

    @Override
    public int sendReceiverReportMetadata(byte[] receiverReport) {
        if (receiverReport != null) {
            return this.udpRTCPWriterMetadata.send(receiverReport);
        }
        return -20001;
    }

    @Override
    public int start() {
        int errorCode = super.start();
        if (errorCode != 0) {
            this.logger.error("Exception while starting RTSP Handling for " + this + " Error: " + errorCode);
            return errorCode;
        }
        try {
            if (this.udpReader != null) {
                this.udpReader.setSoTimeout(this.rtspSettings.getTimeOut());
            }
        }
        catch (SocketException ex) {
            this.logger.error("Exception while setting socket timeout for " + this.udpReader);
            errorCode = -21656;
        }
        return errorCode;
    }

    @Override
    public void run() {
    }

    private int startRTCPVideo(int serverPort) {
        try {
            this.udpRTCPReader = new UdpRTPReaderUnicast(this.callback, this.udpReader.getPort() + 1, InetAddress.getByName(this.networkParameter.getHost()), serverPort);
            this.udpRTCPReader.init(524288, 50000, false);
            this.udpRTCPWriter = new UdpWriterUnicast(InetAddress.getByName(this.networkParameter.getHost()), this.udpRTCPReader.getSocket(), serverPort);
        }
        catch (Exception e) {
            this.logger.error("Unable to start RTCP Reader/Writer on port " + serverPort + " for " + this.callback);
            return -21603;
        }
        return 0;
    }

    private int startRTCPAudio(int serverPort) {
        try {
            this.udpRTCPReaderAudio = new UdpRTPReaderUnicast(this.audioHandlerCallback, this.udpReaderAudio.getPort() + 1, InetAddress.getByName(this.networkParameter.getHost()), serverPort);
            this.udpRTCPReaderAudio.init(524288, 50000, false);
            this.udpRTCPWriterAudio = new UdpWriterUnicast(InetAddress.getByName(this.networkParameter.getHost()), this.udpRTCPReaderAudio.getSocket(), serverPort);
        }
        catch (Exception e) {
            this.logger.error((Object)e, (Throwable)e);
            return -21603;
        }
        return 0;
    }

    private int startRTCPMetadata(int serverPort) {
        try {
            this.udpRTCPReaderMetadata = new UdpRTPReaderUnicast(this.metadataHandlerCallback, this.udpReaderMetadata.getPort() + 1, InetAddress.getByName(this.networkParameter.getHost()), serverPort);
            this.udpRTCPReaderMetadata.init(524288, 50000, false);
            this.udpRTCPWriterMetadata = new UdpWriterUnicast(InetAddress.getByName(this.networkParameter.getHost()), this.udpRTCPReaderMetadata.getSocket(), serverPort);
        }
        catch (Exception e) {
            this.logger.error((Object)e, (Throwable)e);
            return -21603;
        }
        return 0;
    }

    private byte[] send(byte[] data, boolean supressError, boolean readAnswer) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
        byte[] buffer = new byte[4096];
        int contentLength = -1;
        int startPos = -1;
        long bytesOfContentRead = 0L;
        byte[] errorResult = new byte[]{};
        if (this.shutdown) {
            return errorResult;
        }
        try {
            int len;
            long now;
            long timeRequestSent = System.currentTimeMillis();
            this.outStream.write(data);
            this.outStream.flush();
            ++this.sentRequests;
            if (data != null) {
                this.sentBytes += (long)data.length;
            }
            if ((now = System.currentTimeMillis()) > timeRequestSent + 10000L) {
                this.logger.warn("Long delay while sending RTSP request: " + (now - timeRequestSent) + "ms.");
            }
            while (readAnswer && (len = this.inStream.read(buffer, 0, buffer.length)) > 0) {
                if (len <= 0) continue;
                ++this.receivedResponses;
                this.receivedBytes += (long)len;
                baos.write(buffer, 0, len);
                String tmp = new String(buffer).toLowerCase();
                if (this.lineDelimiter.equals("\r\n") && !tmp.contains(this.lineDelimiter + this.lineDelimiter) && tmp.contains("\n\n")) {
                    this.lineDelimiter = "\n";
                }
                if (tmp.toLowerCase().contains("unauthorized")) break;
                if (tmp.contains("content-length:")) {
                    startPos = tmp.indexOf("content-length:") + "content-length:".length();
                    int startOfContent = tmp.indexOf(this.lineDelimiter + this.lineDelimiter) + this.lineDelimiter.length() + this.lineDelimiter.length();
                    bytesOfContentRead = len - startOfContent;
                    try {
                        contentLength = Integer.parseInt(tmp.substring(startPos, tmp.indexOf(this.lineDelimiter, startPos)).trim());
                    }
                    catch (NumberFormatException nfe) {
                        this.logger.error("Can't convert content-length into number: " + nfe.getMessage(), (Throwable)nfe);
                    }
                } else {
                    long l = bytesOfContentRead = startPos != -1 ? bytesOfContentRead + (long)len : bytesOfContentRead;
                }
                if ((startPos == -1 || bytesOfContentRead < (long)contentLength) && (!baos.toString().endsWith(this.lineDelimiter + this.lineDelimiter) || startPos != -1)) continue;
                break;
            }
            return baos.toByteArray();
        }
        catch (SocketTimeoutException ste) {
            this.logger.warn("SOTimeout reached. Aborting RTSPHandler.");
            return errorResult;
        }
        catch (Exception e) {
            if (this.shutdown) {
                return errorResult;
            }
            if (supressError) {
                this.logger.info("Auto-generated RTSP answer cause Arecont don't send one.");
                return "RTSP/1.0 200 OK\r\n\r\n".getBytes();
            }
            this.logger.error("Exception writing to network", (Throwable)e);
            return errorResult;
        }
    }
}

