/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared.net.rtsp;

import de.seetec.v5.re.cm.device.shared.net.rtp.RtpSenderPacket;
import de.seetec.v5.re.cm.device.shared.net.rtsp.HttpStreamHandler;
import de.seetec.v5.re.cm.device.shared.net.rtsp.HttpStreamListenerIntf;
import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPHandlerSuper;
import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPRequest;
import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPResponse;
import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPStreamSettings;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.net.HTTPStatusCode;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.net.RTSPStatusCode;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.concurrent.TimeUnit;
import javax.xml.bind.DatatypeConverter;
import org.apache.logging.log4j.LogManager;

public class RTSPHandlerHTTP
extends RTSPHandlerSuper
implements HttpStreamListenerIntf {
    private static final byte[] MAGIC = new byte[]{36};
    private static final byte[] RTSP_HEADER = new byte[]{82, 84, 83, 80};
    private static final byte[] END_OF_RTSP = new byte[]{13, 10, 13, 10};
    private HttpStreamHandler httpStreamHandler;
    private byte[] responseTunnel = null;
    private byte[] previousPacket;
    private String rtspUrl;
    private int tcpVideoChannel;
    private int tcpAudioChannel;
    private int tcpMetadataChannel;
    private boolean rtspTunnelEstablished = false;

    public RTSPHandlerHTTP() {
        this.shutdown = false;
        this.logger = LogManager.getLogger((String)this.getClass().getName());
    }

    @Override
    public int init(RTSPStreamSettings rtspSettings) {
        this.rtspSettings = rtspSettings;
        this.networkParameter = rtspSettings.getNetworkParameter();
        this.networkParameter.setAdditionalData("x-sessioncookie: " + System.currentTimeMillis() + "\r\n");
        this.networkParameter.checkAndSetTimeout((int)TimeUnit.SECONDS.toMillis(5L));
        this.printDebug = rtspSettings.isPrintDebug();
        this.rtspUrl = this.trimStreamingUrl(this.rtspSettings.getRtspUrl(), this.networkParameter.getHost());
        this.callback = rtspSettings.getCallback();
        this.audioHandlerCallback = rtspSettings.getAudioHandlerCallback();
        this.metadataHandlerCallback = rtspSettings.getMetadataHandlerCallback();
        this.basicAuthenticationDisabled = rtspSettings.isBasicAuthenticationDisabled();
        return 0;
    }

    @Override
    protected RTSPResponse sendRTSPPacket(RTSPRequest request) {
        request.setSequenceNumber(this.sequenceNumber++);
        long WAIT_DELTA = 15000L;
        this.responseTunnel = null;
        long waitingSince = Long.MIN_VALUE;
        this.isAudioEnabled = request.isIsAudioSetup();
        this.isMetadataEnabled = request.isMetadataSetup();
        if (this.printDebug) {
            this.logger.info("Request:\r\n" + request.getData());
        }
        try {
            String rtspUrlToSend = request.getUrl().startsWith("rtsp://") ? this.rtspUrl : request.getUrl();
            this.readPostRequest(this.networkParameter, rtspUrlToSend, DatatypeConverter.printBase64Binary((byte[])request.serialize()));
            waitingSince = System.currentTimeMillis();
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while sending RTSP request for " + this.callback + " : " + ex.getMessage());
        }
        catch (Exception e) {
            this.logger.error("Exception while sending RTSP request for " + this.callback);
        }
        if (this.isShutdown()) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                this.logger.error("Error while sleeping for " + this);
            }
            return new RTSPResponse(RTSPStatusCode.RTSP_OK.getStatusCode());
        }
        while (this.responseTunnel == null && !this.isShutdown() && request.isWaitForResponse()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (waitingSince + 15000L >= System.currentTimeMillis()) continue;
            this.logger.warn("No answer reached for tunneled RTSP request. Aborting for " + this.callback);
            this.logger.fatal("Assure that Antivirus WebGuard and stuff like that is switched off!!!");
            break;
        }
        if (this.isShutdown() || !request.isWaitForResponse()) {
            return new RTSPResponse(RTSPStatusCode.RTSP_OK.getStatusCode());
        }
        if (this.responseTunnel != null) {
            if ((double)waitingSince + 11250.0 < (double)System.currentTimeMillis()) {
                this.logger.warn("Answer took long. (" + (System.currentTimeMillis() - waitingSince) + "ms) for " + this.callback);
            }
            RTSPResponse response = new RTSPResponse(this.responseTunnel, this.rtspSettings);
            if (this.sessionID == null) {
                this.sessionID = response.getSessionID();
            }
            if (response.getChannelIdentifier() != -1) {
                if (this.isMetadataEnabled) {
                    this.tcpMetadataChannel = response.getChannelIdentifier();
                } else if (this.isAudioEnabled) {
                    this.tcpAudioChannel = response.getChannelIdentifier();
                } else {
                    this.tcpVideoChannel = response.getChannelIdentifier();
                }
            }
            return response;
        }
        this.logger.warn("response is null for " + this.callback);
        this.callback.sendStatusService(-21656);
        this.callback.onNetworkError(-21656);
        this.shutdown();
        return new RTSPResponse(-21656);
    }

    public int setupEnvironment(boolean headerOnly) {
        this.httpStreamHandler = new HttpStreamHandler(this.rtspSettings.useHTTPPersistentDuplexTunnel(), this.rtspSettings.useAuthenticationForHTTPTunnel());
        this.networkParameter.setSoTimeout(10000);
        int errorCode = this.httpStreamHandler.init(this, this.networkParameter, this.rtspUrl);
        if (errorCode != 0) {
            this.logger.error("Error [" + errorCode + "]with " + this.httpStreamHandler);
        } else {
            errorCode = this.httpStreamHandler.startStreaming(true, headerOnly);
            if (errorCode != 0) {
                this.logger.warn("ServerPush of " + this.httpStreamHandler + " terminated with error [" + errorCode + "]");
            }
        }
        return errorCode;
    }

    @Override
    public int start() {
        int errorCode = this.setupEnvironment(false);
        if (errorCode == 0) {
            return super.start();
        }
        return errorCode;
    }

    @Override
    public void shutdown() {
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        super.shutdown();
        if (this.httpStreamHandler != null) {
            this.httpStreamHandler.shutdown();
        }
    }

    @Override
    public void run() {
    }

    @Override
    public synchronized void deliverRawContent(byte[] rawHttpContent) {
        if (rawHttpContent != null) {
            byte[] receivedBytes;
            if (rawHttpContent.length >= 4 && rawHttpContent[0] == 72 && rawHttpContent[1] == 84 && rawHttpContent[2] == 84 && rawHttpContent[3] == 80) {
                String response;
                String content = new String(rawHttpContent);
                int pos = content.indexOf("RTSP/1.0 200 OK");
                if (pos != -1) {
                    if (this.printDebug) {
                        response = new String(rawHttpContent);
                        this.logger.info("Tunneled RTSP Response = " + response);
                    }
                    this.deliverRawContent(content.substring(pos).getBytes());
                }
                if (content.toLowerCase().contains("unauthorized")) {
                    response = new String(rawHttpContent);
                    this.logger.info("Tunneled RTSP Response = " + response);
                    this.callback.sendStatusService(-21657);
                    this.shutdown();
                }
                return;
            }
            if (this.previousPacket != null) {
                receivedBytes = new byte[this.previousPacket.length + rawHttpContent.length];
                System.arraycopy(this.previousPacket, 0, receivedBytes, 0, this.previousPacket.length);
                System.arraycopy(rawHttpContent, 0, receivedBytes, this.previousPacket.length, rawHttpContent.length);
                this.previousPacket = null;
            } else {
                receivedBytes = new byte[rawHttpContent.length];
                System.arraycopy(rawHttpContent, 0, receivedBytes, 0, rawHttpContent.length);
            }
            int bytesProcessed = 0;
            while (bytesProcessed < receivedBytes.length) {
                int indexMagic = Basic.indexOfByteArray((byte[])receivedBytes, (byte[])MAGIC, (int)bytesProcessed, (int)(receivedBytes.length - bytesProcessed), (boolean)true);
                int indexRTSP = Basic.indexOfByteArray((byte[])receivedBytes, (byte[])RTSP_HEADER, (int)bytesProcessed, (int)(receivedBytes.length - bytesProcessed), (boolean)true);
                indexMagic = indexMagic == -1 ? Integer.MAX_VALUE : indexMagic;
                int n = indexRTSP = indexRTSP == -1 ? Integer.MAX_VALUE : indexRTSP;
                if (indexMagic < indexRTSP) {
                    if (receivedBytes.length <= indexMagic + 3) {
                        this.previousPacket = new byte[receivedBytes.length - indexMagic];
                        System.arraycopy(receivedBytes, indexMagic, this.previousPacket, 0, receivedBytes.length - indexMagic);
                        break;
                    }
                    int lengthOfEmbeddedRTP = Basic.byteArrayToInt4((byte[])new byte[]{receivedBytes[indexMagic + 2], receivedBytes[indexMagic + 3]});
                    byte typeOfData = receivedBytes[indexMagic + 1];
                    if (indexMagic + 4 + lengthOfEmbeddedRTP <= receivedBytes.length) {
                        byte[] newPacket = new byte[lengthOfEmbeddedRTP];
                        System.arraycopy(receivedBytes, indexMagic + 4, newPacket, 0, lengthOfEmbeddedRTP);
                        if (typeOfData == this.tcpVideoChannel || typeOfData == this.tcpVideoChannel + 1) {
                            this.callback.processData(newPacket);
                        } else if (typeOfData == this.tcpAudioChannel || typeOfData == this.tcpAudioChannel + 1) {
                            this.audioHandlerCallback.processData(newPacket);
                        } else if (typeOfData == this.tcpMetadataChannel || typeOfData == this.tcpMetadataChannel + 1) {
                            this.metadataHandlerCallback.processData(newPacket);
                        }
                        bytesProcessed = indexMagic + 4 + lengthOfEmbeddedRTP;
                        continue;
                    }
                    this.previousPacket = new byte[receivedBytes.length - indexMagic];
                    System.arraycopy(receivedBytes, indexMagic, this.previousPacket, 0, receivedBytes.length - indexMagic);
                    break;
                }
                if (indexMagic > indexRTSP) {
                    byte[] rtspMessage;
                    int contentLengthIndex = Basic.indexOfByteArray((byte[])receivedBytes, (byte[])"Content-Length:".getBytes(), (int)indexRTSP, (int)(receivedBytes.length - indexRTSP));
                    if (contentLengthIndex != -1) {
                        int endOfcontentLengthIndex = Basic.indexOfByteArray((byte[])receivedBytes, (byte[])CRLF_BYTE, (int)contentLengthIndex, (int)(receivedBytes.length - contentLengthIndex), (boolean)true);
                        if (endOfcontentLengthIndex != -1) {
                            byte[] contentLength = new byte[endOfcontentLengthIndex - contentLengthIndex];
                            System.arraycopy(receivedBytes, contentLengthIndex, contentLength, 0, endOfcontentLengthIndex - contentLengthIndex);
                            int contenLengthInBytes = Integer.parseInt(new String(contentLength).trim());
                            int lengthOfRTSPMessage = contenLengthInBytes == 0 ? receivedBytes.length - indexRTSP : endOfcontentLengthIndex + 4 + contenLengthInBytes - indexRTSP;
                            rtspMessage = new byte[lengthOfRTSPMessage];
                            System.arraycopy(receivedBytes, indexRTSP, rtspMessage, 0, lengthOfRTSPMessage);
                            this.responseTunnel = new String(rtspMessage).getBytes();
                            bytesProcessed = indexRTSP + lengthOfRTSPMessage;
                            continue;
                        }
                        this.previousPacket = new byte[receivedBytes.length - indexRTSP];
                        System.arraycopy(receivedBytes, indexRTSP, this.previousPacket, 0, receivedBytes.length - indexRTSP);
                        this.logger.warn("Rare case: Response for Describe divided.");
                        break;
                    }
                    int endIndex = Basic.indexOfByteArray((byte[])receivedBytes, (byte[])END_OF_RTSP, (int)indexRTSP, (int)(receivedBytes.length - indexRTSP));
                    if (endIndex != -1) {
                        rtspMessage = new byte[endIndex - indexRTSP];
                        System.arraycopy(receivedBytes, indexRTSP, rtspMessage, 0, endIndex - indexRTSP);
                        this.responseTunnel = new String(rtspMessage).getBytes();
                        bytesProcessed = indexRTSP + rtspMessage.length;
                        continue;
                    }
                    if (receivedBytes.length - indexRTSP == 0) break;
                    this.previousPacket = new byte[receivedBytes.length - indexRTSP];
                    System.arraycopy(receivedBytes, indexRTSP, this.previousPacket, 0, receivedBytes.length - indexRTSP);
                    break;
                }
                this.logger.warn("NO Magic nor RTSP header found in packet of length: " + receivedBytes.length + ". Wait till next.");
                break;
            }
        }
    }

    @Override
    public void sendStatusService(int statusCode) {
        this.callback.sendStatusService(statusCode);
    }

    @Override
    public void notifyForNetworkProblems() {
        this.callback.onNetworkError(-21656);
    }

    @Override
    public boolean isShutdown() {
        return this.shutdown;
    }

    @Override
    public int sendReceiverReportVideo(byte[] receiverReport) {
        return this.sendReceiverReport(receiverReport, this.tcpVideoChannel + 1);
    }

    @Override
    public int sendReceiverReportAudio(byte[] receiverReport) {
        return this.sendReceiverReport(receiverReport, this.tcpAudioChannel + 1);
    }

    @Override
    public int sendReceiverReportMetadata(byte[] receiverReport) {
        return this.sendReceiverReport(receiverReport, this.tcpMetadataChannel + 1);
    }

    @Override
    public int sendRTPPacket(RtpSenderPacket audioData) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    protected String trimStreamingUrl(String completeStreamingUrl, String hostAddress) {
        String trimmedUrl = hostAddress;
        if (hostAddress != null && (trimmedUrl = completeStreamingUrl.substring(completeStreamingUrl.indexOf(hostAddress) + hostAddress.length())).startsWith(":")) {
            trimmedUrl = trimmedUrl.replaceFirst("^:[0-9]*", "");
        }
        return trimmedUrl;
    }

    private void readPostRequest(NetworkParameter networkParameter, String rtspUrl, String requestBody) throws SeeTecException {
        if (!this.rtspSettings.useHTTPPersistentDuplexTunnel()) {
            NetworkHelper.readPostRequest((NetworkParameter)networkParameter, (String)rtspUrl, (String)requestBody, (boolean)true);
        } else if (this.httpStreamHandler.getPostSocket() == null) {
            this.rtspTunnelEstablished = false;
            this.logger.error("No POST tunnel open to send " + requestBody + " for " + this.callback);
            this.callback.sendStatusService(-21656);
            this.callback.onNetworkError(-21656);
            this.shutdown();
        } else {
            this.readPostRequest(networkParameter, rtspUrl, requestBody.getBytes(), this.httpStreamHandler.getPostSocket());
            this.rtspTunnelEstablished = true;
        }
    }

    private void readPostRequest(NetworkParameter networkParameter, String url, byte[] body, Socket postSocket) throws SeeTecException {
        int errorCode = 0;
        String errorMessage = null;
        String host = networkParameter.getHost();
        HTTPStatusCode statusCode = HTTPStatusCode.HTTP_OK;
        try {
            OutputStream os = postSocket.getOutputStream();
            if (!this.rtspTunnelEstablished) {
                boolean useAuthentication = this.rtspSettings.useAuthenticationForHTTPTunnel();
                String additionalData = networkParameter.getAdditionalData() != null ? networkParameter.getAdditionalData() : "";
                String authorization = NetworkHelper.createBasicAuthorization((String[])networkParameter.getUserPWD());
                String request = "POST " + url + " HTTP/1.1" + "\r\n" + "User-Agent: Java/1.7.0" + "\r\n" + "Host: " + host + "\r\n" + additionalData + (useAuthentication ? authorization : "") + "Content-Type: application/x-rtsp-tunnelled" + "\r\n" + "Pragma: no-cache" + "\r\n" + "Cache-Control: no-cache" + "\r\n" + "Content-Length: 32767" + "\r\n" + "Expires: Sun, 9 Jan 1972 00:00:00 GMT " + "\r\n" + "\r\n";
                os.write(request.getBytes());
            }
            if (body != null && body.length > 0) {
                os.write(body);
            }
            os.flush();
        }
        catch (Throwable ex) {
            errorCode = -20001;
            errorMessage = ex.getMessage() + ", " + networkParameter;
        }
        if (errorCode != 0) {
            throw new SeeTecException(errorCode, errorMessage, statusCode);
        }
    }

    private int sendReceiverReport(byte[] receiverReport, int channel) {
        int errorCode = 0;
        if (!this.rtspSettings.receiverReportsEnabled() || receiverReport == null) {
            return 0;
        }
        try {
            byte[] completeReceiverReport = new byte[receiverReport.length + 4];
            completeReceiverReport[0] = 36;
            completeReceiverReport[1] = (byte)channel;
            byte[] length = Basic.int4ToByteArray((int)receiverReport.length);
            System.arraycopy(length, 2, completeReceiverReport, 2, 2);
            System.arraycopy(receiverReport, 0, completeReceiverReport, 4, receiverReport.length);
            this.readPostRequest(this.networkParameter, this.rtspUrl, DatatypeConverter.printBase64Binary((byte[])completeReceiverReport));
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while sending receiver report for " + this.callback + " : " + ex.getMessage());
            errorCode = ex.getErrorCode();
        }
        return errorCode;
    }
}

