/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared.net.rtcp;

import de.seetec.v5.re.cm.device.shared.net.rtcp.RTCPHandlerIntf;
import de.seetec.v5.re.cm.device.shared.net.rtcp.RTCPMessageType;

public class RTCPParser {
    private static final byte VERSION = 2;
    private final RTCPHandlerIntf rtcpActionListener;

    public RTCPParser(RTCPHandlerIntf rtcpActionListener) {
        this.rtcpActionListener = rtcpActionListener;
    }

    public void parsePackage(byte[] data) {
        if (!this.isFirstPayloadSenderOrReceiver(data)) {
            return;
        }
        int currentBytesRead = 0;
        int totalBytesRead = 0;
        while (totalBytesRead < data.length) {
            if (!this.isCorrectVersion(data, currentBytesRead)) {
                return;
            }
            short length = (short)(data[currentBytesRead + 2] << 8 | data[currentBytesRead + 3] & 0xFF);
            int payloadType = data[currentBytesRead + 1] & 0xFF;
            if (null != RTCPMessageType.valueOf(payloadType)) {
                switch (RTCPMessageType.valueOf(payloadType)) {
                    case SENDER_REPORT: {
                        currentBytesRead = this.processSenderReport(data, currentBytesRead, length);
                        break;
                    }
                    case RECEIVER_REPORT: {
                        currentBytesRead = this.processReceiverReport(data, currentBytesRead);
                        break;
                    }
                    case SDES: {
                        currentBytesRead = this.processSDES(length, data, currentBytesRead);
                        break;
                    }
                    case BYE: {
                        currentBytesRead = this.processBYE(data, currentBytesRead);
                        break;
                    }
                    case APP: {
                        currentBytesRead = this.processAPP(currentBytesRead, length);
                        break;
                    }
                }
            }
            totalBytesRead = currentBytesRead;
        }
    }

    private int processAPP(int currentBytesRead, short length) {
        return currentBytesRead += 4 * (length + 1);
    }

    private int processBYE(byte[] data, int currentBytesRead) {
        byte SC = this.readCount(data, currentBytesRead);
        currentBytesRead += 4;
        if ((currentBytesRead += SC * 4) < data.length) {
            byte lengthOfField = (byte)(data[currentBytesRead] & 0xFF);
            ++currentBytesRead;
            currentBytesRead += lengthOfField;
            while ((byte)(data[currentBytesRead] & 0xFF) == 0 && currentBytesRead < data.length) {
                ++currentBytesRead;
            }
        }
        if (this.rtcpActionListener != null) {
            this.rtcpActionListener.RTCPBYEReceived();
        }
        return currentBytesRead;
    }

    private int processSDES(short length, byte[] data, int currentBytesRead) {
        int len = length * 4;
        int SC = this.readCount(data, currentBytesRead);
        currentBytesRead += 4;
        for (int j = 0; j < SC; ++j) {
            currentBytesRead += 4;
            len -= 4;
            while ((byte)(data[currentBytesRead] & 0xFF) != 0 && len > 0) {
                byte lengthOfField = (byte)(data[currentBytesRead + 1] & 0xFF);
                currentBytesRead += 2;
                len -= 2;
                currentBytesRead += lengthOfField;
                len -= lengthOfField;
                if (this.rtcpActionListener == null) continue;
                this.rtcpActionListener.RTCPSDESReceived();
            }
            while (len > 0 && (byte)(data[currentBytesRead] & 0xFF) == 0) {
                ++currentBytesRead;
                --len;
            }
        }
        return currentBytesRead;
    }

    private int processReceiverReport(byte[] data, int currentBytesRead) {
        byte RC = this.readCount(data, currentBytesRead);
        currentBytesRead += 8;
        currentBytesRead += RC * 24;
        if (this.rtcpActionListener != null) {
            this.rtcpActionListener.RTCPReceiverReportReceived();
        }
        return currentBytesRead;
    }

    private int processSenderReport(byte[] data, int currentBytesRead, short length) {
        byte RC = this.readCount(data, currentBytesRead);
        currentBytesRead += 8;
        if (length != 1) {
            currentBytesRead += 20;
        }
        currentBytesRead += RC * 24;
        if (this.rtcpActionListener != null) {
            this.rtcpActionListener.RTCPSenderReportReceived();
        }
        return currentBytesRead;
    }

    private boolean isFirstPayloadSenderOrReceiver(byte[] data) {
        int firstPayloadType = data[1] & 0xFF;
        return firstPayloadType == RTCPMessageType.SENDER_REPORT.getType() || firstPayloadType == RTCPMessageType.RECEIVER_REPORT.getType();
    }

    private boolean isCorrectVersion(byte[] data, int currentBytesRead) {
        return (byte)((data[currentBytesRead] & 0xFF) >> 6) == 2;
    }

    private byte readCount(byte[] data, int currentBytesRead) {
        return (byte)(data[currentBytesRead] & 0xFF & 0x1F);
    }
}

