/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared.net.httpserverpush;

import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushContent;
import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushListenerIntf;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.TimeHelper;
import de.seetec.v5.shared.net.HTTPStatusCode;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.Socket;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HttpServerPushHandler
extends Basic
implements Runnable {
    private static final String CLASS_NAME = "de.seetec.v5.shared.net.HttpServerPushHandler";
    private static final String TAG_CONTENT_LENGTH = "content-length:";
    private final byte[] TagBoundary = "boundary=".getBytes();
    private final Logger logger = LogManager.getLogger((String)this.getClass().getName());
    private Thread thread = null;
    private HttpServerPushListenerIntf listener = null;
    private NetworkParameter networkParameter = null;
    private Socket socket = null;
    private String sURL = null;
    private int expectedHeaderLength = 512;
    private byte[] boundary;

    public int init(HttpServerPushListenerIntf listener, NetworkParameter networkParameter, String sURL) {
        return this.init(listener, networkParameter, sURL, 512);
    }

    public int init(HttpServerPushListenerIntf listener, NetworkParameter networkParameter, String sURL, int expectedHeaderLength) {
        return this.init(listener, networkParameter, sURL, expectedHeaderLength, null);
    }

    public int init(HttpServerPushListenerIntf listener, NetworkParameter networkParameter, String sURL, int expectedHeaderLength, byte[] boundary) {
        this.listener = listener;
        if (this.listener == null) {
            return -20002;
        }
        this.networkParameter = networkParameter;
        if (this.networkParameter == null) {
            return -20002;
        }
        this.sURL = sURL;
        if (this.sURL == null) {
            return -20002;
        }
        this.expectedHeaderLength = expectedHeaderLength;
        if (this.expectedHeaderLength < 0) {
            return -20002;
        }
        this.boundary = boundary;
        return 0;
    }

    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    public int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.socket = null;
        }
        return 0;
    }

    public int startServerPush(boolean bAsynchronous) {
        this.logger.info(Basic.generateIndentedMultiLineLog((String[])new String[]{"Starting Http Streaming with following Parameter:", "   Listener        : " + this.listener, "   NetworkParameter: " + this.networkParameter, "   URL             : [" + this.sURL + "]"}));
        try {
            this.socket = NetworkHelper.establishServerPushStream((NetworkParameter)this.networkParameter, (String[])this.networkParameter.getUserPWD(), (String)this.sURL);
            this.listener.sendStatusService(0);
        }
        catch (Throwable ex) {
            int nErrorCode = -20100;
            this.logger.error((Object)ex, ex);
            this.listener.sendStatusService(nErrorCode);
            return nErrorCode;
        }
        if (bAsynchronous) {
            this.thread = new Thread((Runnable)this, this.toString());
            this.thread.start();
            return 0;
        }
        return this.readHttpServerPush();
    }

    @Override
    public void run() {
        super.setRunFinished(CLASS_NAME, false);
        try {
            int nErrorCode = this.readHttpServerPush();
            if (nErrorCode != 0) {
                this.listener.sendStatusService(nErrorCode);
            }
        }
        catch (Throwable ex) {
            this.logger.warn((Object)ex, ex);
        }
        super.setRunFinished(CLASS_NAME, true);
        this.shutdown();
    }

    protected int readHttpServerPush() {
        int nErrorCode = 0;
        int nLen = -1;
        int nIndex = -1;
        byte[] inBuffer = new byte[1024];
        byte[] array = null;
        byte[] extBoundary = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(32768);
        InputStream is = null;
        try {
            is = this.socket.getInputStream();
            if (this.boundary == null) {
                baos.reset();
                while (!this.isShutdown()) {
                    block49: {
                        try {
                            nLen = is.read(inBuffer, 0, inBuffer.length);
                            if (nLen >= 0) break block49;
                            if (array == null) {
                                nErrorCode = -20102;
                            } else {
                                String sMSG = new String(array);
                                this.logger.error("Invalid server push for " + this + ":\n\r" + sMSG);
                                HTTPStatusCode httpStatusCode = NetworkHelper.getStatusCode((NetworkParameter)this.networkParameter, (String)sMSG);
                                nErrorCode = httpStatusCode == HTTPStatusCode.HTTP_FORBIDDEN ? httpStatusCode.getStatusCode() : (!sMSG.toLowerCase().contains("unauthorized") ? -20102 : -21657);
                            }
                            break;
                        }
                        catch (InterruptedIOException soTimeoutException) {
                            if (this.networkParameter.getIgnoreSoTimeout()) continue;
                            throw soTimeoutException;
                        }
                        catch (NullPointerException npe) {
                            break;
                        }
                    }
                    baos.write(inBuffer, 0, nLen);
                    array = baos.toByteArray();
                    if (array.length < 512) {
                        try {
                            Thread.sleep(5L);
                        }
                        catch (InterruptedException npe) {}
                        continue;
                    }
                    if (array.length > 0x100000) {
                        this.logger.error("No boundary found within [" + Basic.longToFormattedString((long)array.length) + " B] :-(");
                        nErrorCode = -20102;
                        break;
                    }
                    nIndex = Basic.indexOfByteArray((byte[])array, (byte[])this.networkParameter.getHttpDoubleLineDelimitter(), (int)0);
                    if (nIndex <= 0) continue;
                    try {
                        StringBuilder sbHeader;
                        int k;
                        StringBuilder sbHeader2;
                        String sHeader;
                        byte[] streamHeader = new byte[nIndex - 4];
                        System.arraycopy(array, 0, streamHeader, 0, nIndex - 4);
                        int nPos1 = Basic.indexOfByteArray((byte[])array, (byte[])this.TagBoundary, (int)0);
                        if (nPos1 == -1) {
                            nPos1 = Basic.indexOfByteArray((byte[])array, (byte[])"boundary =".getBytes(), (int)0);
                        }
                        int nPos2 = Basic.indexOfByteArray((byte[])array, (byte[])this.networkParameter.getHttpSingleLineDelimitter(), (int)nPos1);
                        byte[] prefix = null;
                        byte[] simpleBoundary = null;
                        byte[] postfix = null;
                        if (array[nPos1] == 34 && array[nPos2 - 3] == 34) {
                            simpleBoundary = new byte[nPos2 - nPos1 - this.networkParameter.getHttpSingleLineDelimitter().length - 2];
                            System.arraycopy(array, nPos1 + 1, simpleBoundary, 0, simpleBoundary.length);
                        } else if (array[nPos1] == 34 && array[nPos2 - 2] == 34) {
                            simpleBoundary = new byte[nPos2 - nPos1 - this.networkParameter.getHttpSingleLineDelimitter().length - 2];
                            System.arraycopy(array, nPos1 + 1, simpleBoundary, 0, simpleBoundary.length);
                        } else {
                            simpleBoundary = new byte[nPos2 - nPos1 - this.networkParameter.getHttpSingleLineDelimitter().length];
                            System.arraycopy(array, nPos1, simpleBoundary, 0, simpleBoundary.length);
                        }
                        if (simpleBoundary[0] == 45 && simpleBoundary[1] == 45) {
                            prefix = new byte[this.networkParameter.getHttpSingleLineDelimitter().length];
                            System.arraycopy(this.networkParameter.getHttpSingleLineDelimitter(), 0, prefix, 0, this.networkParameter.getHttpSingleLineDelimitter().length);
                        } else {
                            prefix = new byte[this.networkParameter.getHttpSingleLineDelimitter().length + 2];
                            System.arraycopy(this.networkParameter.getHttpSingleLineDelimitter(), 0, prefix, 0, this.networkParameter.getHttpSingleLineDelimitter().length);
                            prefix[this.networkParameter.getHttpSingleLineDelimitter().length + 1] = 45;
                            prefix[this.networkParameter.getHttpSingleLineDelimitter().length] = 45;
                        }
                        postfix = new byte[this.networkParameter.getHttpSingleLineDelimitter().length];
                        System.arraycopy(this.networkParameter.getHttpSingleLineDelimitter(), 0, postfix, 0, this.networkParameter.getHttpSingleLineDelimitter().length);
                        extBoundary = new byte[prefix.length + simpleBoundary.length + postfix.length];
                        System.arraycopy(prefix, 0, extBoundary, 0, prefix.length);
                        System.arraycopy(simpleBoundary, 0, extBoundary, prefix.length, simpleBoundary.length);
                        System.arraycopy(postfix, 0, extBoundary, prefix.length + simpleBoundary.length, postfix.length);
                        nIndex = Basic.indexOfByteArray((byte[])array, (byte[])extBoundary, (int)0);
                        if (nIndex >= 0) {
                            baos.reset();
                            baos.write(array, nIndex, array.length - nIndex);
                            break;
                        }
                        byte[] siemensPrefix = new byte[]{10, 45, 45};
                        byte[] siemensPostfix = new byte[]{10};
                        byte[] extSiemensBoundary = new byte[siemensPrefix.length + simpleBoundary.length + siemensPostfix.length];
                        System.arraycopy(siemensPrefix, 0, extSiemensBoundary, 0, siemensPrefix.length);
                        System.arraycopy(simpleBoundary, 0, extSiemensBoundary, siemensPrefix.length, simpleBoundary.length);
                        System.arraycopy(siemensPostfix, 0, extSiemensBoundary, siemensPrefix.length + simpleBoundary.length, siemensPostfix.length);
                        nIndex = Basic.indexOfByteArray((byte[])array, (byte[])extSiemensBoundary, (int)0);
                        if (nIndex >= 0) {
                            baos.reset();
                            baos.write(array, nIndex, array.length - nIndex);
                            this.logger.info("Siemens boundary found :-)");
                            extBoundary = extSiemensBoundary;
                            this.networkParameter.setHttpSingleLineDelimitter(new byte[]{10});
                            this.networkParameter.setHttpDoubleLineDelimitter(new byte[]{10});
                            break;
                        }
                        nIndex = Basic.indexOfByteArray((byte[])array, (byte[])simpleBoundary, (int)0);
                        if (nIndex >= 0) {
                            baos.reset();
                            baos.write(array, nIndex, array.length - nIndex);
                            break;
                        }
                        this.logger.info("~~~[ Siemens boundary not found ] ~~~~~~~~~~~~~~~~~~~~~~~~~~");
                        if (extSiemensBoundary.length > 256) {
                            sHeader = new String(extSiemensBoundary, 0, 256);
                            this.logger.error("   extSiemensBoundary=[" + sHeader + " ...] :-(");
                            sbHeader2 = new StringBuilder("      ");
                            for (k = 0; k < 256; ++k) {
                                sbHeader2.append(extSiemensBoundary[k]);
                            }
                            this.logger.error(sbHeader2.toString());
                        } else {
                            this.logger.error("   extSiemensBoundary=[" + new String(extSiemensBoundary) + "] :-(");
                            sbHeader = new StringBuilder("      ");
                            for (int k2 = 0; k2 < extSiemensBoundary.length; ++k2) {
                                sbHeader.append(Integer.toHexString(extSiemensBoundary[k2]) + "-");
                            }
                            this.logger.error(sbHeader.toString());
                        }
                        this.logger.info("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
                        this.logger.error("No boundary found for " + this.networkParameter + " with URL [" + this.sURL + "] :-(");
                        if (extBoundary.length > 256) {
                            sHeader = new String(extBoundary, 0, 256);
                            this.logger.error("   extBoundary=[" + sHeader + " ...] :-(");
                            sbHeader2 = new StringBuilder("      ");
                            for (k = 0; k < 256; ++k) {
                                sbHeader2.append(extBoundary[k]);
                            }
                            this.logger.error(sbHeader2.toString());
                        } else {
                            this.logger.error("   extBoundary=[" + new String(extBoundary) + "] :-(");
                            sbHeader = new StringBuilder("      ");
                            for (int k3 = 0; k3 < extBoundary.length; ++k3) {
                                sbHeader.append(Integer.toHexString(extBoundary[k3]) + "-");
                            }
                            this.logger.error(sbHeader.toString());
                        }
                        this.logger.error("this.networkParameter.getHttpSingleLineDelimitter().length=" + this.networkParameter.getHttpSingleLineDelimitter().length);
                        this.logger.error("prefix.length=" + prefix.length);
                        this.logger.error("postfix.length=" + postfix.length);
                        this.logger.error("simpleBoundary.length=" + simpleBoundary.length);
                        this.logger.error("simpleBoundary=" + new String(simpleBoundary));
                        this.logger.error("extBoundary.length=" + extBoundary.length);
                        StringBuilder sb = new StringBuilder("      ");
                        if (array.length > 256) {
                            for (int i = 0; i < 256; ++i) {
                                sb.append(Integer.toHexString(array[i]) + "-");
                            }
                        } else {
                            for (int i = 0; i < array.length; ++i) {
                                sb.append(Integer.toHexString(array[i]) + "-");
                            }
                        }
                        this.logger.error(sb.toString());
                        if (array.length > 256) {
                            this.logger.error("   array=[" + new String(array, 0, 256) + " ...] :-(");
                        } else {
                            this.logger.error("   array=[" + new String(array) + "] :-(");
                        }
                        nErrorCode = -20102;
                    }
                    catch (Exception ex) {
                        String sWebServerRSP = null;
                        sWebServerRSP = array.length > 256 ? new String(array, 0, 256) : new String(array);
                        this.logger.warn("Reading [" + this.socket + this.sURL + "] failed!\n\r\n\r" + sWebServerRSP + "\n", (Throwable)ex);
                        if (!sWebServerRSP.toLowerCase().contains("unauthorized")) {
                            nErrorCode = -20102;
                            break;
                        }
                        nErrorCode = -21657;
                    }
                    break;
                }
            } else {
                extBoundary = this.boundary;
            }
            if (nErrorCode == 0) {
                nLen = (array = baos.toByteArray()).length < 256 ? array.length : 256;
                String s = new String(array, 0, nLen);
                nErrorCode = !s.toLowerCase().contains(TAG_CONTENT_LENGTH) ? this.readContentStream(is, baos, extBoundary) : this.readOptimizedContentStream(is, baos, extBoundary);
            } else {
                this.listener.sendStatusService(nErrorCode);
            }
        }
        catch (IOException ex) {
            if (!this.isShutdown()) {
                this.logger.warn("Network problems for " + this, (Throwable)ex);
                this.listener.notifyForNetworkProblems();
            }
        }
        catch (SeeTecException ex) {
            this.logger.warn((Object)ex, (Throwable)ex);
            this.listener.notifyForNetworkProblems();
        }
        catch (Throwable ex) {
            this.logger.warn("Unexpected exception occured for " + this, ex);
            this.listener.notifyForNetworkProblems();
        }
        try {
            if (this.socket != null) {
                this.socket.close();
                this.socket = null;
            }
        }
        catch (IOException ioex) {
            this.logger.warn((Object)ioex, (Throwable)ioex);
        }
        return nErrorCode;
    }

    protected int readContentStream(InputStream is, ByteArrayOutputStream baos, byte[] extBoundary) throws IOException, SeeTecException {
        int nLen = 0;
        int nLastSearchPostition = 0;
        boolean bTrim = false;
        byte[] inBuffer = null;
        byte[] contentHeader = null;
        byte[] contentBody = null;
        long tsLastContentRead = System.currentTimeMillis();
        int nBufferOffset = -1;
        byte[] array = baos.toByteArray();
        inBuffer = array.length < 32768 ? new byte[32768] : new byte[(array.length >> 1 << 1) + 16384];
        System.arraycopy(array, 0, inBuffer, 0, array.length);
        nBufferOffset = array.length;
        while (!this.isShutdown() && !this.listener.isShutdown()) {
            try {
                if (nBufferOffset + 4096 > inBuffer.length) {
                    if ((long)inBuffer.length >= 0x800000L) {
                        this.logger.info("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
                        String sHeader = new String(extBoundary);
                        this.logger.error("   extBoundary=[" + sHeader + "] :-(");
                        StringBuilder sbHeader = new StringBuilder("      ");
                        for (int k = 0; k < extBoundary.length; ++k) {
                            sbHeader.append(extBoundary[k]);
                        }
                        this.logger.error(sbHeader.toString());
                        this.logger.error("Limitation of content size exceeded for " + this);
                        return -20102;
                    }
                    array = new byte[inBuffer.length + 8192];
                    System.arraycopy(inBuffer, 0, array, 0, nBufferOffset);
                    inBuffer = array;
                }
                try {
                    nLen = is.read(inBuffer, nBufferOffset, 4096);
                    if (nLen < 0) {
                        return -20103;
                    }
                    nBufferOffset += nLen;
                }
                catch (InterruptedIOException soTimeoutException) {
                    this.logger.warn("Timeout reading from socket after [" + this.networkParameter.getSoTimeout() + " ms] for " + this.socket + " / " + this);
                    if (this.networkParameter.getIgnoreSoTimeout()) continue;
                    throw soTimeoutException;
                }
            }
            catch (NullPointerException npe) {
                this.shutdown();
                return 0;
            }
            int nStartOfHeader = 0;
            int nEndOfHeader = -1;
            int nEndOfBody = -1;
            while ((nEndOfBody = Basic.indexOfByteArray((byte[])inBuffer, (byte[])extBoundary, (int)nLastSearchPostition, (int)(nBufferOffset - nLastSearchPostition - 1))) > 0) {
                int nLengthOfContentBody;
                nEndOfHeader = Basic.indexOfByteArray((byte[])inBuffer, (byte[])this.networkParameter.getHttpDoubleLineDelimitter(), (int)nStartOfHeader);
                if (nEndOfHeader < 0) {
                    throw new RuntimeException("No [EndOfHeader] found within content :-(");
                }
                contentHeader = new byte[nEndOfHeader - nStartOfHeader - this.networkParameter.getHttpDoubleLineDelimitter().length];
                System.arraycopy(inBuffer, nStartOfHeader, contentHeader, 0, contentHeader.length);
                if (inBuffer[nEndOfHeader] == 10) {
                    ++nEndOfHeader;
                }
                if ((nLengthOfContentBody = nEndOfBody - nEndOfHeader - extBoundary.length) > 0) {
                    contentBody = new byte[nLengthOfContentBody];
                    System.arraycopy(inBuffer, nEndOfHeader, contentBody, 0, contentBody.length);
                } else {
                    contentBody = new byte[]{};
                }
                String sContentHeader = new String(contentHeader);
                this.listener.deliverContent(new HttpServerPushContent(sContentHeader, contentBody));
                nLastSearchPostition = nStartOfHeader = nEndOfBody;
                bTrim = true;
                if (tsLastContentRead + 60000L < System.currentTimeMillis()) {
                    this.logger.warn("Content read within [" + TimeHelper.getReadableTimerange((long)(System.currentTimeMillis() - tsLastContentRead)) + "] via " + this);
                }
                tsLastContentRead = System.currentTimeMillis();
            }
            if (bTrim) {
                array = new byte[inBuffer.length];
                System.arraycopy(inBuffer, nLastSearchPostition, array, 0, nBufferOffset - nLastSearchPostition);
                inBuffer = array;
                nBufferOffset -= nLastSearchPostition;
                nLastSearchPostition = 0;
                bTrim = false;
                continue;
            }
            nLastSearchPostition = nBufferOffset - extBoundary.length;
            if (nLastSearchPostition >= 0) continue;
            nLastSearchPostition = 0;
        }
        return 0;
    }

    private int readOptimizedContentStream(InputStream is, ByteArrayOutputStream baos, byte[] extBoundary) throws IOException, SeeTecException {
        int nLen = 0;
        int nEndOfHeader = -1;
        byte[] inBuffer = new byte[4096];
        byte[] array = null;
        byte[] contentHeader = null;
        byte[] contentBody = null;
        long tsLastContentRead = System.currentTimeMillis();
        while (!this.isShutdown() && !this.listener.isShutdown()) {
            char c;
            int nEndPos;
            array = baos.toByteArray();
            while (array.length < this.expectedHeaderLength) {
                try {
                    try {
                        nLen = is.read(inBuffer, 0, inBuffer.length);
                        if (nLen < 0) {
                            return -20103;
                        }
                    }
                    catch (InterruptedIOException soTimeoutException) {
                        this.logger.warn("Timeout reading from socket after [" + this.networkParameter.getSoTimeout() + " ms] for " + this.socket + " / " + this);
                        if (this.networkParameter.getIgnoreSoTimeout()) continue;
                        throw soTimeoutException;
                    }
                }
                catch (NullPointerException npe) {
                    this.shutdown();
                    return 0;
                }
                baos.write(inBuffer, 0, nLen);
                array = baos.toByteArray();
            }
            nEndOfHeader = Basic.indexOfByteArray((byte[])array, (byte[])this.networkParameter.getHttpDoubleLineDelimitter(), (int)0);
            if (nEndOfHeader < 0) {
                this.logger.error("Cannot find content header:");
                this.logger.error("array.length=" + array.length);
                this.logger.error(new String(array, 0, 512));
                return -20103;
            }
            if (nEndOfHeader < 16 && (nEndOfHeader = Basic.indexOfByteArray((byte[])array, (byte[])this.networkParameter.getHttpDoubleLineDelimitter(), (int)16)) < 0) {
                this.logger.error("Cannot find content header:");
                this.logger.error("array.length=" + array.length);
                this.logger.error(new String(array, 0, 512));
                return -20103;
            }
            contentHeader = new byte[nEndOfHeader - this.networkParameter.getHttpDoubleLineDelimitter().length];
            System.arraycopy(array, 0, contentHeader, 0, contentHeader.length);
            String sContentHeader = new String(contentHeader);
            int nStartPos = sContentHeader.toLowerCase().indexOf(TAG_CONTENT_LENGTH) + TAG_CONTENT_LENGTH.length();
            while (sContentHeader.charAt(nStartPos) == ' ') {
                ++nStartPos;
            }
            if (nStartPos < 0) {
                return -1;
            }
            for (nEndPos = nStartPos; nEndPos < sContentHeader.length() && (c = sContentHeader.charAt(nEndPos)) >= '0' && c <= '9'; ++nEndPos) {
            }
            int nContentLength = Integer.parseInt(sContentHeader.substring(nStartPos, nEndPos));
            baos.reset();
            baos.write(array, nEndOfHeader, array.length - nEndOfHeader);
            int nRead = array.length - nEndOfHeader;
            while (nRead < nContentLength) {
                try {
                    try {
                        nLen = is.read(inBuffer, 0, inBuffer.length);
                        if (nLen < 0) {
                            return -20103;
                        }
                    }
                    catch (InterruptedIOException soTimeoutException) {
                        this.logger.warn("Timeout reading from socket after [" + this.networkParameter.getSoTimeout() + " ms] for " + this.socket + " / " + this);
                        if (this.networkParameter.getIgnoreSoTimeout()) continue;
                        throw soTimeoutException;
                    }
                }
                catch (NullPointerException npe) {
                    this.shutdown();
                    return 0;
                }
                baos.write(inBuffer, 0, nLen);
                nRead += nLen;
            }
            array = baos.toByteArray();
            contentBody = new byte[nContentLength];
            System.arraycopy(array, 0, contentBody, 0, contentBody.length);
            this.listener.deliverContent(new HttpServerPushContent(sContentHeader, contentBody));
            baos.reset();
            baos.write(array, nContentLength, array.length - nContentLength);
            if (tsLastContentRead + 60000L < System.currentTimeMillis()) {
                this.logger.warn("Content read within [" + TimeHelper.getReadableTimerange((long)(System.currentTimeMillis() - tsLastContentRead)) + "] via " + this);
            }
            tsLastContentRead = System.currentTimeMillis();
        }
        return 0;
    }

    public String toString() {
        String sThis = this.getClass().getName() + "@" + Integer.toHexString(this.hashCode());
        return "[" + sThis.substring(sThis.lastIndexOf(46) + 1) + ", Listener=" + this.listener + ", " + this.networkParameter + ", " + this.socket + ", URL=[" + this.sURL + "]]";
    }
}

