/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared.net;

import de.seetec.v5.re.cm.device.shared.net.MulticastCallback;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.util.Enumeration;

public class MulticastReader
implements Runnable {
    private MulticastSocket multicastSocket;
    private MulticastCallback listener;
    private InetAddress inetAddress;
    private boolean isShutdown;
    private final InetAddress addressOfLocalNetworkInterface;

    public MulticastReader(MulticastCallback multicastCallback, InetAddress addressOfLocalNetworkInterface) {
        this.listener = multicastCallback;
        this.addressOfLocalNetworkInterface = addressOfLocalNetworkInterface;
    }

    public int init(String[] multicastParameters, int networkTimeout) {
        int returnValue = 0;
        if (!this.isParameterValid(multicastParameters)) {
            return -20002;
        }
        try {
            this.inetAddress = InetAddress.getByName(multicastParameters[0]);
            this.multicastSocket = new MulticastSocket(Integer.parseInt(multicastParameters[1]));
            this.multicastSocket.setTimeToLive(Integer.parseInt(multicastParameters[2]));
            this.multicastSocket.setSoTimeout(networkTimeout);
        }
        catch (IOException ex) {
            returnValue = -20100;
        }
        if (this.multicastSocket != null) {
            new Thread((Runnable)this, this.toString()).start();
        } else {
            returnValue = -20100;
        }
        return returnValue;
    }

    @Override
    public void run() {
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            NetworkInterface interfaceForMulticast = null;
            block2: while (interfaces.hasMoreElements()) {
                NetworkInterface networkInterface = interfaces.nextElement();
                Enumeration<InetAddress> inetAdresses = networkInterface.getInetAddresses();
                while (inetAdresses.hasMoreElements()) {
                    InetAddress address = inetAdresses.nextElement();
                    if (!address.equals(this.addressOfLocalNetworkInterface)) continue;
                    interfaceForMulticast = networkInterface;
                    break block2;
                }
            }
            if (interfaceForMulticast != null) {
                this.multicastSocket.setNetworkInterface(interfaceForMulticast);
                this.multicastSocket.joinGroup(this.inetAddress);
            } else {
                this.multicastSocket.joinGroup(this.inetAddress);
            }
            byte[] buf = new byte[10000];
            DatagramPacket datagramPacket = new DatagramPacket(buf, buf.length);
            while (!this.isShutdown()) {
                this.multicastSocket.receive(datagramPacket);
                byte[] data = new byte[datagramPacket.getLength()];
                System.arraycopy(datagramPacket.getData(), 0, data, 0, datagramPacket.getLength());
                this.listener.processData(data);
            }
        }
        catch (IOException ex) {
            this.listener.onNetworkError(-20100);
        }
    }

    protected boolean isParameterValid(String[] multicastParameters) {
        boolean result = true;
        if (multicastParameters == null || multicastParameters.length != 3) {
            result = false;
        } else {
            for (int i = 0; i < multicastParameters.length; ++i) {
                String parameter = multicastParameters[i];
                if (parameter == null || parameter.isEmpty()) {
                    result = false;
                    break;
                }
                if (i <= 0) continue;
                try {
                    Integer.parseInt(parameter);
                    continue;
                }
                catch (NumberFormatException ex) {
                    result = false;
                    break;
                }
            }
        }
        return result;
    }

    private boolean isShutdown() {
        return this.isShutdown;
    }

    public int shutdown() {
        try {
            this.multicastSocket.leaveGroup(this.inetAddress);
        }
        catch (IOException ex) {
            return -20001;
        }
        this.isShutdown = true;
        return 0;
    }
}

