/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared.net;

import de.seetec.v5.re.cm.device.shared.net.HttpPersistentConnectionListenerIntf;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.net.HTTPStatusCode;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Base64;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Deprecated
public class HttpPersistentConnectionHandler
extends Basic
implements Runnable {
    static final String CONTENTLENGTH = "content-length: ";
    private static final String CLASS_NAME = "de.seetec.v5.shared.net.HttpPersistentConnectionHandler";
    private final Logger logger = LogManager.getLogger((String)this.getClass().getName());
    private Thread thread = null;
    private HttpPersistentConnectionListenerIntf listener = null;
    private NetworkParameter networkParameter = null;
    private Socket socket = null;
    private String url = null;
    private OutputStream os;
    private InputStream is;
    private long time;
    private int intervalLength;

    public void init(HttpPersistentConnectionListenerIntf listener, NetworkParameter networkParameter, String url, int intervalLength) {
        this.listener = listener;
        this.networkParameter = networkParameter;
        this.intervalLength = intervalLength;
        this.url = url;
    }

    private boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    public int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.socket = null;
        }
        return 0;
    }

    public int startPersistentConnection(boolean asynchronous) {
        this.logger.info("Starting HttpPersistentConnection with following Parameter:");
        this.logger.info("   Listener        : " + this.listener);
        this.logger.info("   NetworkParameter: " + this.networkParameter);
        this.logger.info("   URL             : [" + this.url + "]");
        this.logger.info("   Asynchronous    : [" + asynchronous + "]");
        try {
            this.socket = this.networkParameter.useHTTPS() ? NetworkHelper.createNetworkConnection((String)this.networkParameter.getHost(), (int)this.networkParameter.getSSLport(), (boolean)true) : NetworkHelper.createNetworkConnection((String)this.networkParameter.getHost(), (int)this.networkParameter.getHTTPport(), (boolean)false);
            this.socket.setSoTimeout(this.networkParameter.getSoTimeout());
            this.os = this.socket.getOutputStream();
            this.is = this.socket.getInputStream();
            this.listener.sendStatusService(0);
        }
        catch (Throwable ex) {
            int errorCode = -20100;
            this.logger.error((Object)ex, ex);
            this.listener.sendStatusService(errorCode);
            return errorCode;
        }
        if (asynchronous) {
            this.thread = new Thread((Runnable)this, this.toString());
            this.thread.start();
            return 0;
        }
        return this.readPersistentConnection();
    }

    @Override
    public void run() {
        super.setRunFinished(CLASS_NAME, false);
        try {
            int errorCode = this.readPersistentConnection();
            if (errorCode != 0) {
                this.listener.sendStatusService(errorCode);
            }
        }
        catch (Throwable ex) {
            this.logger.warn((Object)ex, ex);
        }
        super.setRunFinished(CLASS_NAME, true);
        this.shutdown();
    }

    protected int readPersistentConnection() {
        String authorization;
        String realm = this.networkParameter.getRealm();
        String nonce = this.networkParameter.getNonce();
        String qop = this.networkParameter.getQop();
        if (realm != null && nonce != null && qop != null) {
            try {
                authorization = NetworkHelper.createDigestAuthorization((NetworkParameter)this.networkParameter, (String)realm, (String)nonce, (String)"GET", (String)this.url, (String)qop);
            }
            catch (Exception ex) {
                this.logger.error("Exception while creating digest authentication for " + this + ": " + ex.getMessage());
                return -21657;
            }
        } else {
            authorization = this.networkParameter.getUserPWD() != null ? "Authorization: Basic " + Base64.getEncoder().encodeToString((this.networkParameter.getUserPWD()[0] + ":" + this.networkParameter.getUserPWD()[1]).getBytes()) + "\r\n" : "";
        }
        String additionalData = this.networkParameter.getAdditionalData() != null ? this.networkParameter.getAdditionalData() : "";
        String request = "GET " + this.url + " HTTP/1.1" + "\r\n" + additionalData + authorization + "User-Agent: Java/1.4.2" + "\r\n" + "Host: " + this.networkParameter.getHost() + "\r\n" + "Accept: text/html, image/gif, image/jpeg, *; q=.2, */*; q=.2" + "\r\n" + "Connection: keep-alive" + new String(DOUBLE_CRLF_BYTE);
        while (!this.isShutdown()) {
            if (System.currentTimeMillis() - this.time < (long)this.intervalLength) {
                try {
                    Thread.sleep((long)this.intervalLength - (System.currentTimeMillis() - this.time));
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.time = System.currentTimeMillis();
            if (this.isShutdown()) continue;
            try {
                byte[] result = this.readGetRequest(request);
                int startBodyIndex = Basic.indexOfByteArray((byte[])result, (byte[])this.networkParameter.getHttpDoubleLineDelimitter(), (int)0);
                String resultString = new String(result);
                int endIndex = resultString.indexOf(new String(this.networkParameter.getHttpDoubleLineDelimitter()));
                if (endIndex <= -1) continue;
                String header = resultString.substring(0, endIndex);
                if (NetworkHelper.getStatusCode((NetworkParameter)this.networkParameter, (String)header) == HTTPStatusCode.HTTP_UNAUTHORIZED) {
                    if (header.toLowerCase().contains("digest")) {
                        realm = NetworkHelper.getAuthenticationData((String)"realm", (String)header);
                        nonce = NetworkHelper.getAuthenticationData((String)"nonce", (String)header);
                        qop = NetworkHelper.getAuthenticationData((String)"qop", (String)header);
                        if (!realm.equals(this.networkParameter.getRealm()) || !nonce.equals(this.networkParameter.getNonce())) {
                            this.networkParameter.setRealm(realm);
                            this.networkParameter.setNonce(nonce);
                            this.networkParameter.setQop(qop);
                            try {
                                authorization = NetworkHelper.createDigestAuthorization((NetworkParameter)this.networkParameter, (String)realm, (String)nonce, (String)"GET", (String)this.url, (String)qop);
                            }
                            catch (Exception ex) {
                                this.logger.error("Exception while creating digest authentication for " + this + ": " + ex.getMessage());
                                return -21657;
                            }
                            request = "GET " + this.url + " HTTP/1.1" + "\r\n" + additionalData + authorization + "User-Agent: Java/1.4.2" + "\r\n" + "Host: " + this.networkParameter.getHost() + "\r\n" + "Accept: text/html, image/gif, image/jpeg, *; q=.2, */*; q=.2" + "\r\n" + "Connection: keep-alive" + new String(DOUBLE_CRLF_BYTE);
                            continue;
                        }
                        return -21657;
                    }
                    return -21657;
                }
                byte[] body = Arrays.copyOfRange(result, startBodyIndex, result.length);
                this.listener.deliverContent(body);
            }
            catch (SeeTecException ex) {
                this.logger.error("Exception while reading http request using persistent connection for " + this + " : " + ex.getMessage());
                return -1;
            }
        }
        try {
            if (this.socket != null) {
                this.socket.close();
                this.socket = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return 0;
    }

    private byte[] readGetRequest(String request) throws SeeTecException {
        int errorCode = 0;
        String errorMessage = null;
        byte[] result = null;
        try {
            int len;
            this.os.write(request.getBytes());
            this.os.flush();
            byte[] buffer = new byte[2048];
            ByteArrayOutputStream baos = new ByteArrayOutputStream(buffer.length);
            int read = 0;
            int headerLength = 0;
            while ((len = this.is.read(buffer)) > 0) {
                baos.write(buffer, 0, len);
                if (baos.toString().toLowerCase().contains("transfer-encoding: chunked\r\n") && baos.toString().contains("0\r\n\r\n")) break;
                int wantedLength = Integer.MAX_VALUE;
                String sBuffer = new String(buffer);
                if (sBuffer.contains("\r\n\r\n")) {
                    String header = sBuffer.substring(0, sBuffer.indexOf("\r\n\r\n"));
                    headerLength = header.length();
                    if (!header.toLowerCase().contains(CONTENTLENGTH)) {
                        throw new Exception("Can't extract content length");
                    }
                    if ((header = header.substring(header.toLowerCase().indexOf(CONTENTLENGTH) + CONTENTLENGTH.length())).equalsIgnoreCase("0")) break;
                    if (header.contains("\r\n")) {
                        header = header.substring(0, header.indexOf("\r\n"));
                    }
                    wantedLength = Integer.parseInt(header);
                }
                if ((read += len) < wantedLength + headerLength) continue;
                break;
            }
            result = baos.toByteArray();
        }
        catch (UnknownHostException ex) {
            errorCode = -20100;
            errorMessage = "UnknownHostException: " + ex.getMessage() + ", " + this.networkParameter;
        }
        catch (NoRouteToHostException ex) {
            errorCode = -20100;
            errorMessage = "NoRouteToHostException: " + ex.getMessage() + ", " + this.networkParameter;
        }
        catch (Throwable ex) {
            errorCode = -20001;
            errorMessage = ex.getMessage() + ", " + this.networkParameter;
        }
        if (errorCode != 0) {
            throw new SeeTecException(errorCode, errorMessage);
        }
        return result;
    }

    public String toString() {
        String sThis = this.getClass().getName() + "@" + Integer.toHexString(this.hashCode());
        return "[" + sThis.substring(sThis.lastIndexOf(46) + 1) + ", Listener=" + this.listener + ", " + this.networkParameter + ", " + this.socket + ", URL=[" + this.url + "]]";
    }
}

