/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared.io;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.device.shared.Device;
import de.seetec.v5.re.cm.device.shared.Service;
import de.seetec.v5.re.cm.device.shared.io.DigitalInputSrv;
import de.seetec.v5.re.cm.device.shared.io.DigitalOutputSrv;
import de.seetec.v5.re.cm.shared.IOCRH;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.net.NetworkDispatcherHeader;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.net.SRPCDispatcherListener;
import de.seetec.v5.shared.proxy.ent.Entity;
import de.seetec.v5.shared.util.ConfigurationException;
import java.net.Socket;
import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class IOHandler
extends Basic
implements SRPCDispatcherListener,
Runnable {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.shared.IOHandler";
    protected Logger logger = LogManager.getLogger((String)this.getClass().getName());
    protected Device device = null;
    protected String host = null;
    protected int port = -1;
    protected boolean authorization = false;
    protected String usr = "";
    protected String pwd = "";
    protected NetworkParameter networkParameter = null;
    private Core core = null;
    private DigitalInputSrv[] iServices = null;
    private DigitalOutputSrv[] oServices = null;
    private Thread myThread = null;
    private int highestInputNumber = 0;
    private boolean activeInputs = false;

    public int init(Core core, Device device, Entity[] srvEnities, boolean ignoreSomeParameter, boolean unconditionalStartOfThread) {
        int i;
        this.device = device;
        if (this.device == null) {
            return -21601;
        }
        this.core = core;
        if (this.core == null) {
            return -21601;
        }
        if (srvEnities == null) {
            return -21601;
        }
        try {
            this.authorization = this.device.getDeviceCnf().getUseAuthorization();
            this.usr = this.device.getDeviceCnf().getUser();
            this.pwd = this.device.getDeviceCnf().getPassword();
            if (!ignoreSomeParameter) {
                this.host = this.device.getDeviceCnf().getHardwareHost();
                this.port = this.device.getDeviceCnf().getHardwarePort();
                this.networkParameter = this.device.getDeviceCnf().getNetworkParameter();
            }
        }
        catch (ConfigurationException cex) {
            this.logger.error((Object)cex, (Throwable)cex);
            return -21602;
        }
        ArrayList<Service> inputServices = new ArrayList<Service>();
        ArrayList<Service> outputServices = new ArrayList<Service>();
        for (Entity entity : srvEnities) {
            int errorCode;
            Service service;
            boolean enabled = entity.isEnabled();
            long srvType = entity.getEntityType();
            if (!enabled) continue;
            if (srvType == 9801L || srvType == 9802L || srvType == 9804L || srvType == 9805L) {
                service = new DigitalInputSrv();
                errorCode = ((DigitalInputSrv)service).init(core, device, this, entity);
                if (errorCode != 0) {
                    this.logger.error("Initializing " + (Object)((Object)service) + " failed with error [" + errorCode + "] for " + this);
                    return errorCode;
                }
                core.registerToSRPCDispatcher(this, entity.getEntityID());
                inputServices.add(service);
            }
            if (srvType != 9911L && srvType != 9912L && srvType != 9921L && srvType != 9922L) continue;
            service = new DigitalOutputSrv();
            errorCode = ((DigitalOutputSrv)service).init(core, device, this, entity);
            if (errorCode != 0) {
                this.logger.error("Initializing " + (Object)((Object)service) + " failed with error [" + errorCode + "] for " + this);
                return errorCode;
            }
            core.registerToSRPCDispatcher(this, entity.getEntityID());
            outputServices.add(service);
        }
        this.iServices = new DigitalInputSrv[inputServices.size()];
        for (i = 0; i < inputServices.size(); ++i) {
            this.iServices[i] = (DigitalInputSrv)((Object)inputServices.get(i));
            if (this.iServices[i].getInputNumber() > this.highestInputNumber) {
                this.highestInputNumber = this.iServices[i].getInputNumber();
            }
            this.logger.info("New service: " + (Object)((Object)this.iServices[i]) + " for " + this);
        }
        this.oServices = new DigitalOutputSrv[outputServices.size()];
        for (i = 0; i < outputServices.size(); ++i) {
            this.oServices[i] = (DigitalOutputSrv)((Object)outputServices.get(i));
        }
        if (this.highestInputNumber > 0) {
            this.activeInputs = true;
            this.myThread = new Thread((Runnable)this, this.toString());
            this.myThread.start();
        } else {
            this.activeInputs = false;
        }
        if (unconditionalStartOfThread && this.myThread == null) {
            this.myThread = new Thread((Runnable)this, this.toString());
            this.myThread.start();
        }
        return 0;
    }

    public int init(Core core, Device device, Entity[] srvEnities) {
        return this.init(core, device, srvEnities, false, false);
    }

    public int init(Core core, Device device, Entity[] srvEnities, boolean ignoreSomeParameter) {
        return this.init(core, device, srvEnities, ignoreSomeParameter, false);
    }

    public boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    public int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        this.discard();
        if (this.myThread != null) {
            long timeout = System.currentTimeMillis() + 30000L;
            while (!super.isRunFinished(CLASS_NAME)) {
                if (System.currentTimeMillis() > timeout) {
                    this.logger.warn("Thread didn't finished in time for " + this);
                    break;
                }
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.myThread = null;
        }
        if (this.device != null) {
            int errorCode = this.device.shutdown();
            if (errorCode != 0) {
                this.logger.warn("Shutting down the device failed with error [" + errorCode + "] for " + this);
            }
            this.device = null;
        }
        return 0;
    }

    public abstract int writeDigitalOutput(int var1, int var2, long var3);

    protected int discard() {
        return 0;
    }

    public int handleRequest(Socket socket, NetworkDispatcherHeader networkDispatcherHeader) {
        if (networkDispatcherHeader.getProtocol() != 0) {
            this.logger.error("Protocol [" + networkDispatcherHeader.getProtocol() + "] not supported");
            try {
                socket.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return -21005;
        }
        return this.handleRequest(socket);
    }

    public int handleRequest(Socket socket) {
        if (this.isShutdown(CLASS_NAME)) {
            this.logger.warn("... Client refused. Core is already shutting down");
            return -21609;
        }
        this.logger.info("New client from " + socket + " ...");
        IOCRH ioCRH = new IOCRH();
        int errorCode = ioCRH.init(this, socket);
        if (errorCode != 0) {
            this.logger.error("Initializing " + (Object)((Object)ioCRH) + " failed with error [" + errorCode);
            errorCode = ioCRH.shutdown();
            if (errorCode != 0) {
                this.logger.warn("Shutting down " + (Object)((Object)ioCRH) + " failed with error [" + errorCode);
            }
            return errorCode;
        }
        return 0;
    }

    protected Core getCore() {
        return this.core;
    }

    protected boolean hasActiveInputs() {
        return this.activeInputs;
    }

    protected boolean hasActiveOutputs() {
        return this.oServices != null && this.oServices.length > 0;
    }

    protected DigitalInputSrv[] getDigitalInputSrv() {
        return this.iServices;
    }

    protected DigitalOutputSrv getDigitalOutputSrv(int outputNumber) {
        for (DigitalOutputSrv service : this.oServices) {
            if (service.getOutputNumber() != outputNumber) continue;
            return service;
        }
        return null;
    }

    protected int getHighestInputNumber() {
        return this.highestInputNumber;
    }

    public int triggerAction(Long actionID, Long alarmScriptID, Long alarmInstanceID, Long alarmDuration, byte[] genericData) {
        this.logger.info("Action [" + actionID + "] of scenario [" + alarmScriptID + "] with duration [" + alarmDuration / 1000L + "," + alarmDuration % 1000L + " s] is triggered ...");
        for (DigitalOutputSrv oService : this.oServices) {
            if (oService.getActionID() != actionID.longValue()) continue;
            return oService.triggerAction();
        }
        this.logger.error("Action [" + actionID + "] is unknown to " + this.device);
        if (this.oServices.length <= 0) {
            this.logger.error("There are no [DigitalOutputSrv] for " + this);
        } else {
            for (DigitalOutputSrv oService : this.oServices) {
                this.logger.info((Object)oService);
            }
        }
        return -21670;
    }

    public boolean isRestartWanted() {
        return false;
    }

    public DigitalOutputSrv[] getDigitalOutputSrv() {
        return this.oServices;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String toString() {
        String sThis = "de.seetec.v5.re.cm.device.shared.IOHandler@" + Integer.toHexString(this.hashCode());
        return "[" + sThis.substring(sThis.lastIndexOf(46) + 1) + ", ActiveInputs=[" + this.activeInputs + "], " + this.device + "]";
    }

    protected class HoldTimer
    extends Basic
    implements Runnable {
        private static final String CLASS_NAME = "de.seetec.v5.re.cm.shared.HoldTimer";
        private long holdTime = -1L;
        private long tsEndOfHoldTime = -1L;
        private int outputNumber = -1;
        private int outputValue = -1;
        private Thread myThread = null;

        public int init(int outputNumber, int outputValue, long holdTime) {
            this.outputNumber = outputNumber;
            if (this.outputNumber <= 0) {
                return -21601;
            }
            this.outputValue = outputValue;
            if (this.outputValue < 0) {
                return -21601;
            }
            this.holdTime = holdTime;
            this.tsEndOfHoldTime = System.currentTimeMillis() + holdTime;
            this.myThread = new Thread((Runnable)this, this.toString());
            this.myThread.start();
            return 0;
        }

        public final boolean isShutdown() {
            return this.isShutdown(CLASS_NAME);
        }

        public int shutdown() {
            if (this.startShutdown(CLASS_NAME)) {
                return 0;
            }
            IOHandler.this.logger.info("Starting shutdown of " + this + " ...");
            if (this.myThread != null) {
                long timeout = System.currentTimeMillis() + 30000L;
                while (!super.isRunFinished(CLASS_NAME)) {
                    if (System.currentTimeMillis() > timeout) {
                        IOHandler.this.logger.warn("Thread of " + this + " didn't finished in time :-(");
                        break;
                    }
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.myThread = null;
            }
            return 0;
        }

        @Override
        public void run() {
            super.setRunFinished(CLASS_NAME, false);
            IOHandler.this.logger.info("Starting Holdtime with [" + Basic.longToFormattedString((long)this.holdTime) + " ms]  ...");
            try {
                while (!this.isShutdown(CLASS_NAME)) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (this.tsEndOfHoldTime >= System.currentTimeMillis()) continue;
                    IOHandler.this.writeDigitalOutput(this.outputNumber, this.outputValue, 0L);
                    break;
                }
            }
            catch (Throwable ex) {
                IOHandler.this.logger.error((Object)ex, ex);
            }
            IOHandler.this.logger.info("Thread of this " + this + " finished");
            super.setRunFinished(CLASS_NAME, true);
            this.shutdown();
        }

        public String toString() {
            String sThis = "de.seetec.v5.re.cm.shared.HoldTimer@" + Integer.toHexString(this.hashCode());
            return "[" + sThis.substring(sThis.lastIndexOf(46) + 1) + ", OutputNumber=[" + this.outputNumber + "], HoldTime=[" + this.holdTime + "]]";
        }
    }
}

