/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared.io;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.device.shared.Device;
import de.seetec.v5.re.cm.device.shared.Service;
import de.seetec.v5.re.cm.device.shared.io.DigitalOutputSrvCnf;
import de.seetec.v5.re.cm.device.shared.io.IOHandler;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.proxy.ent.Entity;

public class DigitalOutputSrv
extends Service {
    private DigitalOutputSrvCnf srvCnf = null;
    private int outputNumber = -1;
    private long holdTime = -1L;
    private IOHandler ioHandler = null;

    public int init(Core core, Device device, IOHandler ioHandler, Entity entity) {
        int errorCode = super.init(core, device, entity);
        if (errorCode != 0) {
            this.logger.error("Initializing super class failed with error [" + errorCode + "] for " + (Object)((Object)this));
            return errorCode;
        }
        this.srvCnf = new DigitalOutputSrvCnf();
        errorCode = this.srvCnf.init(entity);
        if (errorCode != 0) {
            this.logger.error("Creating [SrvCnf] failed with error [" + errorCode + "] for " + (Object)((Object)this));
            return errorCode;
        }
        try {
            this.holdTime = this.srvCnf.getHoldTime();
            this.outputNumber = this.srvCnf.getOutputNumber();
        }
        catch (Exception ex) {
            this.logger.error((Object)ex, (Throwable)ex);
            return -21602;
        }
        this.ioHandler = ioHandler;
        return 0;
    }

    public int sendEvent() {
        long sourceID = this.srvCnf.getEntity().getEntityID();
        this.logger.info("Event of source [" + sourceID + "] from " + (Object)((Object)this));
        return super.getCore().sendApplicationEvent(sourceID);
    }

    @Override
    public int checkService() {
        return 0;
    }

    public int getOutputNumber() {
        return this.outputNumber;
    }

    public long getHoldTime() {
        return this.holdTime;
    }

    public long getActionID() {
        return this.getEntity().getEntityID();
    }

    public int triggerAction() {
        this.logger.info("Triggering action of " + (Object)((Object)this) + " ...");
        long entityType = this.getEntity().getEntityType();
        if (entityType == 9921L || entityType == 9911L) {
            try {
                this.getCore().setEntityStatus(super.getEntity().getEntityID(), 1);
            }
            catch (Throwable ex) {
                this.logger.warn((Object)ex, ex);
            }
            return this.ioHandler.writeDigitalOutput(this.getOutputNumber(), 1, this.holdTime);
        }
        if (entityType == 9922L || entityType == 9912L) {
            try {
                this.getCore().setEntityStatus(super.getEntity().getEntityID(), 0);
            }
            catch (Throwable ex) {
                this.logger.warn((Object)ex, ex);
            }
            return this.ioHandler.writeDigitalOutput(this.getOutputNumber(), 0, 0L);
        }
        this.logger.error("Triggering action failed with type [" + entityType + "] for " + (Object)((Object)this));
        return -21600;
    }

    @Override
    public String toString() {
        return "[" + super.toString() + ", OutputNumber=[" + this.outputNumber + "], HoldTime=[" + Basic.longToFormattedString((long)this.holdTime) + " ms], ActionID=[" + Basic.longToFormattedString((long)this.getActionID()) + "]]";
    }
}

