/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared.cameracontrol;

import de.seetec.v5.re.shared.ConfigurationElement;
import de.seetec.v5.re.shared.ConfigurationManager;
import de.seetec.v5.shared.util.ConfigurationException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jdom.output.XMLOutputter;

public class PresetCnf {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.shared.PresetCnf";
    private final Logger logger = LogManager.getLogger((String)this.getClass().getName());
    private ConfigurationManager cnfMgr = null;
    private long presetID = -1L;

    private int init(long presetID, byte[] cnf) {
        this.presetID = presetID;
        if (this.presetID < 0L) {
            return -21602;
        }
        if (cnf == null) {
            return -21602;
        }
        try {
            this.cnfMgr = new ConfigurationManager();
            this.cnfMgr.init(cnf);
        }
        catch (Throwable ex) {
            this.logger.error("Parsing configuration [" + new String(cnf) + "] failed.", ex);
            return -21602;
        }
        return 0;
    }

    private int init(long presetID, ConfigurationManager cnfMgr) {
        this.presetID = presetID;
        if (this.presetID < 0L) {
            return -21602;
        }
        this.cnfMgr = cnfMgr;
        if (this.cnfMgr == null) {
            return -21602;
        }
        return 0;
    }

    public static PresetCnf createPresetCnf(long presetID, byte[] cnf) {
        PresetCnf presetCnf = new PresetCnf();
        int errorCode = presetCnf.init(presetID, cnf);
        if (errorCode != 0) {
            throw new RuntimeException("Creating " + presetCnf + " failed with error [" + errorCode + "] :-(");
        }
        return presetCnf;
    }

    public static PresetCnf createPresetCnf(long presetID, String presetName) {
        ConfigurationManager cnfMgr = new ConfigurationManager();
        cnfMgr.init("PresetConfiguration", "5.1.0");
        ConfigurationElement ceRoot = cnfMgr.getRootElement();
        ConfigurationElement cePresetName = ceRoot.createChild("PresetName");
        cePresetName.setAsString(presetName);
        PresetCnf presetCnf = new PresetCnf();
        int errorCode = presetCnf.init(presetID, cnfMgr);
        if (errorCode != 0) {
            throw new RuntimeException("Creating " + presetCnf + " failed with error [" + errorCode + "] :-(");
        }
        return presetCnf;
    }

    public static PresetCnf createPresetCnf(long presetID, String presetPosition, String presetName) {
        ConfigurationManager cnfMgr = new ConfigurationManager();
        cnfMgr.init("PresetConfiguration", "5.1.0");
        ConfigurationElement ceRoot = cnfMgr.getRootElement();
        ConfigurationElement cePresetPosition = ceRoot.createChild("PresetPosition");
        cePresetPosition.setAsString(presetPosition);
        ConfigurationElement cePresetName = ceRoot.createChild("PresetName");
        cePresetName.setAsString(presetName);
        PresetCnf presetCnf = new PresetCnf();
        int errorCode = presetCnf.init(presetID, cnfMgr);
        if (errorCode != 0) {
            throw new RuntimeException("Creating " + presetCnf + " failed with error [" + errorCode + "] :-(");
        }
        return presetCnf;
    }

    public byte[] getPresetCnf() {
        try {
            XMLOutputter outputter = new XMLOutputter("   ", true);
            return outputter.outputString(this.cnfMgr.getDocument()).getBytes("UTF-8");
        }
        catch (Exception ex) {
            throw new RuntimeException("Creating configuration file failed with exception [" + ex + "]");
        }
    }

    public String getPresetPosition() throws ConfigurationException {
        ConfigurationElement cnfParameter = this.cnfMgr.getRootElement().getChild("PresetPosition");
        return cnfParameter.getAsString();
    }

    public String getPresetName() throws ConfigurationException {
        ConfigurationElement cnfParameter = this.cnfMgr.getRootElement().getChild("PresetName");
        return cnfParameter.getAsString();
    }

    public long getPresetID() {
        return this.presetID;
    }

    public String toString() {
        String presetName = null;
        try {
            presetName = this.getPresetName();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        String sThis = "de.seetec.v5.re.cm.device.shared.PresetCnf@" + Integer.toHexString(this.hashCode());
        return "[" + sThis.substring(sThis.lastIndexOf(46) + 1) + ", PresetID=[" + this.getPresetID() + "], PresetName=[" + presetName + "]]";
    }
}

