/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared.cameraadministration;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.device.shared.cameraadministration.PasswordModificationException;
import de.seetec.v5.re.shared.DeviceCnf;
import de.seetec.v5.shared.EventType;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.net.SeetecHttpClient;
import de.seetec.v5.shared.proxy.ent.EntMgrProxy;
import de.seetec.v5.shared.proxy.ent.Entity;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

public abstract class CameraAdministrationBase {
    protected final Logger logger = LogManager.getLogger((String)this.getClass().getName());
    private final SeetecHttpClient httpClient;

    public CameraAdministrationBase(SeetecHttpClient httpClient) throws SeeTecException {
        this.httpClient = httpClient;
        if (this.httpClient == null) {
            throw new SeeTecException(-20002, "Input parameter is null");
        }
    }

    public Logger getLogger() {
        return this.logger;
    }

    public SeetecHttpClient getHttpClient() {
        return this.httpClient;
    }

    protected void modifyPasswordInConfiguration(String newPasswordClearText, EntMgrProxy proxy, Entity deviceEntity, Core core) throws PasswordModificationException, SeeTecException {
        String passwordTag = "Password";
        Document deviceDocument = this.deserializeDeviceConfiguration(deviceEntity.getConfiguration());
        Element passwordElement = deviceDocument.getRootElement().getChild(passwordTag);
        String currentPassword = passwordElement.getText();
        if (currentPassword.equals(newPasswordClearText)) {
            return;
        }
        passwordElement.setText(newPasswordClearText);
        XMLOutputter outputter = new XMLOutputter();
        String newConfiguration = outputter.outputString(deviceDocument);
        int errorCode = proxy.setEntity(deviceEntity.getEntityID(), deviceEntity.getEntityName(), deviceEntity.getEntityType(), deviceEntity.getMID(), deviceEntity.isEnabled(), newConfiguration.getBytes(), null, null, null, null, null, core.getCayugaToken(), 30000L);
        if (errorCode != 0) {
            throw new PasswordModificationException(-20000, "Persisting entity has not worked. Old password still active.", currentPassword);
        }
    }

    protected void checkParametersForChangeDevicePassword(String newPasswordClearText, EntMgrProxy proxy, Entity deviceEntity, Core core) throws SeeTecException {
        if (newPasswordClearText == null || proxy == null || deviceEntity == null || core == null) {
            throw new SeeTecException(-20002, "Input parameter is null");
        }
    }

    private Document deserializeDeviceConfiguration(byte[] configuration) throws SeeTecException {
        try {
            return new SAXBuilder().build((InputStream)new ByteArrayInputStream(configuration));
        }
        catch (Exception e) {
            throw new SeeTecException(-20000, "Device configuration can't be deserialized.");
        }
    }

    public void changeDevicePassword(String newPasswordClearText, EntMgrProxy proxy, Entity deviceEntity, Core core) throws SeeTecException {
        this.checkParametersForChangeDevicePassword(newPasswordClearText, proxy, deviceEntity, core);
        try {
            DeviceCnf deviceCnf = new DeviceCnf(null);
            int errorCode = deviceCnf.init(deviceEntity.getConfiguration());
            if (errorCode != 0) {
                throw new SeeTecException(errorCode, "Reading device configuration " + deviceCnf + " failed with error [" + errorCode + "]");
            }
            this.logger.info("Check reachable of device '" + deviceEntity.toString() + "'.");
            NetworkHelper.checkNetworkConnection((NetworkParameter)deviceCnf.getNetworkParameter(), (int)((int)TimeUnit.MILLISECONDS.toMillis(500L)));
            this.logger.info("Change password for device '" + deviceEntity.toString() + "'.");
            this.modifyPasswordOnDevice(newPasswordClearText, deviceCnf.getNetworkParameter());
            try {
                this.modifyPasswordInConfiguration(newPasswordClearText, proxy, deviceEntity, core);
            }
            catch (PasswordModificationException passwordModificationException) {
                NetworkParameter networkParameter = deviceCnf.getNetworkParameter();
                networkParameter.setUserPWD(new String[]{networkParameter.getUserPWD()[0], newPasswordClearText});
                this.modifyPasswordOnDevice(passwordModificationException.getOldPassword(), networkParameter);
                throw new SeeTecException(passwordModificationException.getErrorCode(), "Updating entity after password change not worked. Rolling back '" + deviceEntity.toString() + "'. Message: " + passwordModificationException.getMessage());
            }
            catch (SeeTecException seeTecException) {
                throw new SeeTecException(seeTecException.getErrorCode(), "Updating entity after password change not worked. Rolling back to old password not possible. Message: " + seeTecException.getMessage());
            }
        }
        catch (ConfigurationException ex) {
            throw new SeeTecException(-20030, "Error while reading configuration: Message: " + ex.getMessage());
        }
    }

    protected abstract void modifyPasswordOnDevice(String var1, NetworkParameter var2) throws SeeTecException;

    public void upgradeDeviceFirmware(byte[] firmwareData, Entity deviceEntity, Core core) throws SeeTecException {
        try {
            this.checkParametersForUpgradeDeviceFirmware(firmwareData, deviceEntity, core);
            DeviceCnf deviceCnf = new DeviceCnf(null);
            int errorCode = deviceCnf.init(deviceEntity.getConfiguration());
            if (errorCode != 0) {
                throw new SeeTecException(errorCode, "Reading device configuration " + deviceCnf + " failed with error [" + errorCode + "]");
            }
            long dmID = core.getDmCnfMgr().getEntityID();
            NetworkParameter networkParameter = deviceCnf.getNetworkParameter();
            NetworkHelper.checkNetworkConnection((NetworkParameter)networkParameter, (int)((int)TimeUnit.MILLISECONDS.toMillis(500L)));
            this.logger.info("Upgrade firmware on device '" + deviceEntity.toString() + "'.");
            new Thread(() -> {
                try {
                    this.upgradeFirmwareOnDevice(firmwareData, networkParameter);
                    core.sendEvent(EventType.CM_EVENTTYPE_FIRMWARE_UPGRADE_SUCCESSFUL, dmID, deviceEntity.getEntityID(), null);
                    if (deviceEntity.isEnabled().booleanValue()) {
                        core.startDevice(deviceEntity.getEntityID(), deviceEntity.getEntityName(), deviceEntity.getEntityType());
                    }
                }
                catch (SeeTecException exception) {
                    core.sendEvent(EventType.CM_EVENTTYPE_FIRMWARE_UPGRADE_UNSUCCESSFUL, dmID, deviceEntity.getEntityID(), exception.getMessage().getBytes());
                    this.logger.info("Unable to send event. Firmware upgrade unsuccessful for [" + deviceEntity.getEntityID() + "] [" + exception.getMessage() + "]");
                }
            }).start();
        }
        catch (ConfigurationException ex) {
            throw new SeeTecException(-20030, "Error while reading configuration: Message: " + ex.getMessage());
        }
    }

    protected abstract void upgradeFirmwareOnDevice(byte[] var1, NetworkParameter var2) throws SeeTecException;

    protected void checkParametersForUpgradeDeviceFirmware(byte[] firmwareData, Entity deviceEntity, Core core) throws SeeTecException {
        if (firmwareData == null || firmwareData.length == 0 || deviceEntity == null || core == null) {
            throw new SeeTecException(-20002, "Input parameter is null");
        }
    }
}

