/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.shared;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedGenericEventsType;
import de.seetec.v5.re.cm.device.shared.CameraSrvFactory;
import de.seetec.v5.re.cm.device.shared.Device;
import de.seetec.v5.re.cm.device.shared.LiveCameraSrv;
import de.seetec.v5.re.cm.device.shared.Service;
import de.seetec.v5.re.cm.device.shared.VideoSrv;
import de.seetec.v5.re.cm.device.shared.io.IOHandler;
import de.seetec.v5.re.cm.device.video.archive.ArchiveCameraSrv;
import de.seetec.v5.re.cm.shared.TCPAlarmSrv;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.proxy.ent.Entity;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class VideoServer
extends Device {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.shared.VideoServer";
    private static final Long[] GENERIC_DEVICE_TYPES = new Long[]{209601L, 202208L, 205501L, 204203L, 206500L, 206600L, 202334L, 200436L, 201854L, 201748L, 200655L, 200657L, 200951L, 205900L, 206000L, 206100L, 204429L, 205603L, 200555L, 201117L, 204190L, 206300L, 206400L, 202442L, 206700L, 206800L};
    private static final List<Long> GENERIC_DEVICE_TYPE_LIST = new ArrayList<Long>(Arrays.asList(GENERIC_DEVICE_TYPES));
    private boolean initialized = false;

    @Override
    public int init(Core core, long entityID) {
        int errorCode;
        if (this.logger.isDebugEnabled()) {
            this.logger.info("Initializing device [" + entityID + "] ...");
        }
        if ((errorCode = super.init(core, entityID)) != 0) {
            this.logger.error("Initializing " + this + " failed with error [" + errorCode + "] ");
            return errorCode;
        }
        Entity[] srvEntities = super.getSrvEntities();
        this.services = new Service[srvEntities.length];
        if (this.logger.isDebugEnabled()) {
            this.logger.info("Creating [" + srvEntities.length + "] services for " + this + " ...");
        }
        for (int i = 0; i < srvEntities.length; ++i) {
            Service lastService = null;
            try {
                VideoSrv cameraSrv;
                long type;
                long srvType = srvEntities[i].getEntityType();
                boolean enabled = srvEntities[i].isEnabled();
                if (!enabled) continue;
                for (type = srvType; type > 1000L; type /= 10L) {
                }
                if (srvType == 219800L) {
                    cameraSrv = new ArchiveCameraSrv();
                    lastService = cameraSrv;
                    errorCode = cameraSrv.init(core, this, srvEntities[i]);
                    if (errorCode != 0) {
                        cameraSrv.shutdown();
                        this.logger.error("Creating " + (Object)((Object)lastService) + " failed with error [" + errorCode + "]");
                        return errorCode;
                    }
                    this.services[i] = cameraSrv;
                } else if (type >= 210L && type < 220L) {
                    cameraSrv = CameraSrvFactory.getCameraSrv(this.logger, this.getDeviceType());
                    lastService = cameraSrv;
                    errorCode = cameraSrv.init(core, this, srvEntities[i]);
                    if (errorCode != 0) {
                        ((LiveCameraSrv)cameraSrv).shutdown();
                        this.logger.error("Creating " + (Object)((Object)lastService) + " failed with error [" + errorCode + "]");
                        return errorCode;
                    }
                    this.services[i] = cameraSrv;
                } else if (srvType == 9803L) {
                    TCPAlarmSrv tcpAlarmSrv = new TCPAlarmSrv();
                    lastService = tcpAlarmSrv;
                    errorCode = tcpAlarmSrv.init(core, this, srvEntities[i]);
                    if (errorCode != 0) {
                        tcpAlarmSrv.shutdown();
                        this.logger.error("Creating " + (Object)((Object)lastService) + " failed with error [" + errorCode + "]");
                        return errorCode;
                    }
                    this.services[i] = tcpAlarmSrv;
                } else if (srvType != 9801L && srvType != 9802L && srvType != 9911L && srvType != 9912L && srvType != 9813L) {
                    this.logger.warn("Service [" + Basic.longToFormattedString((long)srvType) + "] not supported for " + this);
                }
                if (!this.isShutdown(CLASS_NAME)) continue;
                this.logger.warn(this + " is already shutting down!");
                if (lastService == null) break;
                lastService.shutdown();
                break;
            }
            catch (Exception ex) {
                if (lastService != null) {
                    lastService.shutdown();
                }
                this.logger.error("Creating " + this + " failed ", (Throwable)ex);
                return -1;
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.info("There are [" + this.services.length + " services of " + this);
        }
        return 0;
    }

    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    @Override
    public int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        if (this.services != null) {
            for (Service service : this.services) {
                int errorCode;
                if (service == null || (errorCode = service.shutdown()) == 0) continue;
                this.logger.warn("Shutting down " + (Object)((Object)service) + " failed with error [" + errorCode + "] ");
            }
        }
        return super.shutdown();
    }

    @Override
    public int stopDevice() {
        return this.shutdown();
    }

    @Override
    public int handleAction(Long actionID, Long alarmScriptID, Long alarmInstanceID, Long alarmDuration, byte[] genericData) {
        this.logger.info("Action [" + actionID + "] of scenario [" + alarmScriptID + "] with duration [" + alarmDuration / 1000L + "," + alarmDuration % 1000L + " s] is triggered on " + this + " ...");
        IOHandler ioHandler = this.getIOHandler();
        if (ioHandler != null) {
            return ioHandler.triggerAction(actionID, alarmScriptID, alarmInstanceID, alarmDuration, genericData);
        }
        this.logger.error("Cannot get [IOHandler] for " + this);
        return -21600;
    }

    @Override
    public int initializeDevice(long entityType) {
        if (!this.initialized) {
            int errorCode;
            if (this.getDeviceType() != null && GENERIC_DEVICE_TYPE_LIST.contains(this.getDeviceType()) && (errorCode = this.getDefintions(Device.GenericDeviceType.VIDEO)) != 0) {
                this.logger.error("Error while reading defintions from device for " + this, new Throwable());
                return errorCode;
            }
            this.initialized = true;
        }
        return 0;
    }

    @Override
    protected SupportedGenericEventsType getGenericEventTrigger() throws SeeTecException, ConfigurationException {
        return null;
    }
}

